/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.manager.BaseManager;
import io.nuls.network.manager.StorageManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NodeGroupManager
extends BaseManager {
    private static NodeGroupManager nodeGroupManager = new NodeGroupManager();
    private StorageManager storageManager = StorageManager.getInstance();
    private Map<String, NodeGroup> nodeGroupMap = new ConcurrentHashMap<String, NodeGroup>();
    private ManagerStatusEnum status = ManagerStatusEnum.UNINITIALIZED;
    private static Map<String, String> magicNumChainIdMap = new ConcurrentHashMap<String, String>();

    public static NodeGroupManager getInstance() {
        return nodeGroupManager;
    }

    private NodeGroupManager() {
    }

    public List<IpAddressShare> getAvailableShareNodes(Node node, int getChainId, boolean isCrossAddress) {
        NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        ArrayList<IpAddressShare> addressList = new ArrayList<IpAddressShare>();
        ArrayList<Node> nodesList = new ArrayList<Node>();
        if (node.isCrossConnect()) {
            if (networkConfig.isMoonNode()) {
                nodesList.addAll(NodeGroupManager.getInstance().getMoonMainNet().getLocalShareToCrossCanConnectNodes().values());
            } else {
                nodesList.addAll(node.getNodeGroup().getLocalShareToCrossCanConnectNodes().values());
            }
        } else {
            NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(getChainId);
            if (isCrossAddress) {
                nodesList.addAll(nodeGroup.getCrossNodeContainer().getAllCanShareNodes().values());
            } else {
                nodesList.addAll(nodeGroup.getLocalNetNodeContainer().getAllCanShareNodes().values());
            }
        }
        this.addAddress(nodesList, addressList, node.getIp(), node.isCrossConnect());
        return addressList;
    }

    private void addAddress(Collection<Node> nodes, List<IpAddressShare> list, String fromIp, boolean isCross) {
        for (Node peer : nodes) {
            if (peer.getIp().equals(fromIp) || 2 != peer.getType()) continue;
            try {
                int port = peer.getRemotePort();
                int crossPort = peer.getRemoteCrossPort();
                if (isCross && 0 == crossPort) continue;
                IpAddressShare ipAddress = new IpAddressShare(peer.getIp(), port, crossPort);
                list.add(ipAddress);
            }
            catch (Exception e) {
                LoggerUtil.COMMON_LOG.error(e);
            }
        }
    }

    public Collection<NodeGroup> getNodeGroupCollection() {
        return this.nodeGroupMap.values();
    }

    public NodeGroup getNodeGroupByMagic(long magicNumber) {
        String chainId = magicNumChainIdMap.get(String.valueOf(magicNumber));
        if (null == chainId) {
            return null;
        }
        return this.nodeGroupMap.get(chainId);
    }

    public NodeGroup getNodeGroupByChainId(int chainId) {
        return this.nodeGroupMap.get(String.valueOf(chainId));
    }

    public NodeGroup getMoonMainNet() {
        NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        if (networkConfig.isMoonNode()) {
            return this.getNodeGroupByChainId(networkConfig.getChainId());
        }
        return null;
    }

    public List<NodeGroup> getNodeGroups() {
        return new ArrayList<NodeGroup>(this.nodeGroupMap.values());
    }

    public int getChainIdByMagicNum(long magicNum) {
        if (null != magicNumChainIdMap.get(String.valueOf(magicNum))) {
            return Integer.valueOf(magicNumChainIdMap.get(String.valueOf(magicNum)));
        }
        return 0;
    }

    public void addNodeGroup(int chainId, NodeGroup nodeGroup) {
        this.nodeGroupMap.put(String.valueOf(chainId), nodeGroup);
        magicNumChainIdMap.put(String.valueOf(nodeGroup.getMagicNumber()), String.valueOf(chainId));
        LoggerUtil.createLogs(chainId);
    }

    public void removeNodeGroup(int chainId) {
        NodeGroup nodeGroup = this.nodeGroupMap.remove(String.valueOf(chainId));
        if (null != nodeGroup) {
            magicNumChainIdMap.remove(String.valueOf(nodeGroup.getMagicNumber()));
        }
    }

    public boolean validMagicNumber(long magicNumber) {
        return null != magicNumChainIdMap.get(String.valueOf(magicNumber));
    }

    @Override
    public void init() {
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        NodeGroup nodeGroup = new NodeGroup();
        nodeGroupManager.addNodeGroup(networkConfig.getChainId(), nodeGroup);
        List<NodeGroup> list = this.storageManager.getAllNodeGroupFromDb();
        for (NodeGroup dbNodeGroup : list) {
            if (dbNodeGroup.getChainId() == nodeGroup.getChainId()) continue;
            dbNodeGroup.setCrossActive(true);
            nodeGroupManager.addNodeGroup(dbNodeGroup.getChainId(), dbNodeGroup);
        }
    }

    @Override
    public void start() {
        this.status = ManagerStatusEnum.RUNNING;
    }

    @Override
    public void change(ManagerStatusEnum toStatus) {
        if (toStatus == ManagerStatusEnum.STOPED) {
            this.nodeGroupMap.forEach((key, value) -> {
                value.reconnect(false);
                value.reconnect(true);
            });
        }
        this.status = toStatus;
    }
}

