/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.manager.BaseManager;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.po.GroupNodesPo;
import io.nuls.network.model.po.GroupPo;
import io.nuls.network.model.po.NodePo;
import io.nuls.network.storage.DbService;
import io.nuls.network.storage.impl.DbServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StorageManager
extends BaseManager {
    private static StorageManager storageManager = new StorageManager();
    private static Map<String, NodePo> cacheAllNodes = new ConcurrentHashMap<String, NodePo>();
    private DbService dbService = null;

    private StorageManager() {
    }

    public DbService getDbService() {
        return this.dbService;
    }

    public static StorageManager getInstance() {
        return storageManager;
    }

    List<NodeGroup> getAllNodeGroupFromDb() {
        ArrayList<NodeGroup> nodeGroups = new ArrayList<NodeGroup>();
        try {
            List<GroupPo> groupPos = this.dbService.getAllNodeGroups();
            for (GroupPo groupPo : groupPos) {
                nodeGroups.add((NodeGroup)groupPo.parseDto());
            }
        }
        catch (NulsException e) {
            Log.error((String)"", (Throwable)e);
        }
        return nodeGroups;
    }

    GroupNodesPo getNodesByChainId(int chainId) {
        try {
            return this.dbService.getNodesByChainId(chainId);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void init() throws Exception {
        this.dbService = (DbService)SpringLiteContext.getBean(DbServiceImpl.class);
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void change(ManagerStatusEnum toStatus) throws Exception {
    }
}

