/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.nuls.core.log.Log;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.manager.BaseManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.task.GroupStatusMonitor;
import io.nuls.network.task.HeartBeatTask;
import io.nuls.network.task.NodeDiscoverTask;
import io.nuls.network.task.NodeMaintenanceTask;
import io.nuls.network.task.NwInfosPrintTask;
import io.nuls.network.task.PeerCacheMsgSendTask;
import io.nuls.network.task.RPCCacheMsgSendTask;
import io.nuls.network.task.SaveNodeInfoTask;
import io.nuls.network.task.ShareAddressTask;
import io.nuls.network.task.TimeTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskManager
extends BaseManager {
    private static TaskManager taskManager = new TaskManager();
    private ScheduledThreadPoolExecutor executorService;
    private boolean clientThreadStart = false;

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        if (null == taskManager) {
            taskManager = new TaskManager();
        }
        return taskManager;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        this.executorService = ThreadUtils.createScheduledThreadPool((int)6, (NulsThreadFactory)new NulsThreadFactory("NetWorkThread"));
        this.connectTasks();
        this.scheduleGroupStatusMonitor();
        this.timeServiceThreadStart();
        this.nwInfosThread();
        this.peerCacheMsgSendTask();
        this.RPCMsgSendTask();
        this.heartBeatThread();
    }

    @Override
    public void change(ManagerStatusEnum toStatus) throws Exception {
    }

    private void connectTasks() {
        this.executorService.scheduleWithFixedDelay(new NodeMaintenanceTask(), 1L, 5L, TimeUnit.SECONDS);
        this.executorService.scheduleWithFixedDelay(new SaveNodeInfoTask(), 1L, 5L, TimeUnit.MINUTES);
        this.executorService.scheduleWithFixedDelay(new NodeDiscoverTask(), 3L, 10L, TimeUnit.SECONDS);
    }

    private void nwInfosThread() {
        this.executorService.scheduleWithFixedDelay(new NwInfosPrintTask(), 5L, 180L, TimeUnit.SECONDS);
    }

    private void heartBeatThread() {
        this.executorService.scheduleWithFixedDelay(new HeartBeatTask(), 5L, 25L, TimeUnit.SECONDS);
    }

    private void scheduleGroupStatusMonitor() {
        this.executorService.scheduleWithFixedDelay(new GroupStatusMonitor(), 5L, 10L, TimeUnit.SECONDS);
    }

    private void timeServiceThreadStart() {
        Log.debug((String)"----------- TimeService start -------------");
        TimeManager.getInstance().initWebTimeServer();
        ThreadUtils.createAndRunThread((String)"TimeTask", (Runnable)new TimeTask(), (boolean)true);
    }

    private void peerCacheMsgSendTask() {
        Log.debug((String)"----------- peerCacheMsgSendTask start -------------");
        ThreadUtils.createAndRunThread((String)"peerCacheMsgSendTask", (Runnable)new PeerCacheMsgSendTask(), (boolean)true);
    }

    private void RPCMsgSendTask() {
        Log.debug((String)"----------- RPCMsgSendTask start -------------");
        ThreadUtils.createAndRunThread((String)"RPCMsgSendTask", (Runnable)new RPCCacheMsgSendTask(), (boolean)true);
    }

    public void createShareAddressTask(NodeGroup nodeGroup, boolean isCross) {
        Log.debug((String)"----------- createShareAddressTask start -------------");
        ThreadUtils.createAndRunThread((String)"share-mine-node", (Runnable)new ShareAddressTask(nodeGroup, isCross));
    }
}

