/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.NetTimeUrl;
import io.nuls.network.model.message.GetTimeMessage;
import io.nuls.network.utils.LoggerUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

public class TimeManager {
    private static TimeManager instance = new TimeManager();
    private List<String> ntpSeverUrlList = new ArrayList<String>();
    private List<NetTimeUrl> netTimeSevers = new CopyOnWriteArrayList<NetTimeUrl>();
    public static final long TIME_OFFSET_BOUNDARY = 3000L;
    public static final long TIME_WAIT_PEER_RESPONSE = 2000L;
    public static final long NET_REFRESH_TIME = 120000L;
    public static long netTimeOffset;
    public static long lastSyncTime;
    private static final int MAX_REQ_PEER_NUMBER = 8;
    private static Map<String, Long> peerTimesMap;
    private static long currentRequestId;
    private long syncStartTime;
    private long syncEndTime;
    private long netTime;

    public static TimeManager getInstance() {
        return instance;
    }

    private TimeManager() {
        NulsCoresConfig networkConfig;
        String timeServers;
        if (0 == this.ntpSeverUrlList.size() && StringUtils.isNotBlank((String)(timeServers = (networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class)).getTimeServers()))) {
            String[] urlArray = timeServers.split(",");
            this.ntpSeverUrlList.addAll(Arrays.asList(urlArray));
        }
    }

    public void initWebTimeServer() {
        CountDownLatch latch = new CountDownLatch(this.ntpSeverUrlList.size());
        for (String url : this.ntpSeverUrlList) {
            ThreadUtils.asynExecuteRunnable(() -> {
                long syncStartTime = System.currentTimeMillis();
                long netTime = this.getWebTime(url);
                if (netTime > 0L) {
                    NetTimeUrl netTimeUrl = new NetTimeUrl(url, System.currentTimeMillis() - syncStartTime);
                    this.netTimeSevers.add(netTimeUrl);
                }
                latch.countDown();
            });
        }
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.error((String)"An exception occurred while waiting to obtain network time");
            System.exit(0);
        }
        if (this.netTimeSevers.size() < 3) {
            LoggerUtil.COMMON_LOG.warn("Available servers are less than3individual");
        }
        Collections.sort(this.netTimeSevers);
        LoggerUtil.COMMON_LOG.info("Initialize time server completed");
        LoggerUtil.COMMON_LOG.info("=".repeat(100));
        this.netTimeSevers.forEach(d -> LoggerUtil.COMMON_LOG.info("site:{} time consuming:{}", new Object[]{d.getUrl(), d.getTime()}));
        LoggerUtil.COMMON_LOG.info("=".repeat(100));
    }

    public void syncWebTime() {
        int count = 0;
        long[] times = new long[]{0L, 0L, 0L};
        for (int i = 0; i < this.netTimeSevers.size(); ++i) {
            this.syncStartTime = System.currentTimeMillis();
            this.netTime = this.getWebTime(this.netTimeSevers.get(i).getUrl());
            if (this.netTime == 0L) continue;
            this.syncEndTime = System.currentTimeMillis();
            times[count] = this.netTime + (this.syncEndTime - this.syncStartTime) / 2L - this.syncEndTime;
            if (++count >= 3) break;
        }
        if (count == 3) {
            TimeManager.calNetTimeOffset(times[0], times[1], times[2]);
        } else {
            LoggerUtil.COMMON_LOG.debug("count={} syncPeerTime .....", new Object[]{count});
            this.syncPeerTime();
        }
        lastSyncTime = TimeManager.currentTimeMillis();
    }

    public static void calNetTimeOffset(long time1, long time2, long time3) {
        long differMs = 500L;
        int count = 3;
        if (Math.abs(time1 - time2) > differMs && Math.abs(time1 - time3) > differMs) {
            time1 = 0L;
            --count;
        }
        if (Math.abs(time2 - time1) > differMs && Math.abs(time2 - time3) > differMs) {
            time2 = 0L;
            --count;
        }
        if (Math.abs(time3 - time1) > differMs && Math.abs(time3 - time2) > differMs) {
            time3 = 0L;
            --count;
        }
        if (count > 1) {
            netTimeOffset = (time1 + time2 + time3) / (long)count;
        }
    }

    private synchronized void syncPeerTime() {
        long beginTime = currentRequestId = System.currentTimeMillis();
        peerTimesMap.clear();
        List<NodeGroup> list = NodeGroupManager.getInstance().getNodeGroups();
        if (list.size() == 0) {
            return;
        }
        Collections.shuffle(list);
        int count = 0;
        boolean nodesEnough = false;
        for (NodeGroup nodeGroup : list) {
            Collection<Node> nodes = nodeGroup.getLocalNetNodeContainer().getConnectedNodes().values();
            for (Node node : nodes) {
                this.sendGetTimeMessage(node);
                if (++count < 8) continue;
                nodesEnough = true;
                break;
            }
            if (!nodesEnough) continue;
            break;
        }
        if (count == 0) {
            return;
        }
        long intervalTime = 0L;
        while (peerTimesMap.size() < 8 && intervalTime < 2000L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
                Thread.currentThread().interrupt();
            }
            intervalTime = System.currentTimeMillis() - beginTime;
        }
        int size = peerTimesMap.size();
        if (size > 0) {
            long sum = 0L;
            Set<String> set = peerTimesMap.keySet();
            for (String aSet : set) {
                sum += peerTimesMap.get(aSet.toString()).longValue();
            }
            netTimeOffset = sum / (long)size;
            LoggerUtil.COMMON_LOG.debug("syncPeerTime netTimeOffset={}", new Object[]{netTimeOffset});
        }
    }

    public static void addPeerTime(String nodeId, long requestId, long time) {
        if (currentRequestId == requestId && 8 > peerTimesMap.size()) {
            long localBeforeTime = currentRequestId;
            long localEndTime = System.currentTimeMillis();
            long value = time + (localEndTime - localBeforeTime) / 2L - localEndTime;
            peerTimesMap.put(nodeId, value);
        }
    }

    private void sendGetTimeMessage(Node node) {
        GetTimeMessage getTimeMessage = MessageFactory.getInstance().buildTimeRequestMessage(node.getMagicNumber(), currentRequestId);
        MessageManager.getInstance().sendHandlerMsg(getTimeMessage, node, true);
    }

    private long getWebTime(String address) {
        try {
            NTPUDPClient client = new NTPUDPClient();
            client.setDefaultTimeout(500);
            client.open();
            client.setSoTimeout(500);
            InetAddress inetAddress = InetAddress.getByName(address);
            TimeInfo timeInfo = client.getTime(inetAddress);
            return timeInfo.getMessage().getTransmitTimeStamp().getTime();
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.warn("address={} sync time fail", new Object[]{address});
            return 0L;
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis() + netTimeOffset;
    }

    static {
        peerTimesMap = new ConcurrentHashMap<String, Long>();
    }
}

