/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.AddrMessageBody;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AddrMessageHandler
extends BaseMessageHandler {
    private static AddrMessageHandler instance = new AddrMessageHandler();

    private AddrMessageHandler() {
    }

    public static AddrMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(message.getHeader().getMagicNumber());
        int chainId = nodeGroup.getChainId();
        AddrMessage addrMessage = (AddrMessage)message;
        if (null == addrMessage.getMsgBody()) {
            LoggerUtil.logger(chainId).error("rec error addr message.");
            return NetworkEventResult.getResultFail(NetworkErrorCode.NET_MESSAGE_ERROR);
        }
        List<IpAddressShare> ipAddressList = ((AddrMessageBody)((Object)addrMessage.getMsgBody())).getIpAddressList();
        if (node.isCrossConnect()) {
            return this.crossNetRecieveMessage(ipAddressList, nodeGroup);
        }
        AddrMessageBody addrMessageBody = (AddrMessageBody)((Object)message.getMsgBody());
        if (addrMessageBody.getIsCross() == 1) {
            int getMessageChainId = addrMessageBody.getChainId();
            NodeGroup messageNodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(getMessageChainId);
            if (null != messageNodeGroup) {
                return this.crossNetRecieveMessage(ipAddressList, messageNodeGroup);
            }
            return NetworkEventResult.getResultSuccess();
        }
        return this.commonNetRecieveMessage(ipAddressList, nodeGroup, node);
    }

    private boolean inValidateAddress(IpAddressShare ipAddress) {
        if (!IpUtil.isboolIp(ipAddress.getIpStr())) {
            return true;
        }
        return IpUtil.isSelf(ipAddress.getIpStr());
    }

    private NetworkEventResult commonNetRecieveMessage(List<IpAddressShare> ipAddressList, NodeGroup nodeGroup, Node node) {
        Map<String, Node> allNodes = nodeGroup.getLocalNetNodeContainer().getAllCanShareNodes();
        ArrayList<IpAddressShare> reShareAddrList = new ArrayList<IpAddressShare>();
        int chainId = nodeGroup.getChainId();
        for (IpAddressShare ipAddress : ipAddressList) {
            if (this.inValidateAddress(ipAddress)) continue;
            LoggerUtil.logger(chainId).debug("add check node address ={}:{} crossPort={}", new Object[]{ipAddress.getIp().getHostAddress(), ipAddress.getPort(), ipAddress.getCrossPort()});
            Node exsitNode = allNodes.get(ipAddress.getIpStr() + ":" + ipAddress.getPort());
            if (null != exsitNode) {
                if (ipAddress.getCrossPort() <= 0 || 0 != exsitNode.getRemoteCrossPort()) continue;
                exsitNode.setRemoteCrossPort(ipAddress.getCrossPort());
                reShareAddrList.add(ipAddress);
                nodeGroup.addCrossCheckNodes(ipAddress.getIp().getHostAddress(), ipAddress.getPort(), ipAddress.getCrossPort());
                LoggerUtil.logger(chainId).debug("update  ip={},crossPort={}", new Object[]{ipAddress.getIp().getHostAddress(), ipAddress.getCrossPort()});
            }
            nodeGroup.addNeedCheckNode(ipAddress.getIp().getHostAddress(), ipAddress.getPort(), ipAddress.getCrossPort(), node.isCrossConnect());
        }
        if (reShareAddrList.size() > 0) {
            AddrMessage reSendAddrMessage = MessageFactory.getInstance().buildAddrMessage(reShareAddrList, nodeGroup.getMagicNumber(), nodeGroup.getChainId(), (byte)0);
            LoggerUtil.logger(chainId).debug("reSendAddrMessage addrSize = {}", new Object[]{reShareAddrList.size()});
            MessageManager.getInstance().broadcastNewAddr(reSendAddrMessage, node, false, true);
        }
        return NetworkEventResult.getResultSuccess();
    }

    private NetworkEventResult crossNetRecieveMessage(List<IpAddressShare> ipAddressList, NodeGroup nodeGroup) {
        for (IpAddressShare ipAddress : ipAddressList) {
            if (this.inValidateAddress(ipAddress)) continue;
            LoggerUtil.logger(nodeGroup.getChainId()).debug("add check node address ={}:{} crossPort={}", new Object[]{ipAddress.getIp().getHostAddress(), ipAddress.getPort(), ipAddress.getCrossPort()});
            nodeGroup.addNeedCheckNode(ipAddress.getIp().getHostAddress(), ipAddress.getPort(), ipAddress.getCrossPort(), true);
        }
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("AddrMessageHandler Send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        return super.send(message, node, asyn);
    }
}

