/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.base.RPCUtil;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.MessageHandlerFactory;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.RpcCacheMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.base.MessageHeader;
import io.nuls.network.utils.LoggerUtil;
import java.util.HashMap;
import java.util.Map;

public class OtherModuleMessageHandler
extends BaseMessageHandler {
    private static OtherModuleMessageHandler instance = new OtherModuleMessageHandler();

    private OtherModuleMessageHandler() {
    }

    public static OtherModuleMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        return NetworkEventResult.getResultSuccess();
    }

    public NetworkEventResult recieve(MessageHeader header, byte[] payLoadBody, Node node) {
        long magicNum = header.getMagicNumber();
        int chainId = NodeGroupManager.getInstance().getChainIdByMagicNum(magicNum);
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("chainId", chainId);
        paramMap.put("nodeId", node.getId());
        String cmd = header.getCommandStr();
        paramMap.put("cmd", cmd);
        String messageBody = RPCUtil.encode((byte[])payLoadBody);
        paramMap.put("messageBody", messageBody);
        Map<String, CmdPriority> protocolRoles = MessageHandlerFactory.getInstance().getProtocolRoleHandlerMap(cmd);
        if (protocolRoles == null || protocolRoles.isEmpty()) {
            LoggerUtil.logger(chainId).error("unknown mssages. cmd={},handler may be unRegistered to network.", new Object[]{cmd});
            return NetworkEventResult.getResultSuccess();
        }
        for (Map.Entry<String, CmdPriority> entry : protocolRoles.entrySet()) {
            try {
                Request request = MessageUtil.newRequest((String)"msgProcess", paramMap, (String)"0", (String)"0", (String)"0");
                if (!"0".equals(ResponseMessageProcessor.requestOnly((String)entry.getKey(), (Request)request))) continue;
                if (nodeGroup.getCacheMsgQueue().size() > 100) {
                    LoggerUtil.COMMON_LOG.error("chainId = {},cmd={},CacheMsgQueue size={}.RPC fail,drop msg", new Object[]{chainId, cmd, nodeGroup.getCacheMsgQueue().size()});
                    continue;
                }
                LoggerUtil.COMMON_LOG.error("chainId = {},cmd={},RPC fail,add to cache", new Object[]{chainId, cmd});
                RpcCacheMessage peerMessage = new RpcCacheMessage(node.getId(), cmd, messageBody);
                nodeGroup.getCacheMsgQueue().addLast(peerMessage);
            }
            catch (Exception e) {
                LoggerUtil.logger(chainId).error("{}", new Object[]{e.getMessage()});
            }
        }
        return NetworkEventResult.getResultSuccess();
    }
}

