/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model;

import io.nuls.base.data.BaseNulsData;
import io.nuls.core.constant.ErrorCode;
import io.nuls.network.constant.NetworkErrorCode;

public class NetworkEventResult {
    private boolean success;
    private ErrorCode errorCode;
    private BaseNulsData resultData;

    public NetworkEventResult(boolean success, ErrorCode errorCode, BaseNulsData resultData) {
        this.success = success;
        this.errorCode = errorCode;
        this.resultData = resultData;
    }

    public NetworkEventResult(boolean success, ErrorCode errorCode) {
        this.success = success;
        this.errorCode = errorCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public BaseNulsData getResultData() {
        return this.resultData;
    }

    public void setResultData(BaseNulsData resultData) {
        this.resultData = resultData;
    }

    public static NetworkEventResult getResultSuccess() {
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS);
    }

    public static NetworkEventResult getResultSuccess(BaseNulsData resultData) {
        return new NetworkEventResult(true, NetworkErrorCode.SUCCESS, resultData);
    }

    public static NetworkEventResult getResultFail(ErrorCode errorCode) {
        return new NetworkEventResult(false, errorCode);
    }

    public static NetworkEventResult getResultFail(ErrorCode errorCode, BaseNulsData resultData) {
        return new NetworkEventResult(false, errorCode, resultData);
    }
}

