/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.message.base;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.network.model.message.base.MessageHeader;
import java.io.IOException;

public abstract class BaseMessage<T extends BaseNulsData>
extends BaseNulsData {
    private transient NulsHash hash;
    private MessageHeader header;
    private T msgBody;

    public BaseMessage() {
    }

    public BaseMessage(String command, long magicNumber) {
        this.header = new MessageHeader(command, magicNumber);
    }

    public BaseMessage(String command) {
        this.header = new MessageHeader(command);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        long checksum = this.getCheckSum();
        this.header.setChecksum(checksum);
        stream.write(this.header.serialize());
        stream.write(this.msgBody.serialize());
    }

    public long getCheckSum() throws IOException {
        byte[] data = null;
        data = null == this.msgBody || this.msgBody.size() == 0 ? ToolsConstant.PLACE_HOLDER : this.msgBody.serialize();
        byte[] bodyHash = Sha256Hash.hashTwice((byte[])data);
        byte[] get4Byte = ByteUtils.subBytes((byte[])bodyHash, (int)0, (int)4);
        long checksum = ByteUtils.bytesToBigInteger((byte[])get4Byte).longValue();
        return checksum;
    }

    public boolean isCheckSumValid() {
        try {
            return this.getCheckSum() == this.getHeader().getChecksum();
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        MessageHeader header = new MessageHeader();
        header.parse(byteBuffer);
        this.header = header;
        this.msgBody = this.parseMessageBody(byteBuffer);
    }

    protected abstract T parseMessageBody(NulsByteBuffer var1) throws NulsException;

    public int size() {
        int s = 0;
        s += this.header.size();
        return s += this.msgBody.size();
    }

    public T getMsgBody() {
        return this.msgBody;
    }

    public void setMsgBody(T msgBody) {
        this.msgBody = msgBody;
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public void setHeader(MessageHeader header) {
        this.header = header;
    }
}

