/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.Dto;
import io.nuls.network.model.po.BasePo;
import java.io.IOException;

public class GroupPo
extends BasePo {
    private long magicNumber = 0L;
    private int chainId = 0;
    private int maxOut = 0;
    private int maxIn = 0;
    private int maxCrossOut = 0;
    private int maxCrossIn = 0;
    private int minAvailableCount = 0;
    private boolean isCrossActive = false;
    private boolean isSelf = true;
    private boolean isMoonNet = false;

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfInt64();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfBoolean();
        return size += SerializeUtils.sizeOfBoolean();
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeInt64(this.magicNumber);
        stream.writeUint32((long)this.chainId);
        stream.writeUint32((long)this.maxOut);
        stream.writeUint32((long)this.maxIn);
        stream.writeUint32((long)this.maxCrossOut);
        stream.writeUint32((long)this.maxCrossIn);
        stream.writeUint32((long)this.minAvailableCount);
        stream.writeBoolean(this.isCrossActive);
        stream.writeBoolean(this.isSelf);
        stream.writeBoolean(this.isMoonNet);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.magicNumber = byteBuffer.readInt64();
        this.chainId = byteBuffer.readInt32();
        this.maxOut = byteBuffer.readInt32();
        this.maxIn = byteBuffer.readInt32();
        this.maxCrossOut = byteBuffer.readInt32();
        this.maxCrossIn = byteBuffer.readInt32();
        this.minAvailableCount = byteBuffer.readInt32();
        this.isCrossActive = byteBuffer.readBoolean();
        this.isSelf = byteBuffer.readBoolean();
        this.isMoonNet = byteBuffer.readBoolean();
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getMaxOut() {
        return this.maxOut;
    }

    public void setMaxOut(int maxOut) {
        this.maxOut = maxOut;
    }

    public int getMaxIn() {
        return this.maxIn;
    }

    public void setMaxIn(int maxIn) {
        this.maxIn = maxIn;
    }

    public int getMaxCrossOut() {
        return this.maxCrossOut;
    }

    public void setMaxCrossOut(int maxCrossOut) {
        this.maxCrossOut = maxCrossOut;
    }

    public int getMaxCrossIn() {
        return this.maxCrossIn;
    }

    public void setMaxCrossIn(int maxCrossIn) {
        this.maxCrossIn = maxCrossIn;
    }

    public int getMinAvailableCount() {
        return this.minAvailableCount;
    }

    public void setMinAvailableCount(int minAvailableCount) {
        this.minAvailableCount = minAvailableCount;
    }

    public boolean isCrossActive() {
        return this.isCrossActive;
    }

    public void setCrossActive(boolean crossActive) {
        this.isCrossActive = crossActive;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public void setSelf(boolean self) {
        this.isSelf = self;
    }

    public boolean isMoonNet() {
        return this.isMoonNet;
    }

    public void setMoonNet(boolean moonNet) {
        this.isMoonNet = moonNet;
    }

    @Override
    public Dto parseDto() {
        NodeGroup nodeGroup = new NodeGroup(this.magicNumber, this.chainId, this.maxIn, this.maxOut, this.minAvailableCount);
        return nodeGroup;
    }
}

