/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.network.model.Node;
import io.nuls.network.model.dto.Dto;
import io.nuls.network.model.po.BasePo;
import java.io.IOException;

public class NodePo
extends BasePo {
    private long magicNumber;
    private String id;
    private String ip;
    private int port = 0;
    private int crossPort = 0;
    private boolean isCrossConnect = false;
    private int status;
    private int failTimes = 0;

    public NodePo() {
    }

    public NodePo(long magicNumber, String id, String ip, int port, int crossPort, boolean isCrossConnect, int status, int failTimes) {
        this.magicNumber = magicNumber;
        this.ip = ip;
        this.id = id;
        this.port = port;
        this.crossPort = crossPort;
        this.isCrossConnect = isCrossConnect;
        this.status = status;
        this.failTimes = failTimes;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.magicNumber);
        stream.writeString(this.id);
        stream.writeString(this.ip);
        stream.writeUint16(this.port);
        stream.writeUint16(this.crossPort);
        stream.writeBoolean(this.isCrossConnect);
        stream.writeUint16(this.status);
        stream.writeUint16(this.failTimes);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.magicNumber = byteBuffer.readUint32();
        this.id = byteBuffer.readString();
        this.ip = byteBuffer.readString();
        this.port = byteBuffer.readUint16();
        this.crossPort = byteBuffer.readUint16();
        this.isCrossConnect = byteBuffer.readBoolean();
        this.status = byteBuffer.readUint16();
        this.failTimes = byteBuffer.readUint16();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfString((String)this.id);
        size += SerializeUtils.sizeOfString((String)this.ip);
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfUint16();
        return size += SerializeUtils.sizeOfUint16();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isCrossConnect() {
        return this.isCrossConnect;
    }

    public void setCrossConnect(boolean crossConnect) {
        this.isCrossConnect = crossConnect;
    }

    public int getCrossPort() {
        return this.crossPort;
    }

    public void setCrossPort(int crossPort) {
        this.crossPort = crossPort;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getFailTimes() {
        return this.failTimes;
    }

    public void setFailTimes(int failTimes) {
        this.failTimes = failTimes;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    @Override
    public Dto parseDto() {
        Node node = new Node(this.magicNumber, this.ip, this.port, this.crossPort, 2, this.isCrossConnect);
        node.setStatus(this.status);
        node.setSeedNode(false);
        node.setFailCount(this.failTimes);
        return node;
    }
}

