/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.network.model.dto.Dto;
import io.nuls.network.model.po.BasePo;
import io.nuls.network.model.po.NodePo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NodesContainerPo
extends BasePo {
    private List<NodePo> disConnectNodes = new ArrayList<NodePo>();
    private List<NodePo> canConnectNodes = new ArrayList<NodePo>();
    private List<NodePo> failNodes = new ArrayList<NodePo>();
    private List<NodePo> uncheckNodes = new ArrayList<NodePo>();

    public List<NodePo> getDisConnectNodes() {
        return this.disConnectNodes;
    }

    public void setDisConnectNodes(List<NodePo> disConnectNodes) {
        this.disConnectNodes = disConnectNodes;
    }

    public List<NodePo> getCanConnectNodes() {
        return this.canConnectNodes;
    }

    public void setCanConnectNodes(List<NodePo> canConnectNodes) {
        this.canConnectNodes = canConnectNodes;
    }

    public List<NodePo> getFailNodes() {
        return this.failNodes;
    }

    public void setFailNodes(List<NodePo> failNodes) {
        this.failNodes = failNodes;
    }

    public List<NodePo> getUncheckNodes() {
        return this.uncheckNodes;
    }

    public void setUncheckNodes(List<NodePo> uncheckNodes) {
        this.uncheckNodes = uncheckNodes;
    }

    protected void parseNodePo(NulsByteBuffer byteBuffer, List<NodePo> nodes) throws NulsException {
        int size = (int)byteBuffer.readVarInt();
        if (0 < size) {
            for (int i = 0; i < size; ++i) {
                NodePo nodePo = new NodePo();
                nodePo.parse(byteBuffer);
                nodes.add(nodePo);
            }
        }
    }

    @Override
    public Dto parseDto() {
        return null;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        int disConnectNodesSize = this.disConnectNodes == null ? 0 : this.disConnectNodes.size();
        stream.writeVarInt(disConnectNodesSize);
        if (null != this.disConnectNodes) {
            for (NodePo nodePo : this.disConnectNodes) {
                nodePo.serializeToStream(stream);
            }
        }
        int canConnectNodesSize = this.canConnectNodes == null ? 0 : this.canConnectNodes.size();
        stream.writeVarInt(canConnectNodesSize);
        if (null != this.canConnectNodes) {
            for (NodePo nodePo : this.canConnectNodes) {
                nodePo.serializeToStream(stream);
            }
        }
        int n = this.failNodes == null ? 0 : this.failNodes.size();
        stream.writeVarInt(n);
        if (null != this.failNodes) {
            for (NodePo nodePo : this.failNodes) {
                nodePo.serializeToStream(stream);
            }
        }
        int n2 = this.uncheckNodes == null ? 0 : this.uncheckNodes.size();
        stream.writeVarInt(n2);
        if (null != this.uncheckNodes) {
            for (NodePo nodePo : this.uncheckNodes) {
                nodePo.serializeToStream(stream);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.parseNodePo(byteBuffer, this.disConnectNodes);
        this.parseNodePo(byteBuffer, this.canConnectNodes);
        this.parseNodePo(byteBuffer, this.failNodes);
        this.parseNodePo(byteBuffer, this.uncheckNodes);
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfVarInt((Integer)(this.disConnectNodes == null ? 0 : this.disConnectNodes.size()));
        if (null != this.disConnectNodes) {
            for (NodePo nodePo : this.disConnectNodes) {
                size += nodePo.size();
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.canConnectNodes == null ? 0 : this.canConnectNodes.size()));
        if (null != this.canConnectNodes) {
            for (NodePo nodePo : this.canConnectNodes) {
                size += nodePo.size();
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.failNodes == null ? 0 : this.failNodes.size()));
        if (null != this.failNodes) {
            for (NodePo nodePo : this.failNodes) {
                size += nodePo.size();
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.uncheckNodes == null ? 0 : this.uncheckNodes.size()));
        if (null != this.uncheckNodes) {
            for (NodePo nodePo : this.uncheckNodes) {
                size += nodePo.size();
            }
        }
        return size;
    }
}

