/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.log.Log;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.handler.base.BaseChannelHandler;
import io.nuls.network.model.Node;
import io.nuls.network.utils.LoggerUtil;
import java.io.IOException;

public class ClientChannelHandler
extends BaseChannelHandler {
    private AttributeKey<Node> key = AttributeKey.valueOf((String)"node");

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        Attribute nodeAttribute = ctx.channel().attr(this.key);
        Node node = (Node)nodeAttribute.get();
        if (node != null && node.getRegisterListener() != null) {
            node.getRegisterListener().action();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        Attribute nodeAttribute = ctx.channel().attr(this.key);
        Node node = (Node)nodeAttribute.get();
        if (node != null) {
            node.setChannel(ctx.channel());
        }
        if (node != null && node.getConnectedListener() != null) {
            node.getConnectedListener().action();
        }
        ctx.channel().config().setWriteBufferHighWaterMark(0x800000);
        ctx.channel().config().setWriteBufferLowWaterMark(0x400000);
        LoggerUtil.COMMON_LOG.debug("Client Node is active:{}", new Object[]{node != null ? node.getId() : null});
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        SocketChannel socketChannel = (SocketChannel)ctx.channel();
        String remoteIP = socketChannel.remoteAddress().getHostString();
        int port = socketChannel.remoteAddress().getPort();
        ByteBuf buf = (ByteBuf)msg;
        NulsByteBuffer byteBuffer = null;
        Node node = null;
        try {
            Attribute nodeAttribute = ctx.channel().attr(this.key);
            node = (Node)nodeAttribute.get();
            if (node != null) {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                byteBuffer = new NulsByteBuffer(bytes);
            } else {
                Log.error((String)("-----------------client channelRead  node is null -----------------" + remoteIP + ":" + port));
                ctx.channel().close();
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
        finally {
            buf.clear();
        }
        MessageManager.getInstance().receiveMessage(byteBuffer, node);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        Attribute nodeAttribute = ctx.channel().attr(this.key);
        Node node = (Node)nodeAttribute.get();
        if (node != null && node.getDisconnectListener() != null) {
            LoggerUtil.COMMON_LOG.debug("-----------------client channelInactive  node is channelUnregistered node={}-----------------", new Object[]{node.getId()});
            node.getDisconnectListener().action();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (!(cause instanceof IOException)) {
            LoggerUtil.COMMON_LOG.error(cause.getMessage(), cause);
        }
        ctx.channel().close();
    }
}

