/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;

public class HeartbeatServerHandler
extends ChannelInboundHandlerAdapter {
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            SocketChannel channel = (SocketChannel)ctx.channel();
            String nodeId = IpUtil.getNodeId(channel.remoteAddress());
            LoggerUtil.COMMON_LOG.info("{}====userEventTriggered  IdleStateEvent==", new Object[]{nodeId});
            IdleStateEvent event = (IdleStateEvent)evt;
            String type = "";
            if (event.state() == IdleState.READER_IDLE) {
                type = "read idle";
            } else if (event.state() == IdleState.WRITER_IDLE) {
                type = "write idle";
            } else if (event.state() == IdleState.ALL_IDLE) {
                type = "all idle";
            }
            LoggerUtil.COMMON_LOG.info("localInfo: " + channel.localAddress().getHostString() + ":" + channel.localAddress().getPort());
            LoggerUtil.COMMON_LOG.info("remoteInfo: " + channel.remoteAddress().getHostString() + ":" + channel.remoteAddress().getPort());
            ctx.channel().close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

