/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.rpc.call.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.model.dto.BestBlockInfo;
import io.nuls.network.rpc.call.BlockRpcService;
import io.nuls.network.utils.LoggerUtil;
import java.util.HashMap;
import java.util.Map;

@Component
public class BlockRpcServiceImpl
implements BlockRpcService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BestBlockInfo getBestBlockHeader(int chainId) {
        BestBlockInfo bestBlockInfo;
        block5: {
            bestBlockInfo = new BestBlockInfo();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("chainId", chainId);
            try {
                LoggerUtil.logger(chainId).debug("getBestBlockHeader begin time={}", new Object[]{TimeManager.currentTimeMillis()});
                Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"latestBlockHeader", map, (long)1000L);
                if (null != response && response.isSuccess()) {
                    Map responseData = (Map)response.getResponseData();
                    Map result = (Map)responseData.get("latestBlockHeader");
                    BlockHeader header = new BlockHeader();
                    header.parse(new NulsByteBuffer(RPCUtil.decode((String)((String)result.get("value")))));
                    bestBlockInfo.setHash(header.getHash().toHex());
                    bestBlockInfo.setBlockHeight(header.getHeight());
                    break block5;
                }
                LoggerUtil.logger(chainId).error("getBestBlockHeader fail.response={}", new Object[]{JSONUtils.obj2json((Object)response)});
            }
            catch (Exception e) {
                try {
                    LoggerUtil.logger(chainId).error("getBestBlockHeader error,chainId={}.exception={}", new Object[]{chainId, e.getMessage()});
                }
                catch (Throwable throwable) {
                    LoggerUtil.logger(chainId).debug("getBestBlockHeader height ={},hash={}", new Object[]{bestBlockInfo.getBlockHeight(), bestBlockInfo.getHash()});
                    throw throwable;
                }
                LoggerUtil.logger(chainId).debug("getBestBlockHeader height ={},hash={}", new Object[]{bestBlockInfo.getBlockHeight(), bestBlockInfo.getHash()});
            }
        }
        LoggerUtil.logger(chainId).debug("getBestBlockHeader height ={},hash={}", new Object[]{bestBlockInfo.getBlockHeight(), bestBlockInfo.getHash()});
        return bestBlockInfo;
    }
}

