/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.MessageHandlerFactory;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.message.base.MessageHeader;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NW)
public class MessageRpc
extends BaseCmd {
    private MessageHandlerFactory messageHandlerFactory = MessageHandlerFactory.getInstance();

    @CmdAnnotation(cmd="nw_protocolRegister", version=1.0, description="Module Protocol Instruction Registration")
    @Parameters(value={@Parameter(parameterName="role", requestType=@TypeDescriptor(value=String.class), parameterDes="Module Role Name"), @Parameter(parameterName="protocolCmds", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Register Instruction List")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response protocolRegister(Map params) {
        String role = String.valueOf(params.get("role"));
        try {
            this.messageHandlerFactory.clearCacheProtocolRoleHandlerMap(role);
            List protocolCmds = (List)params.get("protocolCmds");
            for (String cmd : protocolCmds) {
                this.messageHandlerFactory.addProtocolRoleHandlerMap(cmd, CmdPriority.DEFAULT, role);
            }
            Log.info((String)"----------------------------new message register---------------------------");
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(role, e);
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        return this.success();
    }

    @CmdAnnotation(cmd="protocolRegisterWithPriority", version=1.0, description="Module protocol instruction registration with priority parameters")
    @Parameters(value={@Parameter(parameterName="role", requestType=@TypeDescriptor(value=String.class), parameterDes="Module Role Name"), @Parameter(parameterName="protocolCmds", requestType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="cmd", valueType=String.class, description="Protocol instruction name,12byte"), @Key(name="priority", valueType=String.class, description="priority,3Level,HIGH,DEFAULT,LOWER")}), parameterDes="Register Instruction List")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response protocolRegisterWithPriority(Map params) {
        String role = String.valueOf(params.get("role"));
        try {
            this.messageHandlerFactory.clearCacheProtocolRoleHandlerMap(role);
            List protocolCmds = (List)params.get("protocolCmds");
            for (Map cmdMap : protocolCmds) {
                String cmd = (String)cmdMap.get("cmd");
                String priority = cmdMap.get("priority") == null ? "DEFAULT" : cmdMap.get("priority").toString();
                this.messageHandlerFactory.addProtocolRoleHandlerMap(cmd, CmdPriority.valueOf((String)priority), role);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(role, e);
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        return this.success();
    }

    @CmdAnnotation(cmd="nw_broadcast", version=1.0, description="Broadcast messages")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="excludeNodes", requestType=@TypeDescriptor(value=String.class), parameterDes="eliminatepeernodeId, separated by commas"), @Parameter(parameterName="messageBody", requestType=@TypeDescriptor(value=String.class), parameterDes="Message BodyHex"), @Parameter(parameterName="command", requestType=@TypeDescriptor(value=String.class), parameterDes="Message Protocol Instructions"), @Parameter(parameterName="isCross", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Is it cross chain"), @Parameter(parameterName="percent", requestType=@TypeDescriptor(value=int.class), parameterDes="Broadcast transmission ratio,Not filled in,default100")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Returned when no node has been sent outfalse")}))
    public Response broadcast(Map params) {
        HashMap<String, Boolean> rtMap = new HashMap<String, Boolean>();
        rtMap.put("value", true);
        int percent = 100;
        try {
            int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
            Object excludeNodes = String.valueOf(params.get("excludeNodes"));
            String messageBodyStr = String.valueOf(params.get("messageBody"));
            byte[] messageBody = RPCUtil.decode((String)messageBodyStr);
            String cmd = String.valueOf(params.get("command"));
            Object percentParam = params.get("percent");
            if (null != percentParam) {
                percent = Integer.valueOf(String.valueOf(percentParam));
            }
            MessageManager messageManager = MessageManager.getInstance();
            NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
            if (null == nodeGroup) {
                return this.failed(NetworkErrorCode.PARAMETER_ERROR);
            }
            long magicNumber = nodeGroup.getMagicNumber();
            long checksum = messageManager.getCheckSum(messageBody);
            MessageHeader header = new MessageHeader(cmd, magicNumber, checksum, messageBody.length);
            byte[] headerByte = header.serialize();
            byte[] message = new byte[headerByte.length + messageBody.length];
            boolean isCross = false;
            if (null != params.get("isCross")) {
                isCross = Boolean.valueOf(params.get("isCross").toString());
            }
            System.arraycopy(headerByte, 0, message, 0, headerByte.length);
            System.arraycopy(messageBody, 0, message, headerByte.length, messageBody.length);
            List<Node> nodesCollection = nodeGroup.getAvailableNodes(isCross);
            excludeNodes = "," + (String)excludeNodes + ",";
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node node : nodesCollection) {
                if (((String)excludeNodes).contains("," + node.getId() + ",")) continue;
                nodes.add(node);
            }
            if (0 == nodes.size()) {
                rtMap.put("value", false);
            } else {
                messageManager.broadcastToNodes(message, cmd, nodes, true, percent);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="nw_sendPeersMsg", version=1.0, description="Send messages to specified nodes")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="nodes", requestType=@TypeDescriptor(value=String.class), parameterDes="Specify sendingpeernodeIdString concatenated with commas"), @Parameter(parameterName="messageBody", requestType=@TypeDescriptor(value=String.class), parameterDes="Message BodyHex"), @Parameter(parameterName="command", requestType=@TypeDescriptor(value=String.class), parameterDes="Message Protocol Instructions")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response sendPeersMsg(Map params) {
        try {
            int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
            String nodes = String.valueOf(params.get("nodes"));
            String messageBodyStr = String.valueOf(params.get("messageBody"));
            byte[] messageBody = RPCUtil.decode((String)messageBodyStr);
            String cmd = String.valueOf(params.get("command"));
            MessageManager messageManager = MessageManager.getInstance();
            NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
            NodeGroup nodeGroup = nodeGroupManager.getNodeGroupByChainId(chainId);
            long magicNumber = nodeGroup.getMagicNumber();
            long checksum = messageManager.getCheckSum(messageBody);
            MessageHeader header = new MessageHeader(cmd, magicNumber, checksum, messageBody.length);
            byte[] headerByte = header.serialize();
            byte[] message = new byte[headerByte.length + messageBody.length];
            System.arraycopy(headerByte, 0, message, 0, headerByte.length);
            System.arraycopy(messageBody, 0, message, headerByte.length, messageBody.length);
            String[] nodeIds = nodes.split(",");
            ArrayList<Node> nodesList = new ArrayList<Node>();
            for (String nodeId : nodeIds) {
                Node availableNode = nodeGroup.getAvailableNode(nodeId);
                if (null != availableNode) {
                    nodesList.add(availableNode);
                    continue;
                }
                LoggerUtil.logger(chainId).error("cmd={},node = {} is not available!", new Object[]{cmd, nodeId});
            }
            if (nodesList.size() > 0) {
                messageManager.broadcastToNodes(message, cmd, nodesList, true, 100);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        return this.success();
    }
}

