/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.rpc.cmd;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.network.constant.NetworkErrorCode;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.vo.NodeVo;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NW)
public class NodeRpc
extends BaseCmd {
    private NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
    private static final int STATE_ALL = 0;
    private static final int STATE_CONNECT = 1;
    private static final int STATE_DIS_CONNECT = 2;
    @Autowired
    NulsCoresConfig networkConfig;

    @CmdAnnotation(cmd="nw_addNodes", version=1.0, description="Add nodes to be connected")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="isCross", requestType=@TypeDescriptor(value=int.class), parameterDes="1Cross chain connection,0Normal connection"), @Parameter(parameterName="nodes", requestType=@TypeDescriptor(value=String.class), parameterDes="Node groupIDComma splicing")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response addNodes(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        int isCross = Integer.valueOf(String.valueOf(params.get("isCross")));
        try {
            String nodes = String.valueOf(params.get("nodes"));
            if (chainId < 0 || StringUtils.isBlank((String)nodes)) {
                return this.failed(NetworkErrorCode.PARAMETER_ERROR);
            }
            boolean blCross = false;
            if (1 == isCross) {
                blCross = true;
            }
            String[] peers = nodes.split(",");
            NodeGroup nodeGroup = this.nodeGroupManager.getNodeGroupByChainId(chainId);
            ArrayList nodePos = new ArrayList();
            for (String peer : peers) {
                String[] ipPort = IpUtil.changeHostToIp(peer);
                if (null == ipPort) continue;
                if (blCross) {
                    nodeGroup.addNeedCheckNode(ipPort[0], Integer.valueOf(ipPort[1]), Integer.valueOf(ipPort[1]), blCross);
                    continue;
                }
                nodeGroup.addNeedCheckNode(ipPort[0], Integer.valueOf(ipPort[1]), 0, blCross);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
            return this.failed(e.getMessage());
        }
        return this.success();
    }

    @CmdAnnotation(cmd="nw_delNodes", version=1.0, description="Delete node group node")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="nodes", requestType=@TypeDescriptor(value=String.class), parameterDes="Node groupIDComma splicing")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response delNodes(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        String nodes = String.valueOf(params.get("nodes"));
        if (chainId < 0 || StringUtils.isBlank((String)nodes)) {
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        String[] peers = nodes.split(",");
        NodeGroup nodeGroup = this.nodeGroupManager.getNodeGroupByChainId(chainId);
        for (String nodeId : peers) {
            if (null == (nodeId = IpUtil.changeHostToIpStr(nodeId))) continue;
            Node node = nodeGroup.getLocalNetNodeContainer().getConnectedNodes().get(nodeId);
            if (null != node) {
                node.close();
            } else {
                nodeGroup.getLocalNetNodeContainer().getCanConnectNodes().remove(nodeId);
                nodeGroup.getLocalNetNodeContainer().getUncheckNodes().remove(nodeId);
                nodeGroup.getLocalNetNodeContainer().getDisconnectNodes().remove(nodeId);
                nodeGroup.getLocalNetNodeContainer().getFailNodes().remove(nodeId);
            }
            node = nodeGroup.getCrossNodeContainer().getConnectedNodes().get(nodeId);
            if (null != node) {
                node.close();
                continue;
            }
            nodeGroup.getCrossNodeContainer().getCanConnectNodes().remove(nodeId);
            nodeGroup.getCrossNodeContainer().getUncheckNodes().remove(nodeId);
            nodeGroup.getCrossNodeContainer().getDisconnectNodes().remove(nodeId);
            nodeGroup.getCrossNodeContainer().getFailNodes().remove(nodeId);
        }
        return this.success();
    }

    @CmdAnnotation(cmd="nw_getNodes", version=1.0, description="Paging to view connection node information,startPageRelated topageSize All for0When not paginated, returns all node information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="state", requestType=@TypeDescriptor(value=int.class), parameterDes="0:All connections,1:Connected  2:Not connected"), @Parameter(parameterName="isCross", requestType=@TypeDescriptor(value=boolean.class), parameterDes="false:Non cross chain connection,true:Cross chain connection"), @Parameter(parameterName="startPage", requestType=@TypeDescriptor(value=int.class), parameterDes="Number of starting pages for pagination"), @Parameter(parameterName="pageSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Display quantity per page")})
    @ResponseData(description="Return node list information", responseType=@TypeDescriptor(value=NodeVo.class))
    public Response getNodes(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        int state = Integer.valueOf(String.valueOf(params.get("state")));
        boolean isCross = Boolean.valueOf(String.valueOf(params.get("isCross")));
        int startPage = Integer.valueOf(String.valueOf(params.get("startPage")));
        int pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByChainId(chainId);
        if (null == nodeGroup) {
            LoggerUtil.COMMON_LOG.error("chainId={} not get a net group.", new Object[]{chainId});
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (isCross) {
            this.addNode(nodes, state, nodeGroup.getCrossNodeContainer());
        } else {
            this.addNode(nodes, state, nodeGroup.getLocalNetNodeContainer());
        }
        int total = nodes.size();
        ArrayList<NodeVo> pageList = new ArrayList<NodeVo>();
        if (0 == startPage && 0 == pageSize) {
            for (Node node : nodes) {
                pageList.add(this.buildNodeVo(node, nodeGroup.getMagicNumber(), chainId));
            }
        } else {
            int currIdx = startPage > 1 ? (startPage - 1) * pageSize : 0;
            for (int i = 0; i < pageSize && i < total - currIdx; ++i) {
                Node node = (Node)nodes.get(currIdx + i);
                NodeVo nodeVo = this.buildNodeVo(node, nodeGroup.getMagicNumber(), chainId);
                pageList.add(nodeVo);
            }
        }
        return this.success(pageList);
    }

    private void addNode(List<Node> nodes, int state, NodesContainer nodesContainer) {
        if (0 == state) {
            nodes.addAll(nodesContainer.getConnectedNodes().values());
            nodes.addAll(nodesContainer.getCanConnectNodes().values());
            nodes.addAll(nodesContainer.getDisconnectNodes().values());
            nodes.addAll(nodesContainer.getUncheckNodes().values());
            nodes.addAll(nodesContainer.getFailNodes().values());
        } else if (1 == state) {
            nodes.addAll(nodesContainer.getAvailableNodes());
        } else if (2 == state) {
            nodes.addAll(nodesContainer.getCanConnectNodes().values());
            nodes.addAll(nodesContainer.getDisconnectNodes().values());
            nodes.addAll(nodesContainer.getUncheckNodes().values());
            nodes.addAll(nodesContainer.getFailNodes().values());
        }
    }

    @CmdAnnotation(cmd="nw_updateNodeInfo", version=1.0, description="Update connection node information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Connected ChainId,Value range[1-65535]"), @Parameter(parameterName="nodeId", requestType=@TypeDescriptor(value=String.class), parameterDes="Connecting nodesID"), @Parameter(parameterName="blockHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="block height"), @Parameter(parameterName="blockHash", requestType=@TypeDescriptor(value=String.class), parameterDes="blockhashvalue")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response updateNodeInfo(Map params) {
        int chainId = Integer.valueOf(String.valueOf(params.get("chainId")));
        String nodeId = String.valueOf(params.get("nodeId"));
        long blockHeight = Long.valueOf(String.valueOf(params.get("blockHeight")));
        String blockHash = String.valueOf(params.get("blockHash"));
        NodeGroup nodeGroup = this.nodeGroupManager.getNodeGroupByChainId(chainId);
        if (null == nodeGroup) {
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        Node node = nodeGroup.getConnectedNode(nodeId);
        if (null == node) {
            return this.failed(NetworkErrorCode.PARAMETER_ERROR);
        }
        node.setBlockHash(blockHash);
        node.setBlockHeight(blockHeight);
        return this.success();
    }

    private NodeVo buildNodeVo(Node node, long magicNumber, int chainId) {
        NodeVo nodeVo = new NodeVo();
        nodeVo.setBlockHash(node.getBlockHash());
        nodeVo.setBlockHeight(node.getBlockHeight());
        nodeVo.setState(node.getConnectStatus() == 5 ? 1 : 0);
        nodeVo.setTime(node.getConnectTime());
        nodeVo.setChainId(chainId);
        nodeVo.setIp(node.getIp());
        nodeVo.setIsOut(node.getType() == 2 ? 1 : 0);
        nodeVo.setMagicNumber(magicNumber);
        nodeVo.setNodeId(node.getId());
        nodeVo.setPort(node.getRemotePort());
        return nodeVo;
    }
}

