/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.storage.impl;

import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.po.GroupNodesPo;
import io.nuls.network.model.po.GroupPo;
import io.nuls.network.storage.DbService;
import io.nuls.network.storage.InitDB;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class DbServiceImpl
implements DbService,
InitDB,
InitializingBean {
    private static String DEFAULT_ENCODING = "UTF-8";

    @Override
    public List<GroupPo> getAllNodeGroups() throws NulsException {
        List nodeGroupBytes = RocksDBService.valueList((String)"nw_groups");
        ArrayList<GroupPo> list = new ArrayList<GroupPo>();
        try {
            if (null != nodeGroupBytes && nodeGroupBytes.size() > 0) {
                for (byte[] poBytes : nodeGroupBytes) {
                    GroupPo nodeGroupPo = new GroupPo();
                    nodeGroupPo.parse(poBytes, 0);
                    list.add(nodeGroupPo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            throw new NulsException((Throwable)e);
        }
        return list;
    }

    @Override
    public void saveNodes(NodeGroup nodeGroup) {
        int chainId = nodeGroup.getChainId();
        GroupNodesPo groupNodesPo = new GroupNodesPo();
        try {
            groupNodesPo.setCrossNodeContainer(nodeGroup.getCrossNodeContainer().parseToNodesContainerPo());
            groupNodesPo.setSelfNodeContainer(nodeGroup.getLocalNetNodeContainer().parseToNodesContainerPo());
            RocksDBService.put((String)"nw_group_nodes", (byte[])ByteUtils.intToBytes((int)chainId), (byte[])groupNodesPo.serialize());
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    @Override
    public GroupNodesPo getNodesByChainId(int chainId) throws NulsException {
        byte[] bytes = RocksDBService.get((String)"nw_group_nodes", (byte[])ByteUtils.intToBytes((int)chainId));
        GroupNodesPo groupNodesPo = new GroupNodesPo();
        groupNodesPo.parse(bytes, 0);
        return groupNodesPo;
    }

    @Override
    public void deleteGroup(int chainId) {
        try {
            RocksDBService.delete((String)"nw_groups", (byte[])String.valueOf(chainId).getBytes(DEFAULT_ENCODING));
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    @Override
    public GroupPo getNodeGroupByChainId(int chainId) throws NulsException {
        byte[] bytes = RocksDBService.get((String)"nw_groups", (byte[])ByteUtils.intToBytes((int)chainId));
        GroupPo nodeGroupPo = new GroupPo();
        nodeGroupPo.parse(bytes, 0);
        return nodeGroupPo;
    }

    @Override
    public void saveNodeGroups(List<GroupPo> nodeGroups) {
        HashMap<byte[], byte[]> nodeGroupsMap = new HashMap<byte[], byte[]>();
        try {
            for (GroupPo nodeGroupPo : nodeGroups) {
                nodeGroupsMap.put(ByteUtils.intToBytes((int)nodeGroupPo.getChainId()), nodeGroupPo.serialize());
            }
            RocksDBService.batchPut((String)"nw_groups", nodeGroupsMap);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    public void afterPropertiesSet() throws NulsException {
    }

    @Override
    public void initTableName() throws NulsException {
        try {
            if (!RocksDBService.existTable((String)"nw_groups")) {
                RocksDBService.createTable((String)"nw_groups");
            }
            if (!RocksDBService.existTable((String)"nw_group_nodes")) {
                RocksDBService.createTable((String)"nw_group_nodes");
            }
            if (!RocksDBService.existTable((String)"nw_protocol_register")) {
                RocksDBService.createTable((String)"nw_protocol_register");
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            throw new NulsException((Throwable)e);
        }
    }
}

