/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TaskManager;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.utils.LoggerUtil;
import java.util.List;

public class GroupStatusMonitor
implements Runnable {
    @Override
    public void run() {
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        List<NodeGroup> nodeGroupList = nodeGroupManager.getNodeGroups();
        for (NodeGroup nodeGroup : nodeGroupList) {
            if (nodeGroup.isMoonCrossGroup()) {
                this.updateStatus(nodeGroup.getCrossNodeContainer(), nodeGroup, true);
                continue;
            }
            if (nodeGroup.isMoonGroup()) {
                this.updateStatus(nodeGroup.getLocalNetNodeContainer(), nodeGroup, false);
                continue;
            }
            this.updateStatus(nodeGroup.getLocalNetNodeContainer(), nodeGroup, false);
            this.updateStatus(nodeGroup.getCrossNodeContainer(), nodeGroup, true);
        }
    }

    private void updateStatus(NodesContainer nodesContainer, NodeGroup nodeGroup, boolean isCross) {
        if (1 == nodesContainer.getStatus()) {
            long time = nodesContainer.getLatestHandshakeSuccTime() + 10000L;
            if (time < System.currentTimeMillis() && nodesContainer.getAvailableNodes().size() > 0) {
                nodesContainer.setStatus(2);
                LoggerUtil.logger(nodeGroup.getChainId()).info("ChainId={} isCross={} NET STATUS UPDATE TO OK", new Object[]{nodeGroup.getChainId(), isCross});
            }
        } else if (2 == nodesContainer.getStatus()) {
            if (nodeGroup.isActive(isCross)) {
                nodesContainer.setStatus(3);
                if (!nodesContainer.isHadShareAddr()) {
                    TaskManager.getInstance().createShareAddressTask(nodeGroup, isCross);
                    nodesContainer.setHadShareAddr(true);
                }
            }
        } else if (3 == nodesContainer.getStatus() && !nodeGroup.isActive(isCross)) {
            nodesContainer.setStatus(2);
            LoggerUtil.logger(nodeGroup.getChainId()).info("ChainId={},isCross={} NET STATUS UPDATE TO WAITING", new Object[]{nodeGroup.getChainId(), isCross});
        }
    }
}

