/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.BestBlockInfo;
import io.nuls.network.model.message.PeerInfoMessage;
import io.nuls.network.rpc.call.impl.BlockRpcServiceImpl;
import java.util.List;

public class LocalInfosSendTask
implements Runnable {
    @Override
    public void run() {
        this.broadcastLocalInfos();
    }

    private void broadcastLocalInfos() {
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        List<NodeGroup> nodeGroupList = nodeGroupManager.getNodeGroups();
        for (NodeGroup nodeGroup : nodeGroupList) {
            BlockRpcServiceImpl blockRpcServiceImpl = (BlockRpcServiceImpl)SpringLiteContext.getBean(BlockRpcServiceImpl.class);
            BestBlockInfo bestBlockInfo = blockRpcServiceImpl.getBestBlockHeader(nodeGroup.getChainId());
            if (bestBlockInfo.getBlockHeight() == 0L) continue;
            PeerInfoMessage peerInfoMessage = MessageFactory.getInstance().buildPeerInfoMessage(nodeGroup.getMagicNumber(), bestBlockInfo);
            NetworkEventResult networkEventResult = MessageManager.getInstance().broadcastToAllNode(peerInfoMessage, null, false, true);
        }
    }
}

