/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.core.log.Log;
import io.nuls.network.manager.ConnectionManager;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class NodeDiscoverTask
implements Runnable {
    private static final int PROBE_STATUS_SUCCESS = 1;
    private static final int PROBE_STATUS_FAIL = 2;
    private static final int PROBE_STATUS_IGNORE = 3;
    private final ConnectionManager connectionManager = ConnectionManager.getInstance();

    public NodeDiscoverTask() {
        new Thread().start();
    }

    @Override
    public void run() {
        try {
            List<NodeGroup> list = NodeGroupManager.getInstance().getNodeGroups();
            Collections.shuffle(list);
            for (NodeGroup nodeGroup : list) {
                this.processNodes(nodeGroup.getLocalNetNodeContainer());
                this.processNodes(nodeGroup.getCrossNodeContainer());
                this.processLocalCrossNodes(nodeGroup.getLocalShareToCrossUncheckNodes(), nodeGroup.getLocalShareToCrossCanConnectNodes());
                this.processFailNodes(nodeGroup.getLocalNetNodeContainer());
                this.processFailNodes(nodeGroup.getCrossNodeContainer());
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    private void processNodes(NodesContainer nodesContainer) {
        Map<String, Node> canConnectNodes = nodesContainer.getCanConnectNodes();
        Map<String, Node> uncheckNodes = nodesContainer.getUncheckNodes();
        Map<String, Node> disconnectNodes = nodesContainer.getDisconnectNodes();
        if (uncheckNodes.size() > 0) {
            this.probeNodes(uncheckNodes, canConnectNodes, nodesContainer);
        }
        if (disconnectNodes.size() > 0) {
            this.probeNodes(disconnectNodes, canConnectNodes, nodesContainer);
        }
    }

    private void processLocalCrossNodes(Map<String, Node> verifyNodes, Map<String, Node> canConnectNodes) {
        if (verifyNodes.size() > 0) {
            for (Map.Entry<String, Node> nodeEntry : verifyNodes.entrySet()) {
                int status;
                Node node = nodeEntry.getValue();
                boolean needProbeNow = this.checkNeedProbeNow(node, verifyNodes);
                if (!needProbeNow || node.getConnectStatus() == 1 || (status = this.doProbe(node)) == 3) continue;
                if (status == 1) {
                    node.setStatus(2);
                    canConnectNodes.put(node.getId(), node);
                    verifyNodes.remove(node.getId());
                    LoggerUtil.logger(node.getNodeGroup().getChainId()).info("add cross node,remove from verifyNodes:{}", new Object[]{node.getId()});
                    LoggerUtil.logger(node.getNodeGroup().getChainId()).info("share cross node={}", new Object[]{node.getId()});
                    this.doShare(node, true);
                    continue;
                }
                node.setStatus(3);
                node.setConnectStatus(4);
                node.setFailCount(node.getFailCount() + 1);
            }
        }
    }

    private void processFailNodes() {
        try {
            List<NodeGroup> list = NodeGroupManager.getInstance().getNodeGroups();
            Collections.shuffle(list);
            for (NodeGroup nodeGroup : list) {
                this.processFailNodes(nodeGroup.getLocalNetNodeContainer());
                this.processFailNodes(nodeGroup.getCrossNodeContainer());
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    private void processFailNodes(NodesContainer nodesContainer) {
        try {
            Map<String, Node> canConnectNodes = nodesContainer.getCanConnectNodes();
            Map<String, Node> failNodes = nodesContainer.getFailNodes();
            if (failNodes.size() > 0) {
                this.probeNodes(failNodes, canConnectNodes, nodesContainer);
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    private void probeNodes(final Map<String, Node> verifyNodes, final Map<String, Node> canConnectNodes, final NodesContainer nodesContainer) {
        int maxNodes = 20;
        int count = 0;
        ArrayList<Future<Node>> discoverList = new ArrayList<Future<Node>>();
        for (Map.Entry<String, Node> nodeEntry : verifyNodes.entrySet()) {
            final Node node = nodeEntry.getValue();
            boolean needProbeNow = this.checkNeedProbeNow(node, verifyNodes);
            if (!needProbeNow) continue;
            if (node.getConnectStatus() == 1) {
                LoggerUtil.COMMON_LOG.info("{} is in connecting", new Object[]{node.getId()});
                continue;
            }
            if (++count >= maxNodes) break;
            Future<Node> res = ConnectionManager.getInstance().discover.submit(new Callable<Node>(){

                @Override
                public Node call() {
                    try {
                        int status = NodeDiscoverTask.this.doProbe(node);
                        if (status == 3) {
                            return node;
                        }
                        verifyNodes.remove(node.getId());
                        if (status == 1) {
                            node.setConnectStatus(0);
                            node.setFailCount(node.getFailCount() + 1);
                            if (nodesContainer.hadInConnection(node.getIp())) {
                                node.setStatus(1);
                            } else {
                                node.setStatus(2);
                            }
                            canConnectNodes.put(node.getId(), node);
                            if (!node.isHadShare()) {
                                NodeDiscoverTask.this.doShare(node, false);
                                node.setHadShare(true);
                            }
                        } else if (status == 2) {
                            ConnectionManager.getInstance().nodeConnectFail(node);
                            if (node.isCrossConnect()) {
                                node.getNodeGroup().getCrossNodeContainer().getFailNodes().put(node.getId(), node);
                            } else {
                                node.getNodeGroup().getLocalNetNodeContainer().getFailNodes().put(node.getId(), node);
                            }
                        }
                        node.setLastProbeTime(TimeManager.currentTimeMillis());
                    }
                    catch (Exception e) {
                        return node;
                    }
                    return node;
                }
            });
            discoverList.add(res);
        }
        discoverList.forEach(n -> {
            try {
                LoggerUtil.logger(((Node)n.get()).getNodeGroup().getChainId()).debug("discover node={},status={}", new Object[]{((Node)n.get()).getId(), ((Node)n.get()).getStatus()});
            }
            catch (InterruptedException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
            }
            catch (ExecutionException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
            }
        });
    }

    private boolean checkNeedProbeNow(Node node, Map<String, Node> verifyNodes) {
        long probeInterval;
        int failCount = node.getFailCount();
        if (failCount == 0) {
            probeInterval = 0L;
        } else if (failCount <= 10) {
            probeInterval = 60000L;
        } else if (failCount <= 20) {
            probeInterval = 300000L;
        } else if (failCount <= 30) {
            probeInterval = 600000L;
        } else {
            verifyNodes.remove(node.getId());
            return false;
        }
        return TimeManager.currentTimeMillis() - node.getLastProbeTime() > probeInterval;
    }

    private int doProbe(Node node) {
        if (node == null) {
            return 2;
        }
        CompletableFuture future = new CompletableFuture();
        node.setConnectStatus(1);
        node.setConnectedListener(() -> {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("verify node:{},connect success", new Object[]{node.getId()});
            node.setConnectStatus(2);
            node.getChannel().close();
        });
        node.setDisconnectListener(() -> {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("verify node:{},disconnect,failCount={}", new Object[]{node.getId(), node.getFailCount()});
            node.setChannel(null);
            int availableNodesCount = 0;
            availableNodesCount = node.isCrossConnect() ? node.getNodeGroup().getCrossNodeContainer().getConnectedNodes().size() : node.getNodeGroup().getLocalNetNodeContainer().getConnectedNodes().size();
            if (node.getConnectStatus() == 2) {
                node.setConnectStatus(3);
                future.complete(1);
            } else if (availableNodesCount == 0) {
                node.setConnectStatus(0);
                future.complete(3);
            } else {
                node.setConnectStatus(4);
                future.complete(2);
            }
        });
        boolean result = this.connectionManager.connection(node);
        if (!result) {
            return 2;
        }
        try {
            return (Integer)future.get();
        }
        catch (Exception e) {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).error(e);
            return 3;
        }
    }

    private void doShare(Node node, boolean isLocalToCrossShare) {
        LoggerUtil.COMMON_LOG.info("doShare node={},isLocalToCrossShare={}", new Object[]{node.getId(), isLocalToCrossShare});
        if (node.isCrossConnect()) {
            if (isLocalToCrossShare) {
                NodeGroup nodeGroup = node.getNodeGroup();
                if (nodeGroup.isMoonGroup()) {
                    List<NodeGroup> nodeGroupList1 = NodeGroupManager.getInstance().getNodeGroups();
                    for (NodeGroup nodeGroup1 : nodeGroupList1) {
                        if (nodeGroup1.getChainId() == nodeGroup.getChainId()) continue;
                        this.broadcastNewAddr(node.getIp(), 0, node.getRemoteCrossPort(), nodeGroup1.getMagicNumber(), nodeGroup1.getChainId(), true, true);
                    }
                } else {
                    this.broadcastNewAddr(node.getIp(), 0, node.getRemoteCrossPort(), node.getMagicNumber(), nodeGroup.getChainId(), true, true);
                }
            }
        } else {
            this.broadcastNewAddr(node.getIp(), node.getRemotePort(), node.getRemoteCrossPort(), node.getMagicNumber(), node.getNodeGroup().getChainId(), false, false);
        }
    }

    private void broadcastNewAddr(String ip, int port, int crossPort, long magicNumber, int chainId, boolean isCross, boolean isCrossAddress) {
        IpAddressShare ipAddress = new IpAddressShare(ip, port, crossPort);
        ArrayList<IpAddressShare> list = new ArrayList<IpAddressShare>();
        list.add(ipAddress);
        AddrMessage addrMessage = MessageFactory.getInstance().buildAddrMessage(list, magicNumber, chainId, isCrossAddress ? (byte)1 : 0);
        MessageManager.getInstance().broadcastNewAddr(addrMessage, null, isCross, true);
    }
}

