/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.network.manager.ConnectionManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.BestBlockInfo;
import io.nuls.network.rpc.call.BlockRpcService;
import io.nuls.network.rpc.call.impl.BlockRpcServiceImpl;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class NodeMaintenanceTask
implements Runnable {
    private final NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    private final ConnectionManager connectionManager = ConnectionManager.getInstance();

    @Override
    public void run() {
        try {
            if (!ConnectionManager.getInstance().isRunning()) {
                LoggerUtil.COMMON_LOG.info("ConnectionManager is not running.");
                return;
            }
            List<NodeGroup> list = NodeGroupManager.getInstance().getNodeGroups();
            Collections.shuffle(list);
            for (NodeGroup nodeGroup : list) {
                this.process(nodeGroup, false);
                this.process(nodeGroup, true);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
        }
    }

    private void process(NodeGroup nodeGroup, boolean isCross) {
        List<Node> needConnectNodes;
        if (isCross && !nodeGroup.isMoonNode() && !nodeGroup.isHadBlockHeigh()) {
            BlockRpcService blockRpcService = (BlockRpcService)SpringLiteContext.getBean(BlockRpcServiceImpl.class);
            BestBlockInfo bestBlockInfo = blockRpcService.getBestBlockHeader(nodeGroup.getChainId());
            if (bestBlockInfo.getBlockHeight() < 1L) {
                LoggerUtil.logger(nodeGroup.getChainId()).info("chainId={} cross connect process stop.blockHeight={}", new Object[]{nodeGroup.getChainId(), bestBlockInfo.getBlockHeight()});
                return;
            }
            LoggerUtil.logger(nodeGroup.getChainId()).info("chainId={} cross connect process active.blockHeight={}", new Object[]{nodeGroup.getChainId(), bestBlockInfo.getBlockHeight()});
            nodeGroup.setHadBlockHeigh(true);
        }
        if ((needConnectNodes = this.getNeedConnectNodes(nodeGroup, isCross)) == null || needConnectNodes.size() == 0) {
            return;
        }
        int count = 0;
        ArrayList<Future<Node>> connectNodeList = new ArrayList<Future<Node>>();
        for (final Node node : needConnectNodes) {
            node.setType(2);
            Future<Node> future = this.connectionManager.maintenance.submit(new Callable<Node>(){

                @Override
                public Node call() {
                    try {
                        NodeMaintenanceTask.this.connectionNode(node);
                    }
                    catch (Exception e) {
                        return node;
                    }
                    return node;
                }
            });
            connectNodeList.add(future);
            if (++count <= 10) continue;
            break;
        }
        connectNodeList.forEach(n -> {
            try {
                LoggerUtil.logger(nodeGroup.getChainId()).debug("maintenance:chainId={},isCross={},node={}", new Object[]{nodeGroup.getChainId(), isCross, ((Node)n.get()).getId()});
            }
            catch (InterruptedException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
            }
            catch (ExecutionException e) {
                LoggerUtil.COMMON_LOG.error((Exception)e);
            }
        });
    }

    private boolean connectionNode(Node node) {
        node.setConnectStatus(1);
        node.setRegisterListener(() -> LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("new node {} Register!", new Object[]{node.getId()}));
        node.setConnectedListener(() -> {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("connected success:{},iscross={}", new Object[]{node.getId(), node.isCrossConnect()});
            this.connectionManager.nodeClientConnectSuccess(node);
        });
        node.setDisconnectListener(() -> {
            LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("connected disconnect:{},iscross={}", new Object[]{node.getId(), node.isCrossConnect()});
            this.connectionManager.nodeConnectDisconnect(node);
        });
        return this.connectionManager.connection(node);
    }

    private List<Node> getNeedConnectNodes(NodeGroup nodeGroup, boolean isCross) {
        int maxOutCount;
        Collection<Node> connectedNodes = nodeGroup.getConnectedNodes(isCross);
        int n = maxOutCount = isCross ? nodeGroup.getMaxCrossOut() : nodeGroup.getMaxOut();
        if (connectedNodes.size() >= maxOutCount) {
            nodeGroup.stopConnectedSeeds(isCross);
            return null;
        }
        Collection<Node> canConnectNodes = nodeGroup.getCanConnectNodes(isCross);
        if (canConnectNodes.size() == 0) {
            return null;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>(canConnectNodes);
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            Node node = (Node)nodeList.get(i);
            if (IpUtil.isSelf(node.getIp())) {
                nodeList.remove(node);
                LoggerUtil.logger(nodeGroup.getChainId()).info("move self Address={}", new Object[]{node.getId()});
                if (isCross) {
                    nodeGroup.getCrossNodeContainer().getCanConnectNodes().remove(node.getId());
                    continue;
                }
                nodeGroup.getLocalNetNodeContainer().getCanConnectNodes().remove(node.getId());
                continue;
            }
            if (node.getConnectStatus() != 1) continue;
            LoggerUtil.COMMON_LOG.info("{} is in connecting", new Object[]{node.getId()});
            nodeList.remove(node);
        }
        int maxCount = maxOutCount - connectedNodes.size();
        if (nodeList.size() < maxCount) {
            return nodeList;
        }
        Collections.shuffle(nodeList);
        return nodeList.subList(0, maxCount);
    }
}

