/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.core.log.Log;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.manager.handler.MessageHandlerFactory;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.RpcCacheMessage;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RPCCacheMsgSendTask
implements Runnable {
    @Override
    public void run() {
        while (true) {
            NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
            List<NodeGroup> nodeGroupList = nodeGroupManager.getNodeGroups();
            for (NodeGroup nodeGroup : nodeGroupList) {
                int chainId = nodeGroup.getChainId();
                if (nodeGroup.getCacheMsgQueue().size() > 0) {
                    LoggerUtil.logger(chainId).debug("##########chainId = {},CacheMsgQueue size={}", new Object[]{chainId, nodeGroup.getCacheMsgQueue().size()});
                }
                ArrayList<RpcCacheMessage> backList = new ArrayList<RpcCacheMessage>();
                while (nodeGroup.getCacheMsgQueue().size() > 0) {
                    try {
                        RpcCacheMessage peerMessage = nodeGroup.getCacheMsgQueue().takeFirst();
                        if (TimeManager.currentTimeMillis() - peerMessage.getCreateTime() > 5000L) {
                            LoggerUtil.logger(chainId).error("chainId = {},cmd={},tryTimes={},createTime={},RPC fail,drop from cache", new Object[]{chainId, peerMessage.getCmd(), peerMessage.getTryTimes(), peerMessage.getCreateTime()});
                            continue;
                        }
                        Map<String, CmdPriority> protocolRoles = MessageHandlerFactory.getInstance().getProtocolRoleHandlerMap(peerMessage.getCmd());
                        boolean fail = false;
                        for (Map.Entry<String, CmdPriority> entry : protocolRoles.entrySet()) {
                            try {
                                Request request = MessageUtil.newRequest((String)"msgProcess", peerMessage.toMap(chainId), (String)"0", (String)"0", (String)"0");
                                if ("0".equals(ResponseMessageProcessor.requestOnly((String)entry.getKey(), (Request)request))) {
                                    fail = true;
                                    LoggerUtil.logger(chainId).debug("##### chainId = {},cmd={},RPC resend fail,back to cache", new Object[]{chainId, peerMessage.getCmd()});
                                    continue;
                                }
                                LoggerUtil.logger(chainId).debug("##### chainId = {},cmd={},RPC resend success", new Object[]{chainId, peerMessage.getCmd()});
                            }
                            catch (Exception e) {
                                LoggerUtil.logger(chainId).error("{}", e);
                            }
                        }
                        if (!fail) continue;
                        peerMessage.setTryTimes(peerMessage.getTryTimes() + 1);
                        if (peerMessage.getTryTimes() > 5) {
                            LoggerUtil.logger(chainId).error("#####chainId = {},cmd={},tryTimes={},tryTimes max,drop from cache", new Object[]{chainId, peerMessage.getCmd(), peerMessage.getTryTimes()});
                            continue;
                        }
                        backList.add(peerMessage);
                    }
                    catch (Exception e) {
                        LoggerUtil.logger(chainId).error(e);
                    }
                }
                nodeGroup.getCacheMsgQueue().addAll(backList);
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Log.error((Throwable)e);
                Log.error((String)"currentThread interrupt!!");
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

