/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.network.manager.ConnectionManager;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShareAddressTask
implements Runnable {
    private final NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    private NodeGroup nodeGroup = null;
    private boolean isCross = false;
    private ConnectionManager connectionManager = ConnectionManager.getInstance();

    public ShareAddressTask(NodeGroup nodeGroup, boolean isCross) {
        this.nodeGroup = nodeGroup;
        this.isCross = isCross;
    }

    @Override
    public void run() {
        if (this.isCross) {
            this.doCrossNet();
        } else {
            this.doLocalNet();
        }
    }

    private void doLocalNet() {
        MessageManager.getInstance().sendGetAddressMessage(this.nodeGroup, false, false, true);
        if (this.nodeGroup.isMoonGroup()) {
            List<NodeGroup> nodeGroups = NodeGroupManager.getInstance().getNodeGroups();
            for (NodeGroup crossNodeGroup : nodeGroups) {
                MessageManager.getInstance().sendGetCrossAddressMessage(this.nodeGroup, crossNodeGroup, false, true, true);
            }
        } else {
            MessageManager.getInstance().sendGetAddressMessage(this.nodeGroup, false, true, true);
        }
        String externalIp = this.getMyExtranetIp();
        if (externalIp == null) {
            return;
        }
        this.networkConfig.getLocalIps().add(externalIp);
        if (!this.nodeGroup.isMoonCrossGroup()) {
            LoggerUtil.logger(this.nodeGroup.getChainId()).info("begin share self ip  is {}:{}", new Object[]{externalIp, this.networkConfig.getPort()});
            Node myNode = new Node(this.nodeGroup.getMagicNumber(), externalIp, this.networkConfig.getPort(), this.networkConfig.getCrossPort(), 2, false);
            myNode.setConnectedListener(() -> {
                myNode.getChannel().close();
                LoggerUtil.logger(this.nodeGroup.getChainId()).info("self ip verify success,doShare \uff1ashare self ip  is {}:{}", new Object[]{externalIp, this.networkConfig.getPort()});
                this.doShare(externalIp, this.nodeGroup.getLocalNetNodeContainer().getAvailableNodes(), this.networkConfig.getPort(), this.networkConfig.getCrossPort(), false);
            });
            myNode.setDisconnectListener(() -> myNode.setChannel(null));
            this.connectionManager.connection(myNode);
        }
    }

    private void doCrossNet() {
        MessageManager.getInstance().sendGetAddressMessage(this.nodeGroup, true, true, true);
        String externalIp = this.getMyExtranetIp();
        if (externalIp == null) {
            return;
        }
        this.networkConfig.getLocalIps().add(externalIp);
        if (this.nodeGroup.isCrossActive()) {
            LoggerUtil.logger(this.nodeGroup.getChainId()).info("begin cross ip share. self ip  is {}:{}", new Object[]{externalIp, this.networkConfig.getCrossPort()});
            Node crossNode = new Node(this.nodeGroup.getMagicNumber(), externalIp, this.networkConfig.getCrossPort(), this.networkConfig.getCrossPort(), 2, true);
            crossNode.setConnectedListener(() -> {
                crossNode.getChannel().close();
                LoggerUtil.logger(this.nodeGroup.getChainId()).info("cross ip verify success,doShare {}:{}", new Object[]{externalIp, this.networkConfig.getCrossPort()});
                this.doShare(externalIp, this.nodeGroup.getCrossNodeContainer().getAvailableNodes(), this.networkConfig.getCrossPort(), this.networkConfig.getCrossPort(), true);
            });
            this.connectionManager.connection(crossNode);
        }
    }

    private String getMyExtranetIp() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.nodeGroup.getLocalNetNodeContainer().getConnectedNodes().values());
        nodes.addAll(this.nodeGroup.getCrossNodeContainer().getConnectedNodes().values());
        return this.getMostSameIp(nodes);
    }

    private String getMostSameIp(Collection<Node> nodes) {
        HashMap<String, Integer> ipMaps = new HashMap<String, Integer>();
        for (Node node : nodes) {
            String ip = node.getExternalIp();
            if (ip == null) continue;
            Integer count = (Integer)ipMaps.get(ip);
            if (count == null) {
                ipMaps.put(ip, 1);
                continue;
            }
            ipMaps.put(ip, count + 1);
        }
        int maxCount = 0;
        String ip = null;
        for (Map.Entry entry : ipMaps.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            ip = (String)entry.getKey();
        }
        return ip;
    }

    private void doShare(String externalIp, Collection<Node> nodes, int port, int crossPort, boolean isCrossAddress) {
        IpAddressShare ipAddressShare = new IpAddressShare(externalIp, port, crossPort);
        MessageManager.getInstance().broadcastSelfAddrToAllNode(nodes, ipAddressShare, isCrossAddress, true);
    }
}

