/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.manager;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.ProtocolContext;
import io.nuls.protocol.service.ProtocolService;
import io.nuls.protocol.utils.ConfigLoader;
import java.io.File;
import java.util.List;

@Component
public class ChainManager {
    @Autowired
    private ProtocolService protocolService;
    @Autowired
    private NulsCoresConfig config;

    public void initChain() {
        ConfigLoader.load();
        RocksDBService.init((String)(this.config.getDataPath() + File.separator + ModuleE.PU.name));
        ContextManager.chainIds.forEach(this::initTable);
    }

    public void runChain() {
        List<Integer> chainIds = ContextManager.chainIds;
        for (Integer chainId : chainIds) {
            this.protocolService.init(chainId);
            ProtocolContext context = ContextManager.getContext(chainId);
            NulsLogger logger = context.getLogger();
            short localVersion = context.getLocalProtocolVersion().getVersion();
            short version = context.getCurrentProtocolVersion().getVersion();
            if (version <= localVersion) continue;
            logger.error("localVersion-" + localVersion);
            logger.error("newVersion-" + version);
            logger.error("Older versions of the wallet automatically stop working, Please upgrade the latest version of the wallet!");
            System.exit(1);
        }
    }

    public void stopChain(int chainId) {
    }

    private void initTable(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            RocksDBService.createTable((String)("statistics_info_" + chainId));
            RocksDBService.createTable((String)("cached_info_" + chainId));
            RocksDBService.createTable((String)("protocol_version_po_" + chainId));
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

