/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.basic.ProtocolVersion;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StatisticsInfo
extends BaseNulsData {
    private long height;
    private short oldCount;
    private long count;
    private ProtocolVersion protocolVersion;
    private Map<ProtocolVersion, Integer> protocolVersionMap;

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        if (count < 0L) {
            count = 65536L + count;
        }
        this.count = count;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Map<ProtocolVersion, Integer> getProtocolVersionMap() {
        return this.protocolVersionMap;
    }

    public void setProtocolVersionMap(Map<ProtocolVersion, Integer> protocolVersionMap) {
        this.protocolVersionMap = protocolVersionMap;
    }

    public int size() {
        int size = 12;
        size += SerializeUtils.sizeOfNulsData((NulsData)this.protocolVersion);
        for (int i = 0; i < this.protocolVersionMap.size(); ++i) {
            size += 7;
        }
        return size += SerializeUtils.sizeOfInt64();
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeInt64(this.height);
        stream.writeShort(this.oldCount);
        stream.writeNulsData((BaseNulsData)this.protocolVersion);
        stream.writeShort((short)this.protocolVersionMap.size());
        Set<Map.Entry<ProtocolVersion, Integer>> entries = this.protocolVersionMap.entrySet();
        for (Map.Entry<ProtocolVersion, Integer> entry : entries) {
            stream.writeNulsData((BaseNulsData)entry.getKey());
            stream.writeUint16(entry.getValue().intValue());
        }
        stream.writeInt64(this.count);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.height = byteBuffer.readInt64();
        this.oldCount = byteBuffer.readShort();
        this.protocolVersion = (ProtocolVersion)byteBuffer.readNulsData((BaseNulsData)new ProtocolVersion());
        int size = byteBuffer.readShort();
        this.protocolVersionMap = new HashMap<ProtocolVersion, Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.protocolVersionMap.put((ProtocolVersion)byteBuffer.readNulsData((BaseNulsData)new ProtocolVersion()), byteBuffer.readUint16());
        }
        this.count = byteBuffer.isFinished() ? (long)this.oldCount : byteBuffer.readInt64();
    }

    public String toString() {
        return "{height=" + this.height + ", count=" + this.count + ", protocolVersion=" + this.protocolVersion + ", protocolVersionMap=" + this.protocolVersionMap + "}";
    }
}

