/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.rpc;

import com.google.common.collect.Maps;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.ProtocolVersion;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.protocol.Protocol;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.ProtocolContext;
import io.nuls.protocol.service.ProtocolService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.PU)
public class ProtocolResource
extends BaseCmd {
    @Autowired
    private ProtocolService service;

    @CmdAnnotation(cmd="getVersion", version=1.0, description="get mainnet version")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return aMapObject, containing three properties", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="version", valueType=Short.class, description="Protocol version number"), @Key(name="effectiveRatio", valueType=Byte.class, description="The minimum effective ratio within each statistical interval"), @Key(name="continuousIntervalCount", valueType=Short.class, description="The number of consecutive intervals that the agreement must meet in order to take effect")}))
    public Response getVersion(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        ProtocolContext context = ContextManager.getContext(chainId);
        ProtocolVersion currentProtocolVersion = context.getCurrentProtocolVersion();
        ProtocolVersion localProtocolVersion = context.getLocalProtocolVersion();
        HashMap<String, ProtocolVersion> result = new HashMap<String, ProtocolVersion>();
        result.put("currentProtocolVersion", currentProtocolVersion);
        result.put("localProtocolVersion", localProtocolVersion);
        return this.success(result);
    }

    @CmdAnnotation(cmd="checkBlockVersion", version=1.0, description="check block version")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="extendsData", requestType=@TypeDescriptor(value=String.class), parameterDes="BlockExtendsDataSerializedhexcharacter string")})
    @ResponseData(name="Return value", description="No return value")
    public Response checkBlockVersion(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        String extendStr = map.get("extendsData").toString();
        BlockExtendsData extendsData = new BlockExtendsData(RPCUtil.decode((String)extendStr));
        ProtocolContext context = ContextManager.getContext(chainId);
        ProtocolVersion currentProtocol = context.getCurrentProtocolVersion();
        if (currentProtocol.getVersion() != extendsData.getMainVersion()) {
            NulsLogger logger = context.getLogger();
            logger.info("------block version error, mainVersion:" + currentProtocol.getVersion() + ",blockVersion:" + extendsData.getMainVersion());
            return this.failed("block version error");
        }
        return this.success();
    }

    @CmdAnnotation(cmd="saveBlock", version=1.0, description="save block header")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="blockHeader", requestType=@TypeDescriptor(value=String.class), parameterDes="Block headhex")})
    @ResponseData(name="Return value", description="No return value")
    public Response save(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        String hex = map.get("blockHeader").toString();
        BlockHeader blockHeader = new BlockHeader();
        try {
            blockHeader.parse(new NulsByteBuffer(HexUtil.decode((String)hex)));
            if (this.service.save(chainId, blockHeader)) {
                return this.success();
            }
            return this.failed("protocol save failed!");
        }
        catch (NulsException e) {
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="rollbackBlock", version=1.0, description="rollback block header")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="blockHeader", requestType=@TypeDescriptor(value=String.class), parameterDes="Block headhex")})
    @ResponseData(name="Return value", description="No return value")
    public Response rollback(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        String hex = map.get("blockHeader").toString();
        BlockHeader blockHeader = new BlockHeader();
        try {
            blockHeader.parse(new NulsByteBuffer(HexUtil.decode((String)hex)));
            if (this.service.rollback(chainId, blockHeader)) {
                return this.success();
            }
            return this.failed("protocol rollback failed!");
        }
        catch (NulsException e) {
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="registerProtocol", version=1.0, description="register protocol")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="moduleCode", requestType=@TypeDescriptor(value=String.class), parameterDes="Module Flag"), @Parameter(parameterName="list", requestType=@TypeDescriptor(value=List.class), parameterDes="ProtocolSerializedhexcharacter string")})
    @ResponseData(name="Return value", description="No return value")
    public Response registerProtocol(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        ProtocolContext context = ContextManager.getContext(chainId);
        Map<Short, List<Map.Entry<String, Protocol>>> protocolMap = context.getProtocolMap();
        NulsLogger logger = context.getLogger();
        String moduleCode = map.get("moduleCode").toString();
        List list = (List)map.get("list");
        logger.info("--------------------registerProtocol---------------------------");
        logger.info("moduleCode-" + moduleCode);
        for (Object o : list) {
            Map m = (Map)o;
            Protocol protocol = (Protocol)JSONUtils.map2pojo((Map)m, Protocol.class);
            short version = protocol.getVersion();
            List protocolList = protocolMap.computeIfAbsent(version, k -> new ArrayList());
            protocolList.add(Maps.immutableEntry((Object)moduleCode, (Object)protocol));
            logger.info("protocol-" + protocol);
        }
        return this.success();
    }
}

