/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.RpcCall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockCall {
    public static long getLatestHeight(int chainId) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            Map resultMap = (Map)RpcCall.request((String)ModuleE.BL.abbr, (String)"latestHeight", params);
            return Long.parseLong(resultMap.get("value").toString());
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static List<BlockHeader> getBlockHeaders(int chainId, int interval) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("interval", interval);
            Map resultMap = (Map)RpcCall.request((String)ModuleE.BL.abbr, (String)"getBlockHeadersForProtocol", params);
            List blockHeaderList = (List)resultMap.get("value");
            if (blockHeaderList == null) {
                return List.of();
            }
            ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
            for (String blockHeaderHex : blockHeaderList) {
                BlockHeader header = new BlockHeader();
                header.parse(new NulsByteBuffer(RPCUtil.decode((String)blockHeaderHex)));
                blockHeaders.add(header);
            }
            return blockHeaders;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

