/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.rpc.call;

import io.nuls.base.protocol.Protocol;
import io.nuls.base.protocol.RegisterHelper;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.RpcCall;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.ProtocolContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VersionChangeNotifier {
    public static boolean notify(int chainId, short version) {
        long begin = System.nanoTime();
        ArrayList<String> noticedModule = new ArrayList<String>();
        noticedModule.add(ModuleE.NC.abbr);
        for (String module : noticedModule) {
            long l = System.nanoTime();
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("protocolVersion", version);
            try {
                RpcCall.request((String)module, (String)"protocolVersionChange", params);
            }
            catch (NulsException e) {
                return false;
            }
            long end = System.nanoTime();
            ContextManager.getContext(chainId).getLogger().info("****{} notify time-{}ms", new Object[]{module, (end - l) / 1000000L});
        }
        long end = System.nanoTime();
        ContextManager.getContext(chainId).getLogger().info("****total notify time-{}ms", new Object[]{(end - begin) / 1000000L});
        return true;
    }

    public static void reRegister(int chainId, ProtocolContext context, short version) {
        long begin = System.nanoTime();
        List<Map.Entry<String, Protocol>> entries = context.getProtocolMap().get(version);
        if (entries != null) {
            entries.forEach(e -> {
                RegisterHelper.registerMsg((Protocol)((Protocol)e.getValue()), (String)((String)e.getKey()));
                RegisterHelper.registerTx((int)chainId, (Protocol)((Protocol)e.getValue()), (String)((String)e.getKey()));
            });
        }
        long end = System.nanoTime();
        context.getLogger().info("****reRegister time****" + (end - begin));
    }
}

