/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.utils;

import io.nuls.base.basic.ProtocolVersion;
import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.io.IoUtils;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.protocol.ProtocolUpdateBootstrap;
import io.nuls.protocol.manager.ContextManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Component
public class ConfigLoader {
    private static List<ProtocolVersion> versions;

    public static void load() {
        ArrayList<ConfigBean> list = new ArrayList<ConfigBean>(CommonContext.CONFIG_BEAN_MAP.values());
        if (list == null || list.size() == 0) {
            ConfigLoader.loadDefault();
        } else {
            for (ConfigBean chainParameters : list) {
                ContextManager.init(chainParameters, versions);
            }
        }
    }

    private static void loadDefault() {
        ContextManager.init(ProtocolUpdateBootstrap.protocolConfig, versions);
    }

    static {
        try {
            versions = JSONUtils.json2list((String)IoUtils.read((String)("protocol" + File.separator + "versions.json")), ProtocolVersion.class);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            System.exit(1);
        }
    }
}

