/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction;

import io.nuls.base.basic.AddressTool;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import io.nuls.transaction.constant.TxContext;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Component
public class TransactionBootstrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig txConfig;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private ChainManager chainManager;

    @Override
    public int order() {
        return 3;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    public void init() {
        try {
            this.initDB();
            this.initTransactionContext();
            this.chainManager.initChain();
            TxUtil.blackHolePublicKey = HexUtil.decode((String)this.txConfig.getBlackHolePublicKey());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("Transaction init error!");
            LoggerUtil.LOG.error(e);
        }
    }

    private boolean doStart() {
        try {
            this.chainManager.runChain();
            LoggerUtil.LOG.info("Transaction Ready...");
            return true;
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("Transaction init error!");
            LoggerUtil.LOG.error(e);
            return false;
        }
    }

    @Override
    public void onDependenciesReady() {
        this.doStart();
        this.txConfig.setCollectedSmartContractModule(true);
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.TX.abbr, "1.0");
    }

    public void initDB() {
        try {
            RocksDBService.init((String)(this.txConfig.getDataPath() + File.separator + ModuleE.TX.name));
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
    }

    private void initTransactionContext() {
        String accountBlockManagerPublicKeys = this.txConfig.getAccountBlockManagerPublicKeys();
        if (StringUtils.isNotBlank((String)accountBlockManagerPublicKeys)) {
            String[] split;
            for (String pubkey : split = accountBlockManagerPublicKeys.split(",")) {
                TxContext.ACCOUNT_BLOCK_MANAGER_ADDRESS_SET.add(AddressTool.getAddressString((byte[])HexUtil.decode((String)pubkey.trim()), (int)this.txConfig.getChainId()));
            }
            int size = TxContext.ACCOUNT_BLOCK_MANAGER_ADDRESS_SET.size();
            TxContext.ACCOUNT_BLOCK_MIN_SIGN_COUNT = BigDecimal.valueOf(size).multiply(BigDecimal.valueOf(6L)).divide(BigDecimal.TEN, 0, RoundingMode.UP).intValue();
        }
    }
}

