/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.manager;

import io.nuls.base.data.Transaction;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TxManager {
    public static String getModuleCode(Chain chain, int type) {
        TxRegister txRegister = chain.getTxRegisterMap().get(type);
        if (null != txRegister) {
            return txRegister.getModuleCode();
        }
        return null;
    }

    public static TxRegister getTxRegister(Chain chain, int type) {
        return chain.getTxRegisterMap().get(type);
    }

    public static boolean contains(Chain chain, int type) {
        return chain.getTxRegisterMap().containsKey(type);
    }

    public static List<Integer> getSysTypes(Chain chain) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, TxRegister> map : chain.getTxRegisterMap().entrySet()) {
            if (!map.getValue().getSystemTx()) continue;
            list.add(map.getKey());
        }
        return list;
    }

    public static boolean isSystemTx(Chain chain, Transaction tx) {
        TxRegister txRegister = chain.getTxRegisterMap().get(tx.getType());
        return txRegister.getSystemTx();
    }

    public static boolean isUnSystemSmartContract(Chain chain, int txType) {
        TxRegister txRegister = TxManager.getTxRegister(chain, txType);
        return ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(txType)) && !txRegister.getSystemTx();
    }

    public static boolean isUnSystemSmartContract(TxRegister txRegister) {
        if (txRegister == null) {
            return false;
        }
        return ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(txRegister.getTxType())) && !txRegister.getSystemTx();
    }

    public static boolean isSystemSmartContract(Chain chain, int txType) {
        TxRegister txRegister = TxManager.getTxRegister(chain, txType);
        if (txRegister == null) {
            return false;
        }
        return ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(txType)) && txRegister.getSystemTx();
    }

    public static boolean isSystemSmartContract(TxRegister txRegister) {
        if (txRegister == null) {
            return false;
        }
        return ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(txRegister.getTxType())) && txRegister.getSystemTx();
    }

    public static boolean isCrossTx(int txType) {
        return txType == 10 || txType == 26;
    }

    public static boolean isGasCostContractTransaction(int txType) {
        return txType == 15 || txType == 16;
    }
}

