/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.message.GetTxMessage;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.utils.LoggerUtil;

@Component(value="GetTxMessageHandlerV1")
public class GetTxMessageHandler
implements MessageProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxService txService;

    public String getCmd() {
        return "askTx";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        Chain chain = null;
        try {
            GetTxMessage message = (GetTxMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, GetTxMessage.class));
            if (message == null) {
                return;
            }
            chain = this.chainManager.getChain(chainId);
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            NulsHash txHash = message.getTxHash();
            TransactionConfirmedPO tx = this.txService.getTransaction(chain, txHash);
            if (tx == null) {
                chain.getLogger().debug("recieve [askTx] message from node-{}, chainId:{}, hash:{}", new Object[]{nodeId, chainId, txHash.toHex()});
                throw new NulsException(TxErrorCode.TX_NOT_EXIST);
            }
            NetworkCall.sendTxToNode(chain, nodeId, tx.getTx());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

