/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.message.BroadcastTxMessage;
import io.nuls.transaction.message.ForwardTxMessage;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.utils.LoggerUtil;
import java.io.IOException;
import java.util.HashMap;

public class NetworkCall {
    public static boolean broadcast(Chain chain, BaseBusinessMessage message, String excludeNodes, String cmd, int percent) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("excludeNodes", excludeNodes);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", cmd);
            params.put("percent", percent);
            Request request = MessageUtil.newRequest((String)"nw_broadcast", params, (String)"0", (String)"0", (String)"0");
            String messageId = ResponseMessageProcessor.requestOnly((String)ModuleE.NW.abbr, (Request)request);
            return !messageId.equals("0");
        }
        catch (IOException e) {
            LoggerUtil.LOG.error("message:" + cmd + " failed", (Exception)e);
            throw new NulsException(TxErrorCode.TX_BROADCAST_FAIL);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("message:" + cmd + " failed", e);
            throw new NulsException(TxErrorCode.TX_BROADCAST_FAIL);
        }
    }

    public static boolean sendToNode(Chain chain, BaseBusinessMessage message, String nodeId, String cmd) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("nodes", nodeId);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", cmd);
            Request request = MessageUtil.newRequest((String)"nw_sendPeersMsg", params, (String)"0", (String)"0", (String)"0");
            String messageId = ResponseMessageProcessor.requestOnly((String)ModuleE.NW.abbr, (Request)request);
            return !messageId.equals("0");
        }
        catch (IOException e) {
            LoggerUtil.LOG.error("message:" + cmd + " failed", (Exception)e);
            throw new NulsException(TxErrorCode.SEND_MSG_FAIL);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("message:" + cmd + " failed", e);
            throw new NulsException(TxErrorCode.SEND_MSG_FAIL);
        }
    }

    public static boolean forwardTxHash(Chain chain, NulsHash hash) throws NulsException {
        return NetworkCall.forwardTxHash(chain, hash, null);
    }

    public static boolean forwardTxHash(Chain chain, NulsHash hash, String excludeNodes) throws NulsException {
        ForwardTxMessage message = new ForwardTxMessage();
        message.setTxHash(hash);
        return NetworkCall.broadcast(chain, message, excludeNodes, "newHash", 50);
    }

    public static boolean broadcastTx(Chain chain, Transaction tx, String excludeNodes) throws NulsException {
        BroadcastTxMessage message = new BroadcastTxMessage();
        message.setTx(tx);
        return NetworkCall.broadcast(chain, message, excludeNodes, "receiveTx", 100);
    }

    public static boolean broadcastTx(Chain chain, Transaction tx) throws NulsException {
        return NetworkCall.broadcastTx(chain, tx, null);
    }

    public static boolean sendTxToNode(Chain chain, String nodeId, Transaction tx) throws NulsException {
        BroadcastTxMessage message = new BroadcastTxMessage();
        message.setTx(tx);
        return NetworkCall.sendToNode(chain, message, nodeId, "receiveTx");
    }
}

