/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.rpc.call.TransactionCall;
import io.nuls.transaction.service.ConfirmedTxService;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.ConfirmedTxStorageService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.TxUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component
public class ConfirmedTxServiceImpl
implements ConfirmedTxService {
    @Autowired
    private ConfirmedTxStorageService confirmedTxStorageService;
    @Autowired
    private UnconfirmedTxStorageService unconfirmedTxStorageService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private PackablePool packablePool;
    @Autowired
    private TxService txService;
    @Autowired
    private NulsCoresConfig txConfig;

    @Override
    public TransactionConfirmedPO getConfirmedTransaction(Chain chain, NulsHash hash) {
        if (null == hash) {
            return null;
        }
        return this.confirmedTxStorageService.getTx(chain.getChainId(), hash);
    }

    @Override
    public boolean saveGengsisTxList(Chain chain, List<String> txStrList, String blockHeader) throws NulsException {
        if (null == chain || txStrList == null || txStrList.size() == 0) {
            throw new NulsException(TxErrorCode.PARAMETER_ERROR);
        }
        if (!this.saveBlockTxList(chain, txStrList, blockHeader, true)) {
            chain.getLogger().debug("Save gengsis txs fail");
            return false;
        }
        chain.getLogger().debug("Save gengsis txs success");
        return true;
    }

    @Override
    public boolean saveTxList(Chain chain, List<String> txStrList, List<String> contractList, String blockHeader) throws NulsException {
        if (null == chain || txStrList == null || txStrList.size() == 0) {
            throw new NulsException(TxErrorCode.PARAMETER_ERROR);
        }
        if (contractList.size() > 0) {
            int ide = txStrList.size() - 1;
            String lastTxStr = txStrList.get(ide);
            if (TxUtil.extractTxTypeFromTx(lastTxStr) == 19) {
                txStrList.remove(ide);
                txStrList.addAll(contractList);
                txStrList.add(lastTxStr);
            } else {
                txStrList.addAll(contractList);
            }
        }
        try {
            return this.saveBlockTxList(chain, txStrList, blockHeader, false);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    private boolean saveBlockTxList(Chain chain, List<String> txStrList, String blockHeaderStr, boolean gengsis) {
        BlockHeader blockHeader;
        long start = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        int chainId = chain.getChainId();
        ArrayList<byte[]> txHashs = new ArrayList<byte[]>();
        HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
        NulsLogger logger = chain.getLogger();
        ArrayList<String> crossChainTxList = new ArrayList<String>();
        try {
            blockHeader = (BlockHeader)TxUtil.getInstanceRpcStr(blockHeaderStr, BlockHeader.class);
            logger.debug("[Save Block] start -----height:{} -----quantity:{}", new Object[]{blockHeader.getHeight(), txStrList.size()});
            for (String txStr : txStrList) {
                Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
                txList.add(tx);
                tx.setBlockHeight(blockHeader.getHeight());
                txHashs.add(tx.getHash().getBytes());
                if (TxManager.isSystemSmartContract(chain, tx.getType())) continue;
                if (10 == tx.getType()) {
                    crossChainTxList.add(txStr);
                }
                TxUtil.moduleGroups(chain, moduleVerifyMap, tx.getType(), txStr);
            }
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
        logger.debug("[Save Block] Assembly data execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - start});
        long dbStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.saveTxs(chain, txList, blockHeader.getHeight(), true)) {
            return false;
        }
        logger.debug("[Save Block] Confirmed transactionsDB execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - dbStart});
        long commitStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.commitTxs(chain, moduleVerifyMap, blockHeaderStr, true)) {
            this.removeTxs(chain, txList, blockHeader.getHeight(), false);
            return false;
        }
        logger.debug("[Save Block] Transaction business submission execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - commitStart});
        long ledgerStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.commitLedger(chain, txStrList, blockHeader.getHeight())) {
            if (!gengsis) {
                this.rollbackTxs(chain, moduleVerifyMap, blockHeaderStr, false);
            }
            this.removeTxs(chain, txList, blockHeader.getHeight(), false);
            return false;
        }
        logger.debug("[Save Block] Ledger module submission execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - ledgerStart});
        this.unconfirmedTxStorageService.removeTxList(chainId, txHashs);
        this.packablePool.clearConfirmedTxs(chain, txHashs);
        logger.debug("[Save Block] Total execution time:{} - height:{}, - Transaction quantity:{}" + TxUtil.nextLine(), new Object[]{NulsDateUtils.getCurrentTimeMillis() - start, blockHeader.getHeight(), txList.size()});
        return true;
    }

    private boolean saveTxs(Chain chain, List<Transaction> txList, long blockHeight, boolean atomicity) {
        boolean rs = true;
        ArrayList<TransactionConfirmedPO> toSaveList = new ArrayList<TransactionConfirmedPO>();
        for (Transaction tx : txList) {
            tx.setStatus(TxStatusEnum.CONFIRMED);
            TransactionConfirmedPO txConfirmedPO = new TransactionConfirmedPO(tx, blockHeight, TxStatusEnum.CONFIRMED.getStatus());
            toSaveList.add(txConfirmedPO);
        }
        if (!this.confirmedTxStorageService.saveTxList(chain.getChainId(), toSaveList)) {
            if (atomicity) {
                this.removeTxs(chain, txList, blockHeight, false);
            }
            rs = false;
            chain.getLogger().debug("save block Txs rocksdb failed! ");
        }
        return rs;
    }

    private boolean commitTxs(Chain chain, Map<String, List<String>> moduleVerifyMap, String blockHeader, boolean atomicity) {
        HashMap<String, List<String>> successed = new HashMap<String, List<String>>(8);
        boolean result = true;
        for (Map.Entry<String, List<String>> entry : moduleVerifyMap.entrySet()) {
            boolean rs = TransactionCall.txProcess(chain, "txCommit", entry.getKey(), entry.getValue(), blockHeader);
            if (!rs) {
                result = false;
                chain.getLogger().error("save tx failed! commitTxs");
                break;
            }
            successed.put(entry.getKey(), entry.getValue());
        }
        if (!result && atomicity) {
            this.rollbackTxs(chain, successed, blockHeader, false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitLedger(Chain chain, List<String> txList, long blockHeight) {
        try {
            chain.getPackableState().set(false);
            boolean rs = LedgerCall.commitTxsLedger(chain, txList, blockHeight);
            if (!rs) {
                chain.getLogger().error("save block tx failed! commitLedger");
            }
            boolean bl = rs;
            return bl;
        }
        catch (NulsException e) {
            chain.getLogger().error("failed! commitLedger");
            chain.getLogger().error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            chain.getPackableState().set(true);
        }
    }

    private boolean removeTxs(Chain chain, List<Transaction> txList, long blockheight, boolean atomicity) {
        boolean rs = true;
        if (!this.confirmedTxStorageService.removeTxList(chain.getChainId(), txList) && atomicity) {
            this.saveTxs(chain, txList, blockheight, false);
            rs = false;
            chain.getLogger().debug("failed! removeTxs");
        }
        return rs;
    }

    private boolean rollbackTxs(Chain chain, Map<String, List<String>> moduleVerifyMap, String blockHeader, boolean atomicity) {
        HashMap<String, List<String>> successed = new HashMap<String, List<String>>(8);
        boolean result = true;
        for (Map.Entry<String, List<String>> entry : moduleVerifyMap.entrySet()) {
            chain.getLogger().info("[Rollback], module: {}, txCount: {}", new Object[]{entry.getKey(), entry.getValue() == null ? 0 : entry.getValue().size()});
            boolean rs = TransactionCall.txProcess(chain, "txRollback", entry.getKey(), entry.getValue(), blockHeader);
            if (!rs) {
                result = false;
                chain.getLogger().error("failed! rollbackcommitTxs ");
                break;
            }
            successed.put(entry.getKey(), entry.getValue());
        }
        if (!result && atomicity) {
            this.commitTxs(chain, successed, blockHeader, false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollbackLedger(Chain chain, List<String> txList, Long blockHeight) {
        if (txList.isEmpty()) {
            return true;
        }
        try {
            chain.getPackableState().set(false);
            boolean rs = LedgerCall.rollbackTxsLedger(chain, txList, blockHeight);
            if (!rs) {
                chain.getLogger().error("rollback block tx failed! rollbackLedger");
            }
            boolean bl = rs;
            return bl;
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            chain.getPackableState().set(true);
        }
    }

    @Override
    public boolean rollbackTxList(Chain chain, List<NulsHash> txHashList, String blockHeaderStr) throws NulsException {
        NulsLogger logger = chain.getLogger();
        if (txHashList == null || txHashList.isEmpty()) {
            throw new NulsException(TxErrorCode.PARAMETER_ERROR);
        }
        int chainId = chain.getChainId();
        BlockHeader blockHeader = (BlockHeader)TxUtil.getInstanceRpcStr(blockHeaderStr, BlockHeader.class);
        long blockHeight = blockHeader.getHeight();
        logger.info("start rollbackTxList block height:{}", new Object[]{blockHeight});
        long start = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        ArrayList<String> txStrList = new ArrayList<String>();
        ArrayList<String> crossChainTxList = new ArrayList<String>();
        HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
        try {
            for (NulsHash hash : txHashList) {
                TransactionConfirmedPO txPO = this.confirmedTxStorageService.getTx(chainId, hash);
                if (null == txPO) continue;
                Transaction tx = txPO.getTx();
                txList.add(tx);
                String txStr = RPCUtil.encode((byte[])tx.serialize());
                txStrList.add(txStr);
                if (10 == tx.getType()) {
                    crossChainTxList.add(txStr);
                }
                TxUtil.moduleGroups(chain, moduleVerifyMap, tx);
            }
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
        if (txList.isEmpty()) {
            logger.error("[rollback error] block txs is empty . -hight:{}", new Object[]{blockHeight});
            return false;
        }
        logger.debug("[Rolling back blocks] Assembly data execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - start});
        long ledgerStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.rollbackLedger(chain, txStrList, blockHeight)) {
            return false;
        }
        logger.debug("[Rolling back blocks] Rollback ledger execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - ledgerStart});
        long moduleStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.rollbackTxs(chain, moduleVerifyMap, blockHeaderStr, true)) {
            this.commitLedger(chain, txStrList, blockHeight);
            return false;
        }
        logger.debug("[Rolling back blocks] Rollback transaction business data execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - moduleStart});
        long dbStart = NulsDateUtils.getCurrentTimeMillis();
        if (!this.removeTxs(chain, txList, blockHeight, true)) {
            this.commitTxs(chain, moduleVerifyMap, blockHeaderStr, false);
            this.saveTxs(chain, txList, blockHeight, false);
            return false;
        }
        int packableTxMapDataSize = 0;
        if (chain.getPackaging().get()) {
            for (Transaction tx : chain.getPackableTxMap().values()) {
                packableTxMapDataSize += tx.size();
            }
        }
        for (int i = txList.size() - 1; i >= 0; --i) {
            Transaction tx;
            tx = (Transaction)txList.get(i);
            if (TxManager.isSystemTx(chain, tx)) continue;
            this.unconfirmedTxStorageService.putTx(chain.getChainId(), tx);
            if (!chain.getPackaging().get() || packableTxMapDataSize >= 75000000) continue;
            this.packablePool.offerFirst(chain, tx);
        }
        logger.debug("[Rolling back blocks] Rollback removalDBStored transactions, Put into unconfirmed library execution time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - dbStart});
        logger.info("rollbackTxList success block height:{}", new Object[]{blockHeight});
        return true;
    }

    @Override
    public List<String> getTxList(Chain chain, List<String> hashList) {
        ArrayList<String> txStrList = new ArrayList<String>();
        if (hashList == null || hashList.size() == 0) {
            return txStrList;
        }
        int chainId = chain.getChainId();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (String hashHex : hashList) {
            keys.add(HexUtil.decode((String)hashHex));
        }
        List<Transaction> txList = this.confirmedTxStorageService.getTxList(chainId, keys);
        if (txList.size() != hashList.size()) {
            return txStrList;
        }
        HashMap<String, String> map = new HashMap<String, String>(txList.size() * 2);
        try {
            for (Transaction tx : txList) {
                map.put(tx.getHash().toHex(), RPCUtil.encode((byte[])tx.serialize()));
            }
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return new ArrayList<String>();
        }
        for (String hash : hashList) {
            txStrList.add((String)map.get(hash));
        }
        return txStrList;
    }

    @Override
    public List<String> getTxListExtend(Chain chain, List<String> hashList, boolean allHits) {
        HashMap<String, String> map;
        ArrayList<String> txStrList;
        block7: {
            txStrList = new ArrayList<String>();
            if (hashList == null || hashList.size() == 0) {
                return txStrList;
            }
            int chainId = chain.getChainId();
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            for (String hashHex : hashList) {
                keys.add(HexUtil.decode((String)hashHex));
            }
            List<Transaction> txConfirmedList = this.confirmedTxStorageService.getTxList(chainId, keys);
            List<Transaction> txUnconfirmedList = this.unconfirmedTxStorageService.getTxList(chainId, keys);
            HashSet<Transaction> allTx = new HashSet<Transaction>();
            allTx.addAll(txConfirmedList);
            allTx.addAll(txUnconfirmedList);
            if (allHits && allTx.size() != hashList.size()) {
                return new ArrayList<String>();
            }
            map = new HashMap<String, String>(allTx.size() * 2);
            try {
                for (Transaction tx : allTx) {
                    map.put(tx.getHash().toHex(), RPCUtil.encode((byte[])tx.serialize()));
                }
            }
            catch (IOException e) {
                chain.getLogger().error((Exception)e);
                if (!allHits) break block7;
                return new ArrayList<String>();
            }
        }
        for (String hash : hashList) {
            String txHex = (String)map.get(hash);
            if (null == txHex) continue;
            txStrList.add(txHex);
        }
        return txStrList;
    }

    @Override
    public List<String> getNonexistentUnconfirmedHashList(Chain chain, List<String> hashList) {
        ArrayList<String> txHashList = new ArrayList<String>();
        if (hashList == null || hashList.size() == 0) {
            return txHashList;
        }
        int chainId = chain.getChainId();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (String hashHex : hashList) {
            keys.add(HexUtil.decode((String)hashHex));
        }
        List<String> txUnconfirmedList = this.unconfirmedTxStorageService.getExistKeysStr(chainId, keys);
        for (String hash : hashList) {
            if (txUnconfirmedList.contains(hash)) continue;
            txHashList.add(hash);
        }
        return txHashList;
    }
}

