/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.Address;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TxRegisterDetail;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.ByteArrayWrapper;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxContext;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxPackage;
import io.nuls.transaction.model.bo.TxPackageWrapper;
import io.nuls.transaction.model.bo.TxRegister;
import io.nuls.transaction.model.bo.TxVerifyWrapper;
import io.nuls.transaction.model.bo.VerifyLedgerResult;
import io.nuls.transaction.model.bo.VerifyResult;
import io.nuls.transaction.model.dto.AccountBlockDTO;
import io.nuls.transaction.model.dto.ModuleTxRegisterDTO;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.model.po.TransactionUnconfirmedPO;
import io.nuls.transaction.rpc.call.AccountCall;
import io.nuls.transaction.rpc.call.ConsensusCall;
import io.nuls.transaction.rpc.call.ContractCall;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.rpc.call.TransactionCall;
import io.nuls.transaction.service.ConfirmedTxService;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.ConfirmedTxStorageService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.TxDuplicateRemoval;
import io.nuls.transaction.utils.TxUtil;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Component
public class TxServiceImpl
implements TxService {
    @Autowired
    private PackablePool packablePool;
    @Autowired
    private UnconfirmedTxStorageService unconfirmedTxStorageService;
    @Autowired
    private ConfirmedTxService confirmedTxService;
    @Autowired
    private ConfirmedTxStorageService confirmedTxStorageService;
    @Autowired
    private NulsCoresConfig txConfig;
    private ExecutorService verifySignExecutor = ThreadUtils.createThreadPool((int)Runtime.getRuntime().availableProcessors(), (int)50000, (NulsThreadFactory)new NulsThreadFactory("verifyTxSignThread"));
    long MAX_GAS_COST_IN_BLOCK = 13000000L;

    @Override
    public boolean register(Chain chain, ModuleTxRegisterDTO moduleTxRegisterDto) {
        try {
            for (TxRegisterDetail txRegisterDto : moduleTxRegisterDto.getList()) {
                TxRegister txRegister = new TxRegister();
                txRegister.setModuleCode(moduleTxRegisterDto.getModuleCode());
                txRegister.setTxType(txRegisterDto.getTxType());
                txRegister.setSystemTx(txRegisterDto.getSystemTx());
                txRegister.setUnlockTx(txRegisterDto.getUnlockTx());
                txRegister.setVerifySignature(txRegisterDto.getVerifySignature());
                txRegister.setVerifyFee(txRegisterDto.getVerifyFee());
                chain.getTxRegisterMap().put(txRegister.getTxType(), txRegister);
                chain.getLogger().info("register:{}", new Object[]{JSONUtils.obj2json((Object)txRegister)});
            }
            List<Integer> delList = moduleTxRegisterDto.getDelList();
            if (!delList.isEmpty()) {
                delList.forEach(e -> chain.getTxRegisterMap().remove(e));
            }
            return true;
        }
        catch (Exception e2) {
            chain.getLogger().error(e2);
            return false;
        }
    }

    @Override
    public void newBroadcastTx(Chain chain, TransactionNetPO txNet) {
        Transaction tx = txNet.getTx();
        if (!this.isTxExists(chain, tx.getHash())) {
            try {
                this.verifyTransactionInCirculation(chain, tx);
                CoinData cd = tx.getCoinDataInstance();
                for (CoinFrom from : cd.getFrom()) {
                    if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])from.getAddress()) != 2) continue;
                    throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
                }
                for (CoinTo to : cd.getTo()) {
                    if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])to.getAddress()) != 2) continue;
                    throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
                }
                chain.getUnverifiedQueue().addLast(txNet);
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
            }
            catch (IllegalStateException e) {
                chain.getLogger().error("UnverifiedQueue full!");
            }
        }
    }

    @Override
    public void newTx(Chain chain, Transaction tx) throws NulsException {
        try {
            if (!chain.getProcessTxStatus().get()) {
                throw new NulsException(TxErrorCode.PAUSE_NEWTX);
            }
            NulsHash hash = tx.getHash();
            if (this.isTxExists(chain, hash)) {
                throw new NulsException(TxErrorCode.TX_ALREADY_EXISTS);
            }
            VerifyResult verifyResult = this.verify(chain, tx);
            if (!verifyResult.getResult()) {
                chain.getLogger().error("verify failed: type:{} - txhash:{}, code:{}", new Object[]{tx.getType(), hash.toHex(), verifyResult.getErrorCode().getCode()});
                throw new NulsException(ErrorCode.init((String)verifyResult.getErrorCode().getCode()));
            }
            CoinData cd = tx.getCoinDataInstance();
            for (CoinFrom from : cd.getFrom()) {
                if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])from.getAddress()) != 2) continue;
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            for (CoinTo to : cd.getTo()) {
                if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])to.getAddress()) != 2) continue;
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            VerifyLedgerResult verifyLedgerResult = LedgerCall.commitUnconfirmedTx(chain, RPCUtil.encode((byte[])tx.serialize()));
            if (!verifyLedgerResult.businessSuccess()) {
                String errorCode = verifyLedgerResult.getErrorCode() == null ? TxErrorCode.ORPHAN_TX.getCode() : verifyLedgerResult.getErrorCode().getCode();
                chain.getLogger().error("coinData verify fail - orphan: {}, - code:{}, type:{} - txhash:{}", new Object[]{verifyLedgerResult.getOrphan(), errorCode, tx.getType(), hash.toHex()});
                throw new NulsException(ErrorCode.init((String)errorCode));
            }
            if (chain.getPackaging().get()) {
                this.packablePool.add(chain, tx);
            }
            this.unconfirmedTxStorageService.putTx(chain.getChainId(), tx);
            boolean broadcastResult = false;
            for (int i = 0; i < 3 && !(broadcastResult = ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType())) ? NetworkCall.forwardTxHash(chain, tx.getHash()) : NetworkCall.broadcastTx(chain, tx)); ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    chain.getLogger().error((Exception)e);
                }
            }
            if (!broadcastResult) {
                throw new NulsException(TxErrorCode.TX_BROADCAST_FAIL);
            }
            TxDuplicateRemoval.insertAndCheck(hash.toHex());
        }
        catch (IOException e) {
            throw new NulsException(TxErrorCode.DESERIALIZE_ERROR);
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @Override
    public TransactionConfirmedPO getTransaction(Chain chain, NulsHash hash) {
        TransactionUnconfirmedPO txPo = this.unconfirmedTxStorageService.getTx(chain.getChainId(), hash);
        if (null != txPo) {
            return new TransactionConfirmedPO(txPo.getTx(), -1L, TxStatusEnum.UNCONFIRM.getStatus());
        }
        return this.confirmedTxService.getConfirmedTransaction(chain, hash);
    }

    @Override
    public boolean isTxExists(Chain chain, NulsHash hash) {
        boolean rs = this.unconfirmedTxStorageService.isExists(chain.getChainId(), hash);
        if (!rs) {
            rs = this.confirmedTxStorageService.isExists(chain.getChainId(), hash);
        }
        return rs;
    }

    public void verifyTransactionInCirculation(Chain chain, Transaction tx) throws NulsException {
        TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
        if (null == txRegister) {
            throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
        }
        if (txRegister.getSystemTx()) {
            throw new NulsException(TxErrorCode.SYS_TX_TYPE_NON_CIRCULATING);
        }
        this.baseValidateTx(chain, tx, txRegister);
    }

    @Override
    public VerifyResult verify(Chain chain, Transaction tx) {
        try {
            this.verifyTransactionInCirculation(chain, tx);
            TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
            Map<String, Object> result = TransactionCall.txModuleValidator(chain, txRegister.getModuleCode(), RPCUtil.encode((byte[])tx.serialize()));
            List txHashList = (List)result.get("list");
            if (txHashList.isEmpty()) {
                return VerifyResult.success();
            }
            chain.getLogger().error("tx validator fail -type:{}, -hash:{} ", new Object[]{tx.getType(), tx.getHash().toHex()});
            String errorCodeStr = (String)result.get("errorCode");
            ErrorCode errorCode = null == errorCodeStr ? TxErrorCode.SYS_UNKOWN_EXCEPTION : ErrorCode.init((String)errorCodeStr);
            return VerifyResult.fail(errorCode);
        }
        catch (IOException e) {
            return VerifyResult.fail(TxErrorCode.SERIALIZE_ERROR);
        }
        catch (NulsException e) {
            return VerifyResult.fail(e.getErrorCode());
        }
        catch (Exception e) {
            return VerifyResult.fail(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @Override
    public void baseValidateTx(Chain chain, Transaction tx, TxRegister txRegister) throws NulsException {
        if (null == tx) {
            throw new NulsException(TxErrorCode.TX_NOT_EXIST);
        }
        if (tx.getHash() == null || !tx.getHash().verify()) {
            throw new NulsException(TxErrorCode.HASH_ERROR);
        }
        if (!TxManager.contains(chain, tx.getType())) {
            throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
        }
        if (tx.getTime() == 0L) {
            throw new NulsException(TxErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        if ((long)tx.size() > chain.getConfig().getTxMaxSize()) {
            throw new NulsException(TxErrorCode.TX_SIZE_TOO_LARGE);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_ACCOUNT_BLOCK_UPGRADE) {
            this.validateTxSignatureProtocol12(tx, txRegister, chain);
        } else {
            this.validateTxSignature(tx, txRegister, chain);
        }
        int txType = tx.getType();
        if (txType == 7 || txType == 24 || txType == 25 || txType == 60) {
            return;
        }
        CoinData coinData = TxUtil.getCoinData(tx);
        this.validateCoinFromBase(chain, txRegister, coinData.getFrom());
        this.validateCoinToBase(chain, txRegister, coinData.getTo());
        if (txRegister.getVerifyFee()) {
            int validateTxSize = tx.size() - SerializeUtils.sizeOfBytes((byte[])tx.getTransactionSignature());
            this.validateFee(chain, tx.getType(), validateTxSize, coinData, txRegister);
        }
    }

    private void validateTxSignature(Transaction tx, TxRegister txRegister, Chain chain) throws NulsException {
        if (!txRegister.getVerifySignature() || ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
            return;
        }
        CoinData coinData = TxUtil.getCoinData(tx);
        if (null == coinData || null == coinData.getFrom() || coinData.getFrom().size() <= 0) {
            throw new NulsException(TxErrorCode.COINDATA_NOT_FOUND);
        }
        Set addressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chain.getChainId());
        if (addressSet == null) {
            throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
        }
        int chainId = chain.getChainId();
        byte[] multiSignAddress = null;
        if (tx.isMultiSignTx()) {
            MultiSignTxSignature multiSignTxSignature = new MultiSignTxSignature();
            multiSignTxSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            if (addressSet.size() < multiSignTxSignature.getM()) {
                throw new NulsException(TxErrorCode.INSUFFICIENT_SIGNATURES);
            }
            for (Object address : addressSet) {
                boolean rs = false;
                for (byte[] bytes : multiSignTxSignature.getPubKeyList()) {
                    String addr = AddressTool.getStringAddressByBytes((byte[])AddressTool.getAddress((byte[])bytes, (int)chainId));
                    if (!((String)address).equals(addr)) continue;
                    rs = true;
                }
                if (rs) continue;
                throw new NulsException(TxErrorCode.SIGN_ADDRESS_NOT_MATCH_COINFROM);
            }
            ArrayList<String> pubKeys = new ArrayList<String>();
            for (byte[] pubkey : multiSignTxSignature.getPubKeyList()) {
                pubKeys.add(HexUtil.encode((byte[])pubkey));
            }
            try {
                byte[] hash160 = SerializeUtils.sha256hash160((byte[])AddressTool.createMultiSigAccountOriginBytes((int)chainId, (int)multiSignTxSignature.getM(), pubKeys));
                Address address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, hash160);
                multiSignAddress = address.getAddressBytes();
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
            }
        }
        for (CoinFrom coinFrom : coinData.getFrom()) {
            if (tx.getType() == 9 || tx.getType() == 34) break;
            if (tx.isMultiSignTx()) {
                if (Arrays.equals(coinFrom.getAddress(), multiSignAddress)) continue;
                throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
            }
            if (addressSet.contains(AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress()))) continue;
            throw new NulsException(TxErrorCode.SIGN_ADDRESS_NOT_MATCH_COINFROM);
        }
        if (!SignatureUtil.validateTransactionSignture((int)chainId, (Transaction)tx)) {
            throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
        }
    }

    private void validateTxSignatureProtocol12(Transaction tx, TxRegister txRegister, Chain chain) throws NulsException {
        int txType;
        Set addressSet;
        if (!txRegister.getVerifySignature()) {
            return;
        }
        CoinData coinData = TxUtil.getCoinData(tx);
        if (null == coinData || null == coinData.getFrom() || coinData.getFrom().size() <= 0) {
            throw new NulsException(TxErrorCode.COINDATA_NOT_FOUND);
        }
        if (ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
            if (tx.getType() != 10) {
                return;
            }
            int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress());
            if (chain.getChainId() != fromChainId) {
                return;
            }
        }
        if ((addressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chain.getChainId())) == null) {
            throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
        }
        int chainId = chain.getChainId();
        byte[] multiSignAddress = null;
        if (tx.isMultiSignTx()) {
            MultiSignTxSignature multiSignTxSignature = new MultiSignTxSignature();
            multiSignTxSignature.parse(new NulsByteBuffer(tx.getTransactionSignature()));
            if (addressSet.size() < multiSignTxSignature.getM()) {
                throw new NulsException(TxErrorCode.INSUFFICIENT_SIGNATURES);
            }
            for (Object address : addressSet) {
                boolean rs = false;
                for (byte[] bytes : multiSignTxSignature.getPubKeyList()) {
                    String addr = AddressTool.getStringAddressByBytes((byte[])AddressTool.getAddress((byte[])bytes, (int)chainId));
                    if (!((String)address).equals(addr)) continue;
                    rs = true;
                }
                if (rs) continue;
                throw new NulsException(TxErrorCode.SIGN_ADDRESS_NOT_MATCH_COINFROM);
            }
            ArrayList<String> pubKeys = new ArrayList<String>();
            for (byte[] pubkey : multiSignTxSignature.getPubKeyList()) {
                pubKeys.add(HexUtil.encode((byte[])pubkey));
            }
            try {
                byte[] hash160 = SerializeUtils.sha256hash160((byte[])AddressTool.createMultiSigAccountOriginBytes((int)chainId, (int)multiSignTxSignature.getM(), pubKeys));
                Address address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, hash160);
                multiSignAddress = address.getAddressBytes();
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
            }
        }
        for (CoinFrom coinFrom : coinData.getFrom()) {
            if (tx.getType() == 9 || tx.getType() == 34) break;
            if (tx.isMultiSignTx()) {
                if (Arrays.equals(coinFrom.getAddress(), multiSignAddress)) continue;
                throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
            }
            if (addressSet.contains(AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress()))) continue;
            throw new NulsException(TxErrorCode.SIGN_ADDRESS_NOT_MATCH_COINFROM);
        }
        if ((txType = tx.getType()) != 5 && txType != 6 && txType != 9 && txType != 34) {
            boolean needAccountManagerSign = false;
            for (CoinFrom coinFrom : coinData.getFrom()) {
                byte[] fromAddress = coinFrom.getAddress();
                AccountBlockDTO dto = AccountCall.getBlockAccount(chainId, AddressTool.getStringAddressByBytes((byte[])fromAddress));
                if (dto == null) continue;
                int[] types = dto.getTypes();
                if (types == null) {
                    needAccountManagerSign = true;
                    break;
                }
                boolean whiteType = false;
                for (int type : types) {
                    if (txType != type) continue;
                    whiteType = true;
                    break;
                }
                if (!whiteType) {
                    needAccountManagerSign = true;
                    break;
                }
                if (txType != 16) continue;
                if (dto.getContracts() == null || dto.getContracts().length == 0) {
                    needAccountManagerSign = true;
                    break;
                }
                String[] contracts = dto.getContracts();
                NulsByteBuffer byteBuffer = new NulsByteBuffer(tx.getTxData());
                byteBuffer.readBytes(23);
                byte[] contractAddressBytes = byteBuffer.readBytes(23);
                String contractAddress = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
                boolean whiteContract = false;
                for (String contract : contracts) {
                    if (!contractAddress.equals(contract)) continue;
                    whiteContract = true;
                    break;
                }
                if (whiteContract) continue;
                needAccountManagerSign = true;
                break;
            }
            if (needAccountManagerSign) {
                int count = 0;
                for (String signedAddress : addressSet) {
                    if (!TxContext.ACCOUNT_BLOCK_MANAGER_ADDRESS_SET.contains(signedAddress)) continue;
                    ++count;
                }
                if (count < TxContext.ACCOUNT_BLOCK_MIN_SIGN_COUNT) {
                    throw new NulsException(TxErrorCode.BLOCK_ADDRESS, "address is blockAddress Exception");
                }
            }
        }
        if (!SignatureUtil.validateTransactionSignture((int)chainId, (Transaction)tx)) {
            throw new NulsException(TxErrorCode.SIGNATURE_ERROR);
        }
    }

    private void validateCoinFromBase(Chain chain, TxRegister txRegister, List<CoinFrom> listFrom) throws NulsException {
        int type = txRegister.getTxType();
        if (type == 1 || type == 19) {
            return;
        }
        if (null == listFrom || listFrom.size() == 0) {
            throw new NulsException(TxErrorCode.COINFROM_NOT_FOUND);
        }
        int chainId = chain.getConfig().getChainId();
        Integer fromChainId = null;
        HashSet<CallSite> uniqueCoin = new HashSet<CallSite>();
        byte[] existMultiSignAddress = null;
        boolean forked = chain.getBestBlockHeight() >= 878000L;
        for (CoinFrom coinFrom : listFrom) {
            int assetsId;
            byte[] addrBytes = coinFrom.getAddress();
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) < TxContext.UPDATE_VERSION_ACCOUNT_BLOCK_UPGRADE && type != 5 && type != 6 && TxUtil.isBlockAddress(chainId, addrBytes)) {
                throw new NulsException(TxErrorCode.BLOCK_ADDRESS, "address is blockAddress Exception");
            }
            if (AddressTool.isBlackHoleAddress((byte[])TxUtil.blackHolePublicKey, (int)chainId, (byte[])addrBytes)) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is blackHoleAddress Exception");
            }
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= TxContext.UPDATE_VERSION_CM_UPGRADE && chainId == 1 && AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress()) == 2) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            if (forked && TxUtil.isBlackHoleAddress(chainId, addrBytes)) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "Address is blackHoleAddress Exception[x]");
            }
            String addr = AddressTool.getStringAddressByBytes((byte[])addrBytes);
            int validAddressChainId = chainId;
            if (ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(type))) {
                validAddressChainId = AddressTool.getChainIdByAddress((byte[])addrBytes);
            }
            if (!AddressTool.validAddress((int)validAddressChainId, (String)addr)) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS);
            }
            if (null == existMultiSignAddress && AddressTool.isMultiSignAddress((byte[])addrBytes)) {
                existMultiSignAddress = addrBytes;
            }
            int addrChainId = AddressTool.getChainIdByAddress((byte[])addrBytes);
            if (coinFrom.getAmount().compareTo(BigInteger.ZERO) < 0) {
                throw new NulsException(TxErrorCode.DATA_ERROR);
            }
            if (null == fromChainId) {
                fromChainId = addrChainId;
            } else if (fromChainId != addrChainId) {
                throw new NulsException(TxErrorCode.COINFROM_NOT_SAME_CHAINID);
            }
            if (!TxManager.isCrossTx(type) && chainId != addrChainId) {
                throw new NulsException(TxErrorCode.FROM_ADDRESS_NOT_MATCH_CHAIN);
            }
            int assetsChainId = coinFrom.getAssetsChainId();
            boolean rs = uniqueCoin.add((CallSite)((Object)(addr + "-" + assetsChainId + "-" + (assetsId = coinFrom.getAssetsId()) + "-" + HexUtil.encode((byte[])coinFrom.getNonce()))));
            if (!rs) {
                throw new NulsException(TxErrorCode.COINFROM_HAS_DUPLICATE_COIN);
            }
            if (type != 9 && type != 8 && TxUtil.isLegalContractAddress(coinFrom.getAddress(), chain)) {
                chain.getLogger().error("Tx from cannot have contract address ");
                throw new NulsException(TxErrorCode.TX_FROM_CANNOT_HAS_CONTRACT_ADDRESS);
            }
            if (txRegister.getUnlockTx() || coinFrom.getLocked() != -1) continue;
            chain.getLogger().error("This transaction type can not unlock the token");
            throw new NulsException(TxErrorCode.TX_VERIFY_FAIL);
        }
        if (null != existMultiSignAddress && type != 9 && type != 34 && type != 8) {
            for (CoinFrom coinFrom : listFrom) {
                if (Arrays.equals(existMultiSignAddress, coinFrom.getAddress())) continue;
                throw new NulsException(TxErrorCode.MULTI_SIGN_TX_ONLY_SAME_ADDRESS);
            }
        }
    }

    private void validateCoinToBase(Chain chain, TxRegister txRegister, List<CoinTo> listTo) throws NulsException {
        String moduleCode = txRegister.getModuleCode();
        int type = txRegister.getTxType();
        if (!(type == 1 || ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(type)) || null != listTo && listTo.size() != 0)) {
            throw new NulsException(TxErrorCode.COINTO_NOT_FOUND);
        }
        int localChainId = chain.getChainId();
        Integer addressChainId = null;
        int txChainId = chain.getChainId();
        HashSet<CallSite> uniqueCoin = new HashSet<CallSite>();
        for (CoinTo coinTo : listTo) {
            boolean sysTx;
            long lockTime;
            int assetsId;
            String addr = AddressTool.getStringAddressByBytes((byte[])coinTo.getAddress());
            int validAddressChainId = txChainId;
            if (ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(type))) {
                validAddressChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            }
            if (ProtocolGroupManager.getCurrentVersion((int)localChainId) >= TxContext.UPDATE_VERSION_CM_UPGRADE && localChainId == 1 && AddressTool.getChainIdByAddress((byte[])coinTo.getAddress()) == 2) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            if (!AddressTool.validAddress((int)validAddressChainId, (String)addr)) {
                throw new NulsException(TxErrorCode.INVALID_ADDRESS);
            }
            int chainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            if (null == addressChainId) {
                addressChainId = chainId;
            } else if (addressChainId != chainId) {
                throw new NulsException(TxErrorCode.COINTO_NOT_SAME_CHAINID);
            }
            if (coinTo.getAmount().compareTo(BigInteger.ZERO) < 0) {
                throw new NulsException(TxErrorCode.DATA_ERROR);
            }
            if (!TxManager.isCrossTx(type) && chainId != txChainId) {
                throw new NulsException(TxErrorCode.TO_ADDRESS_NOT_MATCH_CHAIN);
            }
            int assetsChainId = coinTo.getAssetsChainId();
            boolean rs = uniqueCoin.add((CallSite)((Object)(addr + "-" + assetsChainId + "-" + (assetsId = coinTo.getAssetsId()) + "-" + (lockTime = coinTo.getLockTime()))));
            if (!rs) {
                throw new NulsException(TxErrorCode.COINTO_HAS_DUPLICATE_COIN);
            }
            if (!TxUtil.isLegalContractAddress(coinTo.getAddress(), chain) || (sysTx = txRegister.getSystemTx()) || type == 1 || type == 16 || type == 9) continue;
            chain.getLogger().error("contract data error: The contract does not accept transfers of this type{} of transaction.", new Object[]{type});
            throw new NulsException(TxErrorCode.TX_DATA_VALIDATION_ERROR);
        }
    }

    private void validateFee(Chain chain, int type, int txSize, CoinData coinData, TxRegister txRegister) throws NulsException {
        if (txRegister.getSystemTx()) {
            return;
        }
        if (TxManager.isCrossTx(type) && AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress()) != chain.getChainId()) {
            int feeAssetId;
            int feeAssetChainId = this.txConfig.getMainChainId();
            BigInteger fee = coinData.getFeeByAsset(feeAssetChainId, feeAssetId = this.txConfig.getMainAssetId());
            if (BigIntegerUtils.isEqualOrLessThan((BigInteger)fee, (BigInteger)BigInteger.ZERO)) {
                throw new NulsException(TxErrorCode.INSUFFICIENT_FEE);
            }
            BigInteger targetFee = TxManager.isCrossTx(type) ? TransactionFeeCalculator.getCrossTxFee((int)txSize) : TransactionFeeCalculator.getNormalTxFee((int)txSize, (long)chain.getConfig().getFeeUnit(feeAssetChainId, feeAssetId));
            if (BigIntegerUtils.isLessThan((BigInteger)fee, (BigInteger)targetFee)) {
                throw new NulsException(TxErrorCode.INSUFFICIENT_FEE);
            }
        } else {
            boolean result = false;
            Set<String> set = chain.getConfig().getFeeAssetsSet();
            for (String tokenId : set) {
                BigInteger targetFee;
                String[] arr = tokenId.split("-");
                int feeAssetChainId = Integer.parseInt(arr[0]);
                int feeAssetId = Integer.parseInt(arr[1]);
                if (feeAssetId != 1 && ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) < ContractContext.PROTOCOL_20) continue;
                BigInteger fee = coinData.getFeeByAsset(feeAssetChainId, feeAssetId);
                chain.getLogger().info("{}-{} ::###:: {}");
                if (BigIntegerUtils.isEqualOrLessThan((BigInteger)fee, (BigInteger)BigInteger.ZERO) || BigIntegerUtils.isLessThan((BigInteger)fee, (BigInteger)(targetFee = TxManager.isCrossTx(type) ? TransactionFeeCalculator.getCrossTxFee((int)txSize) : TransactionFeeCalculator.getNormalTxFee((int)txSize, (long)chain.getConfig().getFeeUnit(feeAssetChainId, feeAssetId))))) continue;
                result = true;
                break;
            }
            if (!result) {
                throw new NulsException(TxErrorCode.INSUFFICIENT_FEE);
            }
        }
    }

    private void backTempPackablePool(Chain chain, List<TxPackageWrapper> listTx) {
        for (int i = listTx.size() - 1; i >= 0; --i) {
            this.packablePool.offerFirstOnlyHash(chain, listTx.get(i).getTx());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxPackage getPackableTxs(Chain chain, long endtimestamp, long maxTxDataSize, long blockTime, String packingAddress, String preStateRoot) {
        chain.getPackageLock().lock();
        long startTime = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<TxPackageWrapper> packingTxList = new ArrayList<TxPackageWrapper>();
        HashSet<TxPackageWrapper> orphanTxSet = new HashSet<TxPackageWrapper>();
        NulsLogger nulsLogger = chain.getLogger();
        try {
            String csTxStr;
            TxPackageWrapper txPackageWrapper;
            long blockHeight = chain.getBestBlockHeight() + 1L;
            long packableTime = endtimestamp - startTime;
            nulsLogger.info("[Package start] -Packaging time\uff1a{}, -Packable capacity\uff1a{}B , - height:{}, - Current queue transactions to be packagedhashnumber:{}, - Actual number of transactions in the queue to be packaged:{}", new Object[]{packableTime, maxTxDataSize, blockHeight, this.packablePool.packableHashQueueSize(chain), this.packablePool.packableTxMapSize(chain)});
            long batchValidReserve = 2000L;
            if (packableTime <= batchValidReserve) {
                TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                return txPackage;
            }
            chain.setContractTxFail(false);
            HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
            long packingTime = endtimestamp - startTime;
            int allSleepTime = 0;
            long totalLedgerTime = 0L;
            long totalSize = 0L;
            long totalSizeTemp = 0L;
            int maxCount = 8000;
            long packageRpcReserveTime = chain.getConfig().getPackageRpcReserveTime();
            boolean contractNotify = false;
            LedgerCall.coinDataBatchNotify(chain);
            ArrayList<String> batchProcessList = new ArrayList<String>();
            HashSet<String> duplicatesVerify = new HashSet<String>();
            ArrayList<TxPackageWrapper> currentBatchPackableTxs = new ArrayList<TxPackageWrapper>();
            int corssTxCount = 0;
            int batchCorssTxCount = 0;
            int contractTxCount = 0;
            int batchContractTxCount = 0;
            boolean stopInvokeContract = false;
            Random random = new Random();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            int packageContractTxMaxCount = availableProcessors <= 4 ? 20 + random.nextInt(10) : (availableProcessors <= 8 ? 50 + random.nextInt(10) : 100 + random.nextInt(20));
            int index = 0;
            while (true) {
                block59: {
                    long verifyLedgerStart;
                    boolean maxDataSize;
                    Transaction tx;
                    block60: {
                        long currentTimeMillis;
                        long currentReserve;
                        if ((currentReserve = endtimestamp - (currentTimeMillis = NulsDateUtils.getCurrentTimeMillis())) <= batchValidReserve) {
                            if (nulsLogger.isDebugEnabled()) {
                                nulsLogger.debug("Get transaction time up to,Entering the module validation phase: currentTimeMillis:{}, -endtimestamp:{}, -offset:{}, -remaining:{}", new Object[]{currentTimeMillis, endtimestamp, batchValidReserve, currentReserve});
                            }
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            break;
                        }
                        if (currentReserve < packageRpcReserveTime) {
                            nulsLogger.error("getPackableTxs time out, endtimestamp:{}, current:{}, endtimestamp-current:{}, reserveTime:{}", new Object[]{endtimestamp, currentTimeMillis, currentReserve, packageRpcReserveTime});
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            throw new NulsException(TxErrorCode.PACKAGE_TIME_OUT);
                        }
                        if (chain.getProtocolUpgrade().get()) {
                            chain.getCanProtocolUpgrade().set(false);
                            nulsLogger.info("1_chain.getCanProtocolUpgrade().set(false);");
                            nulsLogger.info("Protocol Upgrade Package stop -chain:{} -best block height", new Object[]{chain.getChainId(), chain.getBestBlockHeight()});
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                            TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                            chain.getCanProtocolUpgrade().set(true);
                            nulsLogger.info("1_chain.getCanProtocolUpgrade().set(true);");
                            TxPackage txPackage2 = txPackage;
                            return txPackage2;
                        }
                        if (blockHeight < chain.getBestBlockHeight() + 1L) {
                            nulsLogger.info("Obtaining the latest block height during the transaction process has increased,Put the retrieved transactions and orphans back into the packaging queue, Repackaging...");
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                            TxPackage txPackage = this.getPackableTxs(chain, endtimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot);
                            return txPackage;
                        }
                        if (packingTxList.size() > maxCount) {
                            if (nulsLogger.isDebugEnabled()) {
                                nulsLogger.debug("Obtaining transaction completedmax count,Entering the module validation phase: currentTimeMillis:{}, -endtimestamp:{}, -offset:{}, -remaining:{}", new Object[]{currentTimeMillis, endtimestamp, batchValidReserve, endtimestamp - currentTimeMillis});
                            }
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            break;
                        }
                        int batchProcessListSize = batchProcessList.size();
                        boolean process = false;
                        tx = null;
                        maxDataSize = false;
                        tx = this.packablePool.poll(chain);
                        if (tx == null && batchProcessListSize == 0) {
                            Thread.sleep(10L);
                            allSleepTime += 10;
                            break block59;
                        }
                        if (tx == null && batchProcessListSize > 0) {
                            process = true;
                        } else if (tx != null) {
                            if (!duplicatesVerify.add(tx.getHash().toHex())) break block59;
                            long txSize = tx.size();
                            if (totalSizeTemp + txSize > maxTxDataSize) {
                                this.packablePool.offerFirstOnlyHash(chain, tx);
                                nulsLogger.info("The transaction has reached its maximum capacity, actual value: {}, totalSizeTemp:{}, Current transactionsize\uff1a{} - Reserve maximum valuemaxTxDataSize:{}, txhash:{}", new Object[]{totalSize, totalSizeTemp, txSize, maxTxDataSize, tx.getHash().toHex()});
                                maxDataSize = true;
                                if (batchProcessListSize <= 0) break;
                                process = true;
                            } else {
                                String txHex;
                                boolean isContract;
                                if (ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType())) && corssTxCount + ++batchCorssTxCount >= 500) {
                                    this.packablePool.add(chain, tx);
                                    if (batchProcessListSize <= 0) break;
                                    process = true;
                                }
                                if ((isContract = ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) && contractTxCount + ++batchContractTxCount >= packageContractTxMaxCount) {
                                    this.packablePool.add(chain, tx);
                                    if (batchProcessListSize <= 0) break;
                                    process = true;
                                }
                                try {
                                    txHex = RPCUtil.encode((byte[])tx.serialize());
                                }
                                catch (Exception e) {
                                    nulsLogger.warn(e.getMessage(), (Throwable)e);
                                    nulsLogger.error("Discard acquisitionhexWrong transaction, txHash:{}, - type:{}, - time:{}", new Object[]{tx.getHash().toHex(), tx.getType(), tx.getTime()});
                                    this.clearInvalidTx(chain, tx);
                                    break block59;
                                }
                                txPackageWrapper = new TxPackageWrapper(tx, index, txHex);
                                batchProcessList.add(txHex);
                                currentBatchPackableTxs.add(txPackageWrapper);
                                if (batchProcessList.size() == 2000) {
                                    process = true;
                                }
                            }
                            totalSizeTemp += txSize;
                        }
                        if (!process) break block59;
                        verifyLedgerStart = NulsDateUtils.getCurrentTimeMillis();
                        if (chain.getPackableState().get()) break block60;
                        nulsLogger.info("Saving or rolling back blocks during the transaction process triggers ledger submission or rollback, Repackaging...");
                        packingTxList.addAll(currentBatchPackableTxs);
                        this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                        Thread.sleep(30L);
                        TxPackage isContract = this.getPackableTxs(chain, endtimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot);
                        return isContract;
                    }
                    try {
                        this.verifyLedger(chain, batchProcessList, currentBatchPackableTxs, orphanTxSet, false, false);
                        totalLedgerTime += NulsDateUtils.getCurrentTimeMillis() - verifyLedgerStart;
                        Iterator it = currentBatchPackableTxs.iterator();
                        while (it.hasNext()) {
                            boolean isCrossTx;
                            boolean isSmartContractTx;
                            TxRegister txRegister;
                            Transaction transaction;
                            block61: {
                                TxPackageWrapper txPackageWrapper2 = (TxPackageWrapper)it.next();
                                transaction = txPackageWrapper2.getTx();
                                txRegister = TxManager.getTxRegister(chain, transaction.getType());
                                String moduleCode = txRegister.getModuleCode();
                                isSmartContractTx = ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(transaction.getType()));
                                isCrossTx = ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(transaction.getType()));
                                if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_V250) {
                                    boolean isCrossTransferTx;
                                    boolean bl = isCrossTransferTx = 10 == transaction.getType();
                                    if (!isSmartContractTx && this.txConfig.isCollectedSmartContractModule()) {
                                        isSmartContractTx = isCrossTransferTx;
                                    }
                                }
                                if (isSmartContractTx) {
                                    if (stopInvokeContract) {
                                        orphanTxSet.add(txPackageWrapper2);
                                        it.remove();
                                        continue;
                                    }
                                    if (!contractNotify) {
                                        ContractCall.contractBatchBegin(chain, blockHeight, blockTime, packingAddress, preStateRoot, 0);
                                        contractNotify = true;
                                    }
                                    try {
                                        boolean invokeContractRs = ContractCall.invokeContract(chain, txPackageWrapper2.getTxHex(), 0);
                                        if (!invokeContractRs) {
                                            stopInvokeContract = true;
                                            orphanTxSet.add(txPackageWrapper2);
                                            it.remove();
                                        }
                                        break block61;
                                    }
                                    catch (NulsException e) {
                                        chain.getLogger().error(e);
                                        this.clearInvalidTx(chain, transaction);
                                    }
                                    continue;
                                }
                            }
                            totalSize += (long)transaction.getSize();
                            if (isCrossTx) {
                                ++corssTxCount;
                            }
                            if (isSmartContractTx) {
                                ++contractTxCount;
                            }
                            TxUtil.moduleGroups(moduleVerifyMap, txRegister, RPCUtil.encode((byte[])transaction.serialize()));
                        }
                        totalSizeTemp = totalSize;
                        packingTxList.addAll(currentBatchPackableTxs);
                        batchProcessList.clear();
                        currentBatchPackableTxs.clear();
                        batchCorssTxCount = 0;
                        batchContractTxCount = 0;
                        if (maxDataSize) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        currentBatchPackableTxs.clear();
                        nulsLogger.error("Packaging transaction exception, txHash:{}, - type:{}, - time:{}", new Object[]{tx.getHash().toHex(), tx.getType(), tx.getTime()});
                        nulsLogger.error(e);
                    }
                }
                ++index;
            }
            long whileTime = NulsDateUtils.getCurrentTimeMillis() - startTime;
            if (nulsLogger.isDebugEnabled()) {
                nulsLogger.debug("-Retrieved transactions -count:{} - data size:{}", new Object[]{packingTxList.size(), totalSize});
            }
            boolean contractBefore = false;
            if (contractNotify) {
                contractBefore = ContractCall.contractBatchBeforeEnd(chain, blockHeight, 0);
            }
            String stateRoot = preStateRoot;
            boolean hasTxbackPackablePool = false;
            long contractStart = NulsDateUtils.getCurrentTimeMillis();
            ArrayList<String> contractGenerateTxs = new ArrayList<String>();
            if (contractNotify && !chain.getContractTxFail()) {
                Map map = this.processContractResult(chain, packingTxList, orphanTxSet, contractGenerateTxs, blockHeight, contractBefore, stateRoot);
                stateRoot = (String)map.get("stateRoot");
                hasTxbackPackablePool = (Boolean)map.get("hasTxbackPackablePool");
            }
            if (stopInvokeContract || hasTxbackPackablePool) {
                moduleVerifyMap = new HashMap(16);
                this.verifyAgain(chain, moduleVerifyMap, packingTxList, orphanTxSet, true);
            }
            long contractTime = NulsDateUtils.getCurrentTimeMillis() - contractStart;
            long batchStart = NulsDateUtils.getCurrentTimeMillis();
            this.txModuleValidatorPackable(chain, moduleVerifyMap, packingTxList, orphanTxSet);
            long batchModuleTime = NulsDateUtils.getCurrentTimeMillis() - batchStart;
            ArrayList<String> packableTxs = new ArrayList<String>();
            Iterator iterator = packingTxList.iterator();
            Map<NulsHash, Integer> txPackageOrphanMap = chain.getTxPackageOrphanMap();
            while (iterator.hasNext()) {
                txPackageWrapper = (TxPackageWrapper)iterator.next();
                Transaction tx = txPackageWrapper.getTx();
                NulsHash hash = tx.getHash();
                if (txPackageOrphanMap.containsKey(hash)) {
                    txPackageOrphanMap.remove(hash);
                }
                try {
                    packableTxs.add(RPCUtil.encode((byte[])tx.serialize()));
                }
                catch (Exception e) {
                    this.clearInvalidTx(chain, tx);
                    iterator.remove();
                    throw new NulsException((Throwable)e);
                }
            }
            if (!hasTxbackPackablePool && contractGenerateTxs.size() > 0 && TxUtil.extractTxTypeFromTx(csTxStr = (String)contractGenerateTxs.get(contractGenerateTxs.size() - 1)) == 19) {
                packableTxs.add(csTxStr);
            }
            if (blockHeight < chain.getBestBlockHeight() + 1L) {
                nulsLogger.info("Obtain transaction completion time,The current latest height has increased,Not enough time to repackage,Directly timeout exception handling transaction rollback to the queue to be packaged,Empty block");
                throw new NulsException(TxErrorCode.HEIGHT_UPDATE_UNABLE_TO_REPACKAGE);
            }
            this.putBackPackablePool(chain, orphanTxSet);
            if (chain.getProtocolUpgrade().get()) {
                Object txPackageWrapper3;
                chain.getCanProtocolUpgrade().set(false);
                nulsLogger.info("2_chain.getCanProtocolUpgrade().set(false);");
                int size = packingTxList.size();
                for (int i = size - 1; i >= 0; --i) {
                    txPackageWrapper3 = (TxPackageWrapper)packingTxList.get(i);
                    Transaction tx = ((TxPackageWrapper)txPackageWrapper3).getTx();
                    TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                    if (null == txRegister) {
                        throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
                    }
                    this.baseValidateTx(chain, tx, txRegister);
                    chain.getUnverifiedQueue().addLast(new TransactionNetPO(((TxPackageWrapper)txPackageWrapper3).getTx()));
                }
                TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                chain.getCanProtocolUpgrade().set(true);
                nulsLogger.info("2_chain.getCanProtocolUpgrade().set(true);");
                txPackageWrapper3 = txPackage;
                return txPackageWrapper3;
            }
            long current = NulsDateUtils.getCurrentTimeMillis();
            if (endtimestamp - current < packageRpcReserveTime) {
                nulsLogger.error("getPackableTxs time out, endtimestamp:{}, current:{}, endtimestamp-current:{}, reserveTime:{}", new Object[]{endtimestamp, current, endtimestamp - current, packageRpcReserveTime});
                throw new NulsException(TxErrorCode.PACKAGE_TIME_OUT);
            }
            TxPackage txPackage = new TxPackage(packableTxs, stateRoot, blockHeight);
            long totalTime = NulsDateUtils.getCurrentTimeMillis() - startTime;
            nulsLogger.info("[Packaging time statistics]  Total execution time:{}, Remaining time:{}, Packaging available time:{}, Obtain transactions(loop)Total waiting time:{}, Obtain transactions(loop)execution time:{}, Obtain transactions(loop)Total time for verifying ledger:{}, Module unified verification execution time:{}, Contract execution time:{},", new Object[]{totalTime, endtimestamp - NulsDateUtils.getCurrentTimeMillis(), packingTime, allSleepTime, whileTime, totalLedgerTime, batchModuleTime, contractTime});
            nulsLogger.info("[Package end] - height:{} - The number of packaged transactions this time:{} - Current queue transactions to be packagedhashnumber:{}, - Actual number of transactions in the queue to be packaged:{}" + TxUtil.nextLine(), new Object[]{blockHeight, packableTxs.size(), this.packablePool.packableHashQueueSize(chain), this.packablePool.packableTxMapSize(chain)});
            TxPackage txPackage3 = txPackage;
            return txPackage3;
        }
        catch (Exception e) {
            nulsLogger.error(e);
            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
            TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
            return txPackage;
        }
        finally {
            chain.getPackageLock().unlock();
        }
    }

    private void verifyLedger(Chain chain, List<String> batchProcessList, List<TxPackageWrapper> currentBatchPackableTxs, Set<TxPackageWrapper> orphanTxSet, boolean proccessContract, boolean orphanNoCount) throws NulsException {
        Map verifyCoinDataResult = LedgerCall.verifyCoinDataBatchPackaged(chain, batchProcessList);
        List failHashs = (List)verifyCoinDataResult.get("fail");
        List orphanHashs = (List)verifyCoinDataResult.get("orphan");
        if (!failHashs.isEmpty() || !orphanHashs.isEmpty()) {
            chain.getLogger().error("Package verify Ledger fail tx count:{}", new Object[]{failHashs.size()});
            chain.getLogger().error("Package verify Ledger orphan tx count:{}", new Object[]{orphanHashs.size()});
            Iterator<TxPackageWrapper> it = currentBatchPackableTxs.iterator();
            boolean backContract = false;
            block0: while (it.hasNext()) {
                String hashStr;
                TxPackageWrapper txPackageWrapper = it.next();
                Transaction transaction = txPackageWrapper.getTx();
                for (String hash : failHashs) {
                    if (!hash.equals(hashStr = transaction.getHash().toHex())) continue;
                    if (!backContract && proccessContract && TxManager.isUnSystemSmartContract(chain, transaction.getType())) {
                        backContract = true;
                    } else {
                        this.clearInvalidTx(chain, transaction);
                    }
                    it.remove();
                    continue block0;
                }
                for (String hash : orphanHashs) {
                    if (!hash.equals(hashStr = transaction.getHash().toHex())) continue;
                    if (!backContract && proccessContract && TxManager.isUnSystemSmartContract(chain, transaction.getType())) {
                        backContract = true;
                    } else if (orphanNoCount) {
                        orphanTxSet.add(txPackageWrapper);
                    } else {
                        this.addOrphanTxSet(chain, orphanTxSet, txPackageWrapper);
                    }
                    it.remove();
                    continue block0;
                }
            }
            if (backContract && proccessContract) {
                Iterator<TxPackageWrapper> its = currentBatchPackableTxs.iterator();
                while (its.hasNext()) {
                    TxPackageWrapper txPackageWrapper = it.next();
                    Transaction transaction = txPackageWrapper.getTx();
                    if (!TxManager.isUnSystemSmartContract(chain, transaction.getType())) continue;
                    this.packablePool.offerFirstOnlyHash(chain, transaction);
                    chain.setContractTxFail(true);
                    it.remove();
                }
            }
        }
    }

    private Map processContractResult(Chain chain, List<TxPackageWrapper> packingTxList, Set<TxPackageWrapper> orphanTxSet, List<String> contractGenerateTxs, long blockHeight, boolean contractBefore, String stateRoot) throws IOException {
        boolean hasTxbackPackablePool = false;
        boolean isRollbackPackablePool = false;
        HashSet<String> setLimitedRollbackOriginTx = new HashSet<String>();
        if (!contractBefore) {
            isRollbackPackablePool = true;
        } else {
            try {
                List nonexecutionList;
                Map<String, Object> map = ContractCall.contractPackageBatchEnd(chain, blockHeight);
                List scNewList = (List)map.get("txList");
                List originTxList = (List)map.get("originTxList");
                if (null != scNewList) {
                    ArrayList<String> scNewConsensusList = new ArrayList<String>();
                    ArrayList<String> scNewTokenCrossTransferList = new ArrayList<String>();
                    for (int i = 0; i < scNewList.size(); ++i) {
                        String scNewTx = (String)scNewList.get(i);
                        int scNewTxType = TxUtil.extractTxTypeFromTx(scNewTx);
                        if (scNewTxType == 20 || scNewTxType == 21 || scNewTxType == 22 || scNewTxType == 23) {
                            scNewConsensusList.add(scNewTx);
                            setLimitedRollbackOriginTx.add((String)originTxList.get(i));
                            continue;
                        }
                        if (scNewTxType != 26) continue;
                        scNewTokenCrossTransferList.add(scNewTx);
                    }
                    if (!scNewConsensusList.isEmpty() || !scNewTokenCrossTransferList.isEmpty()) {
                        ArrayList<String> consensusList = new ArrayList<String>();
                        ArrayList<String> crossTransferList = new ArrayList<String>();
                        for (TxPackageWrapper txPackageWrapper : packingTxList) {
                            Transaction tx = txPackageWrapper.getTx();
                            if (ModuleE.CS.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
                                consensusList.add(RPCUtil.encode((byte[])txPackageWrapper.getTx().serialize()));
                            }
                            if (!ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) continue;
                            crossTransferList.add(RPCUtil.encode((byte[])txPackageWrapper.getTx().serialize()));
                        }
                        consensusList.addAll(scNewConsensusList);
                        crossTransferList.addAll(scNewTokenCrossTransferList);
                        if (!consensusList.isEmpty()) {
                            isRollbackPackablePool = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CS.abbr), consensusList, packingTxList, false);
                        }
                        if (!isRollbackPackablePool && !crossTransferList.isEmpty()) {
                            isRollbackPackablePool = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CC.abbr), crossTransferList, packingTxList, false);
                        }
                    }
                    if (!isRollbackPackablePool) {
                        String sr = (String)map.get("stateRoot");
                        if (null != sr) {
                            stateRoot = sr;
                        }
                        contractGenerateTxs.addAll(scNewList);
                    }
                }
                if (!isRollbackPackablePool && null != (nonexecutionList = (List)map.get("pendingTxHashList")) && !nonexecutionList.isEmpty()) {
                    chain.getLogger().debug("contract pending tx count:{} ", new Object[]{nonexecutionList.size()});
                    Iterator<TxPackageWrapper> iterator = packingTxList.iterator();
                    block4: while (iterator.hasNext()) {
                        TxPackageWrapper txPackageWrapper = iterator.next();
                        for (String hash : nonexecutionList) {
                            if (!hash.equals(txPackageWrapper.getTx().getHash().toHex())) continue;
                            orphanTxSet.add(txPackageWrapper);
                            iterator.remove();
                            if (hasTxbackPackablePool) continue block4;
                            hasTxbackPackablePool = true;
                            continue block4;
                        }
                    }
                }
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                isRollbackPackablePool = true;
            }
        }
        if (isRollbackPackablePool) {
            Iterator<TxPackageWrapper> iterator = packingTxList.iterator();
            while (iterator.hasNext()) {
                TxPackageWrapper txPackageWrapper = iterator.next();
                if (!TxManager.isUnSystemSmartContract(chain, txPackageWrapper.getTx().getType())) continue;
                if (setLimitedRollbackOriginTx.contains(txPackageWrapper.getTx().getHash().toHex())) {
                    this.addOrphanTxSet(chain, orphanTxSet, txPackageWrapper);
                } else {
                    orphanTxSet.add(txPackageWrapper);
                }
                iterator.remove();
                if (hasTxbackPackablePool) continue;
                hasTxbackPackablePool = true;
            }
        }
        HashMap<String, Object> rs = new HashMap<String, Object>();
        rs.put("stateRoot", stateRoot);
        rs.put("hasTxbackPackablePool", hasTxbackPackablePool);
        return rs;
    }

    private boolean processContractTxs(Chain chain, String moduleCode, List<String> verifyList, List<TxPackageWrapper> packingTxList, boolean batchVerify) throws NulsException {
        block2: while (true) {
            List<String> txHashList = null;
            try {
                txHashList = TransactionCall.txModuleValidator(chain, moduleCode, verifyList);
            }
            catch (NulsException e) {
                chain.getLogger().error("Package module verify failed -txModuleValidator Exception:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, verifyList.size(), txHashList.size()});
                txHashList = new ArrayList<String>(verifyList.size());
                for (String txStr : verifyList) {
                    Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
                    txHashList.add(tx.getHash().toHex());
                }
            }
            if (txHashList.isEmpty()) {
                return false;
            }
            chain.getLogger().warn("Package module verify failed -txModuleValidator Exception:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, verifyList.size(), txHashList.size()});
            if (batchVerify) {
                return true;
            }
            Iterator<String> it = verifyList.iterator();
            while (it.hasNext()) {
                Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(it.next(), Transaction.class);
                int type = tx.getType();
                for (String hash : txHashList) {
                    if (!hash.equals(tx.getHash().toHex()) || type != 20 && type != 21 && type != 22 && type != 23 && type != 26) continue;
                    return true;
                }
            }
            int i = 0;
            while (true) {
                if (i >= txHashList.size()) continue block2;
                String hash = txHashList.get(i);
                Iterator<TxPackageWrapper> its = packingTxList.iterator();
                while (its.hasNext()) {
                    Transaction tx = its.next().getTx();
                    if (!hash.equals(tx.getHash().toHex())) continue;
                    this.clearInvalidTx(chain, tx);
                    its.remove();
                }
                Iterator<String> itcs = verifyList.iterator();
                while (itcs.hasNext()) {
                    Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(itcs.next(), Transaction.class);
                    if (!hash.equals(tx.getHash().toHex())) continue;
                    itcs.remove();
                }
                ++i;
            }
            break;
        }
    }

    private void addOrphanTxSet(Chain chain, Set<TxPackageWrapper> orphanTxSet, TxPackageWrapper txPackageWrapper) {
        NulsHash hash = txPackageWrapper.getTx().getHash();
        Integer count = chain.getTxPackageOrphanMap().get(hash);
        if (count == null || count < 5) {
            orphanTxSet.add(txPackageWrapper);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            if (chain.getTxPackageOrphanMap().size() > 10000) {
                chain.getTxPackageOrphanMap().clear();
            }
            chain.getTxPackageOrphanMap().put(hash, count);
        } else {
            chain.getLogger().debug("exceed5Secondary Orphan Trading hash:{}", new Object[]{hash.toHex()});
            this.clearInvalidTx(chain, txPackageWrapper.getTx());
            chain.getTxPackageOrphanMap().remove(hash);
        }
    }

    private void putBackPackablePool(Chain chain, List<TxPackageWrapper> txList, Set<TxPackageWrapper> orphanTxSet) {
        if (null == txList) {
            txList = new ArrayList<TxPackageWrapper>();
        }
        if (null != orphanTxSet && !orphanTxSet.isEmpty()) {
            txList.addAll(orphanTxSet);
        }
        if (txList.isEmpty()) {
            return;
        }
        txList.sort(new Comparator<TxPackageWrapper>(){

            @Override
            public int compare(TxPackageWrapper o1, TxPackageWrapper o2) {
                return o1.compareTo(o2.getIndex());
            }
        });
        for (TxPackageWrapper txPackageWrapper : txList) {
            this.packablePool.offerFirstOnlyHash(chain, txPackageWrapper.getTx());
        }
        chain.getLogger().info("putBackPackablePool count:{}", new Object[]{txList.size()});
    }

    private void putBackPackablePool(Chain chain, Set<TxPackageWrapper> orphanTxSet) {
        this.putBackPackablePool(chain, null, orphanTxSet);
    }

    private boolean txModuleValidatorPackable(Chain chain, Map<String, List<String>> moduleVerifyMap, List<TxPackageWrapper> packingTxList, Set<TxPackageWrapper> orphanTxSet) throws NulsException {
        Iterator<Map.Entry<String, List<String>>> it = moduleVerifyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            List<String> moduleList = entry.getValue();
            if (moduleList.size() == 0) {
                it.remove();
                continue;
            }
            String moduleCode = entry.getKey();
            List<String> txHashList = null;
            try {
                txHashList = TransactionCall.txModuleValidator(chain, moduleCode, moduleList);
            }
            catch (NulsException e) {
                chain.getLogger().error("Package module verify failed -txModuleValidator Exception:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, moduleList.size(), txHashList.size()});
                Iterator<TxPackageWrapper> its = packingTxList.iterator();
                while (its.hasNext()) {
                    Transaction tx = its.next().getTx();
                    TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                    if (!txRegister.getModuleCode().equals(moduleCode)) continue;
                    this.clearInvalidTx(chain, tx);
                    its.remove();
                }
                continue;
            }
            if (null == txHashList || txHashList.isEmpty()) {
                it.remove();
                continue;
            }
            chain.getLogger().error("[Package module verify failed] module:{}, module-code:{}, count:{} , return count:{}", new Object[]{"txValidator", moduleCode, moduleList.size(), txHashList.size()});
            for (int i = 0; i < txHashList.size(); ++i) {
                String hash = txHashList.get(i);
                Iterator<TxPackageWrapper> its = packingTxList.iterator();
                while (its.hasNext()) {
                    Transaction tx = its.next().getTx();
                    if (!hash.equals(tx.getHash().toHex())) continue;
                    this.clearInvalidTx(chain, tx);
                    its.remove();
                }
            }
        }
        if (moduleVerifyMap.isEmpty()) {
            return true;
        }
        moduleVerifyMap = new HashMap<String, List<String>>(16);
        this.verifyAgain(chain, moduleVerifyMap, packingTxList, orphanTxSet, false);
        return this.txModuleValidatorPackable(chain, moduleVerifyMap, packingTxList, orphanTxSet);
    }

    private void verifyAgain(Chain chain, Map<String, List<String>> moduleVerifyMap, List<TxPackageWrapper> packingTxList, Set<TxPackageWrapper> orphanTxSet, boolean orphanNoCount) throws NulsException {
        chain.getLogger().debug("------ verifyAgain Batch verification notification for packaging again ------");
        LedgerCall.coinDataBatchNotify(chain);
        ArrayList<String> batchProcessList = new ArrayList<String>();
        for (TxPackageWrapper txPackageWrapper : packingTxList) {
            batchProcessList.add(txPackageWrapper.getTxHex());
        }
        this.verifyLedger(chain, batchProcessList, packingTxList, orphanTxSet, true, orphanNoCount);
        for (TxPackageWrapper txPackageWrapper : packingTxList) {
            Transaction tx = txPackageWrapper.getTx();
            TxUtil.moduleGroups(chain, moduleVerifyMap, tx);
        }
    }

    public void verifySysTxCount(Set<Integer> onlyOneTxTypes, int type) throws NulsException {
        switch (type) {
            case 1: 
            case 7: 
            case 19: {
                if (onlyOneTxTypes.add(type)) break;
                throw new NulsException(TxErrorCode.CONTAINS_MULTIPLE_UNIQUE_TXS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> batchVerify(final Chain chain, List<String> txStrList, BlockHeader blockHeader, String blockHeaderStr, String preStateRoot) throws NulsException {
        final NulsLogger logger = chain.getLogger();
        long s1 = NulsDateUtils.getCurrentTimeMillis();
        long blockHeight = blockHeader.getHeight();
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] start -----height:{} -----Number of block transactions:{}", new Object[]{blockHeight, txStrList.size()});
        }
        ArrayList<TxVerifyWrapper> txList = new ArrayList<TxVerifyWrapper>();
        HashSet<Integer> onlyOneTxTypes = new HashSet<Integer>();
        boolean contractNotify = false;
        Transaction scReturnGas = null;
        long blockTime = blockHeader.getTime();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
        int chainId = chain.getChainId();
        long timeF1 = 0L;
        long timeF2 = 0L;
        long timeF3 = 0L;
        long timeF4 = 0L;
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        long f1 = System.currentTimeMillis();
        for (String txStr : txStrList) {
            Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
            txList.add(new TxVerifyWrapper(tx, txStr));
            int type = tx.getType();
            this.verifySysTxCount(onlyOneTxTypes, type);
            TxRegister txRegister = TxManager.getTxRegister(chain, type);
            if (null == txRegister) {
                throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
            }
            if (type == 19) {
                scReturnGas = tx;
            }
            boolean isSmartContractTx = TxManager.isUnSystemSmartContract(txRegister);
            if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_V250) {
                boolean isCrossTransferTx;
                boolean bl = isCrossTransferTx = 10 == type;
                if (!isSmartContractTx && this.txConfig.isCollectedSmartContractModule()) {
                    isSmartContractTx = isCrossTransferTx;
                }
            }
            if (isSmartContractTx) {
                if (!contractNotify) {
                    String packingAddress = AddressTool.getStringAddressByBytes((byte[])blockHeader.getPackingAddress(chain.getChainId()));
                    ContractCall.contractBatchBegin(chain, blockHeight, blockTime, packingAddress, preStateRoot, 1);
                    contractNotify = true;
                }
                try {
                    if (!ContractCall.invokeContract(chain, RPCUtil.encode((byte[])tx.serialize()), 1, 100000L)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("batch verify failed. invokeContract fail");
                        }
                        throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                    }
                }
                catch (IOException e) {
                    throw new NulsException(TxErrorCode.SERIALIZE_ERROR);
                }
            }
            if (chain.getContractGenerateTxTypes().contains(tx.getType())) {
                throw new NulsException(TxErrorCode.SYS_CONTRACT_TX_NON_CIRCULATING);
            }
            keys.add(tx.getHash().getBytes());
            TxUtil.moduleGroups(moduleVerifyMap, txRegister, txStr);
        }
        if (!contractNotify && null != scReturnGas) {
            throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
        }
        onlyOneTxTypes = null;
        long f2 = System.currentTimeMillis();
        timeF1 = f2 - f1;
        List<byte[]> confirmedList = this.confirmedTxStorageService.getExistTxs(chainId, keys);
        if (!confirmedList.isEmpty()) {
            logger.error("There are confirmed transactions");
            try {
                for (byte[] cfmtx : confirmedList) {
                    logger.error("confirmed hash:{}", new Object[]{TxUtil.getTransaction(cfmtx).getHash().toHex()});
                }
            }
            finally {
                logger.error("Show confirmed transaction deserialize fail");
                throw new NulsException(TxErrorCode.TX_CONFIRMED);
            }
        }
        long f3 = System.currentTimeMillis();
        timeF2 = f3 - f2;
        List<String> unconfirmedList = this.unconfirmedTxStorageService.getExistKeysStr(chainId, keys);
        long f4 = System.currentTimeMillis();
        timeF3 = f4 - f3;
        HashSet<String> set = new HashSet<String>();
        set.addAll(unconfirmedList);
        unconfirmedList = null;
        long d = 0L;
        for (TxVerifyWrapper txVerifyWrapper : txList) {
            final Transaction tx = txVerifyWrapper.getTx();
            tx.setBlockHeight(blockHeight);
            if (!set.add(tx.getHash().toHex())) continue;
            long d1 = System.currentTimeMillis();
            Future<Boolean> res = this.verifySignExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                        if (null == txRegister) {
                            throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
                        }
                        TxServiceImpl.this.baseValidateTx(chain, tx, txRegister);
                    }
                    catch (Exception e) {
                        logger.error("batchVerify failed, single tx verify failed. hash:{}, -type:{}", new Object[]{tx.getHash().toHex(), tx.getType()});
                        logger.error(e);
                        return false;
                    }
                    return true;
                }
            });
            futures.add(res);
            d += System.currentTimeMillis() - d1;
        }
        if (logger.isDebugEnabled()) {
            timeF4 = System.currentTimeMillis() - f4;
            logger.debug("[Verify block transactions] Deserialization,contract,grouping:{} -Have you confirmed:{} -Is it in unconfirmed status:{}, -Single validation:{} -Single internal processing:{} -Total time:{}", new Object[]{timeF1, timeF2, timeF3, d, timeF4, NulsDateUtils.getCurrentTimeMillis() - s1});
        }
        if (contractNotify && !ContractCall.contractBatchBeforeEnd(chain, blockHeight, 1)) {
            if (logger.isDebugEnabled()) {
                logger.debug("batch verify failed. contractBatchBeforeEnd fail");
            }
            throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
        }
        long coinDataV = NulsDateUtils.getCurrentTimeMillis();
        if (!LedgerCall.verifyBlockTxsCoinData(chain, txStrList, blockHeight)) {
            if (logger.isDebugEnabled()) {
                logger.debug("batch verifyCoinData failed.");
            }
            throw new NulsException(TxErrorCode.TX_LEDGER_VERIFY_FAIL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] coinData -Time from the start of the method:{},-Verification time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1, NulsDateUtils.getCurrentTimeMillis() - coinDataV});
        }
        long moduleV = NulsDateUtils.getCurrentTimeMillis();
        for (Map.Entry entry : moduleVerifyMap.entrySet()) {
            List<String> txHashList = TransactionCall.txModuleValidator(chain, (String)entry.getKey(), (List)entry.getValue(), blockHeaderStr);
            if (txHashList == null || txHashList.size() <= 0) continue;
            logger.error("batch module verify fail, module-code:{},  return count:{}", new Object[]{entry.getKey(), txHashList.size()});
            throw new NulsException(TxErrorCode.TX_VERIFY_FAIL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] Module Unified Verification Time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - moduleV});
            logger.debug("[Verify block transactions] Unified module verification -Time from the start of the method:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1});
        }
        List scNewList = new ArrayList();
        String scStateRoot = preStateRoot;
        if (contractNotify) {
            int size;
            Map<String, Object> map;
            try {
                map = ContractCall.contractBatchEnd(chain, blockHeight, 100000L);
            }
            catch (NulsException e) {
                logger.error(e);
                throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
            }
            scStateRoot = (String)map.get("stateRoot");
            scNewList = (List)map.get("txList");
            if (null == scNewList) {
                logger.error("contract new txs is null");
                throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
            }
            ArrayList scNewConsensusList = new ArrayList();
            ArrayList<String> scNewTokenCrossTransferList = new ArrayList<String>();
            for (String string : scNewList) {
                int scNewTxType = TxUtil.extractTxTypeFromTx(string);
                if (scNewTxType == 20 || scNewTxType == 21 || scNewTxType == 22 || scNewTxType == 23) {
                    scNewConsensusList.add(string);
                    continue;
                }
                if (scNewTxType != 26) continue;
                scNewTokenCrossTransferList.add(string);
            }
            if (!scNewConsensusList.isEmpty() || !scNewTokenCrossTransferList.isEmpty()) {
                boolean rsProcess;
                ArrayList<String> consensusList = new ArrayList<String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (TxVerifyWrapper txVerifyWrapper : txList) {
                    Transaction tx = txVerifyWrapper.getTx();
                    int txType = tx.getType();
                    if (txType == 20 || txType == 21 || txType == 22 || txType == 23) continue;
                    if (ModuleE.CS.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
                        consensusList.add(txVerifyWrapper.getTxStr());
                    }
                    if (!ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) continue;
                    arrayList.add(txVerifyWrapper.getTxStr());
                }
                consensusList.addAll(scNewConsensusList);
                arrayList.addAll(scNewTokenCrossTransferList);
                if (!consensusList.isEmpty() && (rsProcess = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CS.abbr), consensusList, null, true))) {
                    logger.error("contract tx consensus module verify fail.");
                    throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                }
                if (!arrayList.isEmpty() && (rsProcess = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CC.abbr), arrayList, null, true))) {
                    logger.error("contract tx cross-chain module verify fail.");
                    throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                }
            }
            if ((size = scNewList.size()) > 0) {
                int n = txStrList.size();
                String scNewTxHex = null;
                for (int i = size - 1; i >= 0; --i) {
                    String hex = (String)scNewList.get(i);
                    int txType = TxUtil.extractTxTypeFromTx(hex);
                    if (txType != 19) continue;
                    scNewTxHex = hex;
                    break;
                }
                if (scNewTxHex != null) {
                    String receivedScNewTxHex = null;
                    boolean rs = false;
                    for (int i = n - 1; i >= 0; --i) {
                        String txHex = txStrList.get(i);
                        int txType = TxUtil.extractTxTypeFromTx(txHex);
                        if (txType != 19) continue;
                        receivedScNewTxHex = txHex;
                        if (!txHex.equals(scNewTxHex)) break;
                        rs = true;
                        break;
                    }
                    if (!rs) {
                        logger.error("contract error.Contract generatedgasReturn transaction:{}, - Received contractgasReturn transaction\uff1a{}", new Object[]{scNewTxHex, receivedScNewTxHex});
                        throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                    }
                    scNewList.remove(scNewTxHex);
                } else if (null != scReturnGas) {
                    throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
                }
            } else if (null != scReturnGas) {
                throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
            }
        }
        String coinBaseTx = null;
        for (TxVerifyWrapper txVerifyWrapper : txList) {
            Transaction tx = txVerifyWrapper.getTx();
            if (tx.getType() != 1) continue;
            coinBaseTx = txVerifyWrapper.getTxStr();
            break;
        }
        String stateRootNew = ConsensusCall.triggerCoinBaseContract(chain, coinBaseTx, blockHeaderStr, scStateRoot);
        String stateRoot = RPCUtil.encode((byte[])blockHeader.getExtendsData().getStateRoot());
        if (!stateRoot.equals(stateRootNew)) {
            logger.warn("contract stateRoot error.");
            throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
        }
        try {
            for (Future future : futures) {
                if (((Boolean)future.get()).booleanValue()) continue;
                logger.error("batchVerify failed, single tx verify failed");
                throw new NulsException(TxErrorCode.TX_VERIFY_FAIL);
            }
        }
        catch (InterruptedException e) {
            logger.error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        catch (ExecutionException e) {
            logger.error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] Total execution time:{}, - height:{} - Number of block transactions:{}" + TxUtil.nextLine(), new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1, blockHeight, txStrList.size()});
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("value", true);
        resultMap.put("contractList", scNewList);
        return resultMap;
    }

    @Override
    public void clearInvalidTx(Chain chain, Transaction tx) {
        this.clearInvalidTx(chain, tx, true);
    }

    @Override
    public void clearInvalidTx(Chain chain, Transaction tx, boolean changeStatus) {
        this.unconfirmedTxStorageService.removeTx(chain.getChainId(), tx.getHash());
        ByteArrayWrapper wrapper = new ByteArrayWrapper(tx.getHash().getBytes());
        chain.getPackableTxMap().remove(wrapper);
        this.packablePool.removeInvalidTxFromMap(chain, tx);
        TransactionConfirmedPO txConfirmed = this.confirmedTxService.getConfirmedTransaction(chain, tx.getHash());
        if (txConfirmed == null) {
            try {
                LedgerCall.rollBackUnconfirmTx(chain, RPCUtil.encode((byte[])tx.serialize()));
                if (changeStatus) {
                    LedgerCall.rollbackTxValidateStatus(chain, RPCUtil.encode((byte[])tx.serialize()));
                }
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
            }
            catch (Exception e) {
                chain.getLogger().error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxPackage getPackableTxsV8(Chain chain, long endtimestamp, long maxTxDataSize, long blockTime, String packingAddress, String preStateRoot) {
        chain.getPackageLock().lock();
        long startTime = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<TxPackageWrapper> packingTxList = new ArrayList<TxPackageWrapper>();
        HashSet<TxPackageWrapper> orphanTxSet = new HashSet<TxPackageWrapper>();
        NulsLogger nulsLogger = chain.getLogger();
        try {
            String csTxStr;
            TxPackageWrapper txPackageWrapper;
            long blockHeight = chain.getBestBlockHeight() + 1L;
            long packableTime = endtimestamp - startTime;
            nulsLogger.info("[Package start] -Packaging time\uff1a{}, -Packable capacity\uff1a{}B , - height:{}, - Current queue transactions to be packagedhashnumber:{}, - Actual number of transactions in the queue to be packaged:{}", new Object[]{packableTime, maxTxDataSize, blockHeight, this.packablePool.packableHashQueueSize(chain), this.packablePool.packableTxMapSize(chain)});
            long batchValidReserve = 2000L;
            if (packableTime <= batchValidReserve) {
                TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                return txPackage;
            }
            chain.setContractTxFail(false);
            HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
            long packingTime = endtimestamp - startTime;
            int allSleepTime = 0;
            long totalLedgerTime = 0L;
            long totalSize = 0L;
            long totalSizeTemp = 0L;
            int maxCount = 8000;
            long packageRpcReserveTime = chain.getConfig().getPackageRpcReserveTime();
            boolean contractNotify = false;
            LedgerCall.coinDataBatchNotify(chain);
            ArrayList<String> batchProcessList = new ArrayList<String>();
            HashSet<String> duplicatesVerify = new HashSet<String>();
            ArrayList<TxPackageWrapper> currentBatchPackableTxs = new ArrayList<TxPackageWrapper>();
            int corssTxCount = 0;
            int batchCorssTxCount = 0;
            int contractTxCount = 0;
            int batchContractTxCount = 0;
            boolean stopInvokeContract = false;
            int packageContractTxMaxCount = 300;
            long totalGasInBlock = 0L;
            ArrayList<String> contractGenerateTxs = new ArrayList<String>();
            ArrayList<String> originTxList = new ArrayList<String>();
            int index = 0;
            while (true) {
                block60: {
                    long verifyLedgerStart;
                    boolean maxDataSize;
                    Transaction tx;
                    block61: {
                        long currentTimeMillis;
                        long currentReserve;
                        if ((currentReserve = endtimestamp - (currentTimeMillis = NulsDateUtils.getCurrentTimeMillis())) <= batchValidReserve) {
                            if (nulsLogger.isDebugEnabled()) {
                                nulsLogger.debug("Get transaction time up to,Entering the module validation phase: currentTimeMillis:{}, -endtimestamp:{}, -offset:{}, -remaining:{}", new Object[]{currentTimeMillis, endtimestamp, batchValidReserve, currentReserve});
                            }
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            break;
                        }
                        if (currentReserve < packageRpcReserveTime) {
                            nulsLogger.error("getPackableTxs time out, endtimestamp:{}, current:{}, endtimestamp-current:{}, reserveTime:{}", new Object[]{endtimestamp, currentTimeMillis, currentReserve, packageRpcReserveTime});
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            throw new NulsException(TxErrorCode.PACKAGE_TIME_OUT);
                        }
                        if (chain.getProtocolUpgrade().get()) {
                            chain.getCanProtocolUpgrade().set(false);
                            nulsLogger.info("3_chain.getCanProtocolUpgrade().set(false);");
                            nulsLogger.info("Protocol Upgrade Package stop -chain:{} -best block height", new Object[]{chain.getChainId(), chain.getBestBlockHeight()});
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                            TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                            chain.getCanProtocolUpgrade().set(true);
                            nulsLogger.info("3_chain.getCanProtocolUpgrade().set(true);");
                            TxPackage txPackage2 = txPackage;
                            return txPackage2;
                        }
                        if (blockHeight < chain.getBestBlockHeight() + 1L) {
                            nulsLogger.info("Obtaining the latest block height during the transaction process has increased,Put the retrieved transactions and orphans back into the packaging queue, Repackaging...");
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                            TxPackage txPackage = this.getPackableTxsV8(chain, endtimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot);
                            return txPackage;
                        }
                        if (packingTxList.size() > maxCount) {
                            if (nulsLogger.isDebugEnabled()) {
                                nulsLogger.debug("Obtaining transaction completedmax count,Entering the module validation phase: currentTimeMillis:{}, -endtimestamp:{}, -offset:{}, -remaining:{}", new Object[]{currentTimeMillis, endtimestamp, batchValidReserve, endtimestamp - currentTimeMillis});
                            }
                            this.backTempPackablePool(chain, currentBatchPackableTxs);
                            break;
                        }
                        int batchProcessListSize = batchProcessList.size();
                        boolean process = false;
                        tx = null;
                        maxDataSize = false;
                        tx = this.packablePool.poll(chain);
                        if (tx == null && batchProcessListSize == 0) {
                            Thread.sleep(10L);
                            allSleepTime += 10;
                            break block60;
                        }
                        if (tx == null && batchProcessListSize > 0) {
                            process = true;
                        } else if (tx != null) {
                            if (!duplicatesVerify.add(tx.getHash().toHex())) break block60;
                            long txSize = tx.size();
                            if (totalSizeTemp + txSize > maxTxDataSize) {
                                this.packablePool.offerFirstOnlyHash(chain, tx);
                                nulsLogger.info("The transaction has reached its maximum capacity, actual value: {}, totalSizeTemp:{}, Current transactionsize\uff1a{} - Reserve maximum valuemaxTxDataSize:{}, txhash:{}", new Object[]{totalSize, totalSizeTemp, txSize, maxTxDataSize, tx.getHash().toHex()});
                                maxDataSize = true;
                                if (batchProcessListSize <= 0) break;
                                process = true;
                            } else {
                                String txHex;
                                boolean isContract;
                                if (ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType())) && corssTxCount + ++batchCorssTxCount >= 500) {
                                    this.packablePool.add(chain, tx);
                                    if (batchProcessListSize <= 0) break;
                                    process = true;
                                }
                                if ((isContract = ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) && contractTxCount + ++batchContractTxCount >= packageContractTxMaxCount) {
                                    this.packablePool.add(chain, tx);
                                    if (batchProcessListSize <= 0) break;
                                    process = true;
                                }
                                try {
                                    txHex = RPCUtil.encode((byte[])tx.serialize());
                                }
                                catch (Exception e) {
                                    nulsLogger.warn(e.getMessage(), (Throwable)e);
                                    nulsLogger.error("Discard acquisitionhexWrong transaction, txHash:{}, - type:{}, - time:{}", new Object[]{tx.getHash().toHex(), tx.getType(), tx.getTime()});
                                    this.clearInvalidTx(chain, tx);
                                    break block60;
                                }
                                TxPackageWrapper txPackageWrapper2 = new TxPackageWrapper(tx, index, txHex);
                                batchProcessList.add(txHex);
                                currentBatchPackableTxs.add(txPackageWrapper2);
                                if (batchProcessList.size() == 2000) {
                                    process = true;
                                }
                            }
                            totalSizeTemp += txSize;
                        }
                        if (!process) break block60;
                        verifyLedgerStart = NulsDateUtils.getCurrentTimeMillis();
                        if (chain.getPackableState().get()) break block61;
                        nulsLogger.info("Saving or rolling back blocks during the transaction process triggers ledger submission or rollback, Repackaging...");
                        packingTxList.addAll(currentBatchPackableTxs);
                        this.putBackPackablePool(chain, packingTxList, orphanTxSet);
                        Thread.sleep(30L);
                        TxPackage isContract = this.getPackableTxsV8(chain, endtimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot);
                        return isContract;
                    }
                    try {
                        this.verifyLedger(chain, batchProcessList, currentBatchPackableTxs, orphanTxSet, false, false);
                        totalLedgerTime += NulsDateUtils.getCurrentTimeMillis() - verifyLedgerStart;
                        Iterator it = currentBatchPackableTxs.iterator();
                        while (it.hasNext()) {
                            boolean isCrossTx;
                            boolean isSmartContractTx;
                            TxRegister txRegister;
                            Transaction transaction;
                            block62: {
                                txPackageWrapper = (TxPackageWrapper)it.next();
                                transaction = txPackageWrapper.getTx();
                                txRegister = TxManager.getTxRegister(chain, transaction.getType());
                                isSmartContractTx = ModuleE.SC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(transaction.getType()));
                                isCrossTx = ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(transaction.getType()));
                                if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_V250) {
                                    boolean isCrossTransferTx;
                                    boolean bl = isCrossTransferTx = 10 == transaction.getType();
                                    if (!isSmartContractTx && this.txConfig.isCollectedSmartContractModule()) {
                                        isSmartContractTx = isCrossTransferTx;
                                    }
                                }
                                if (isSmartContractTx) {
                                    if (stopInvokeContract) {
                                        orphanTxSet.add(txPackageWrapper);
                                        it.remove();
                                        continue;
                                    }
                                    if (!contractNotify) {
                                        ContractCall.contractBatchBegin(chain, blockHeight, blockTime, packingAddress, preStateRoot, 0);
                                        contractNotify = true;
                                    }
                                    try {
                                        Map<String, Object> invokeContractRs = ContractCall.invokeContractV8(chain, txPackageWrapper.getTxHex(), 0);
                                        long gasUsed = Long.valueOf(invokeContractRs.get("gasUsed").toString());
                                        List txList = (List)invokeContractRs.get("txList");
                                        totalGasInBlock += gasUsed;
                                        if (txList != null && !txList.isEmpty()) {
                                            contractGenerateTxs.addAll(txList);
                                            String txHash = transaction.getHash().toString();
                                            int size = txList.size();
                                            for (int i = 0; i < size; ++i) {
                                                originTxList.add(txHash);
                                            }
                                        }
                                        if (totalGasInBlock >= this.MAX_GAS_COST_IN_BLOCK) {
                                            stopInvokeContract = true;
                                        }
                                        break block62;
                                    }
                                    catch (NulsException e) {
                                        chain.getLogger().error(e);
                                        this.clearInvalidTx(chain, transaction);
                                    }
                                    continue;
                                }
                            }
                            totalSize += (long)transaction.getSize();
                            if (isCrossTx) {
                                ++corssTxCount;
                            }
                            if (isSmartContractTx) {
                                ++contractTxCount;
                            }
                            TxUtil.moduleGroups(moduleVerifyMap, txRegister, RPCUtil.encode((byte[])transaction.serialize()));
                            long _currentTimeMillis = NulsDateUtils.getCurrentTimeMillis();
                            long _currentReserve = endtimestamp - _currentTimeMillis;
                            if (_currentReserve > batchValidReserve) continue;
                            nulsLogger.info("Package transaction time is up,Entering the module validation phase: currentTimeMillis:{}, -endtimestamp:{}, -offset:{}, -remaining:{}", new Object[]{_currentTimeMillis, endtimestamp, batchValidReserve, _currentReserve});
                            stopInvokeContract = true;
                        }
                        totalSizeTemp = totalSize;
                        packingTxList.addAll(currentBatchPackableTxs);
                        batchProcessList.clear();
                        currentBatchPackableTxs.clear();
                        batchCorssTxCount = 0;
                        batchContractTxCount = 0;
                        if (maxDataSize) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        currentBatchPackableTxs.clear();
                        nulsLogger.error("Packaging transaction exception, txHash:{}, - type:{}, - time:{}", new Object[]{tx.getHash().toHex(), tx.getType(), tx.getTime()});
                        nulsLogger.error(e);
                    }
                }
                ++index;
            }
            long whileTime = NulsDateUtils.getCurrentTimeMillis() - startTime;
            nulsLogger.info("-Retrieved transactions -count:{} - data size:{}", new Object[]{packingTxList.size(), totalSize});
            boolean contractBefore = false;
            if (contractNotify) {
                contractBefore = ContractCall.contractBatchBeforeEnd(chain, blockHeight, 0);
            }
            String stateRoot = preStateRoot;
            boolean hasTxbackPackablePool = false;
            long contractStart = NulsDateUtils.getCurrentTimeMillis();
            if (contractNotify && !chain.getContractTxFail()) {
                Map map = this.processContractResultV8(chain, packingTxList, orphanTxSet, contractGenerateTxs, originTxList, blockHeight, contractBefore, stateRoot);
                stateRoot = (String)map.get("stateRoot");
                hasTxbackPackablePool = (Boolean)map.get("hasTxbackPackablePool");
            }
            if (stopInvokeContract || hasTxbackPackablePool) {
                moduleVerifyMap = new HashMap(16);
                this.verifyAgain(chain, moduleVerifyMap, packingTxList, orphanTxSet, true);
            }
            long contractTime = NulsDateUtils.getCurrentTimeMillis() - contractStart;
            long batchStart = NulsDateUtils.getCurrentTimeMillis();
            this.txModuleValidatorPackable(chain, moduleVerifyMap, packingTxList, orphanTxSet);
            long batchModuleTime = NulsDateUtils.getCurrentTimeMillis() - batchStart;
            ArrayList<String> packableTxs = new ArrayList<String>();
            Iterator iterator = packingTxList.iterator();
            Map<NulsHash, Integer> txPackageOrphanMap = chain.getTxPackageOrphanMap();
            while (iterator.hasNext()) {
                txPackageWrapper = (TxPackageWrapper)iterator.next();
                Transaction tx = txPackageWrapper.getTx();
                NulsHash hash = tx.getHash();
                if (txPackageOrphanMap.containsKey(hash)) {
                    txPackageOrphanMap.remove(hash);
                }
                try {
                    packableTxs.add(RPCUtil.encode((byte[])tx.serialize()));
                }
                catch (Exception e) {
                    this.clearInvalidTx(chain, tx);
                    iterator.remove();
                    throw new NulsException((Throwable)e);
                }
            }
            if (!hasTxbackPackablePool && contractGenerateTxs.size() > 0 && TxUtil.extractTxTypeFromTx(csTxStr = (String)contractGenerateTxs.get(contractGenerateTxs.size() - 1)) == 19) {
                packableTxs.add(csTxStr);
            }
            if (blockHeight < chain.getBestBlockHeight() + 1L) {
                nulsLogger.info("Obtain transaction completion time,The current latest height has increased,Not enough time to repackage,Directly timeout exception handling transaction rollback to the queue to be packaged,Empty block");
                throw new NulsException(TxErrorCode.HEIGHT_UPDATE_UNABLE_TO_REPACKAGE);
            }
            this.putBackPackablePool(chain, orphanTxSet);
            if (chain.getProtocolUpgrade().get()) {
                Object txPackageWrapper3;
                chain.getCanProtocolUpgrade().set(false);
                nulsLogger.info("4_chain.getCanProtocolUpgrade().set(false);");
                int size = packingTxList.size();
                for (int i = size - 1; i >= 0; --i) {
                    txPackageWrapper3 = (TxPackageWrapper)packingTxList.get(i);
                    Transaction tx = ((TxPackageWrapper)txPackageWrapper3).getTx();
                    TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                    if (null == txRegister) {
                        throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
                    }
                    this.baseValidateTx(chain, tx, txRegister);
                    chain.getUnverifiedQueue().addLast(new TransactionNetPO(((TxPackageWrapper)txPackageWrapper3).getTx()));
                }
                TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
                chain.getCanProtocolUpgrade().set(true);
                nulsLogger.info("4_chain.getCanProtocolUpgrade().set(true);");
                txPackageWrapper3 = txPackage;
                return txPackageWrapper3;
            }
            long current = NulsDateUtils.getCurrentTimeMillis();
            if (endtimestamp - current < packageRpcReserveTime) {
                nulsLogger.error("getPackableTxs time out, endtimestamp:{}, current:{}, endtimestamp-current:{}, reserveTime:{}", new Object[]{endtimestamp, current, endtimestamp - current, packageRpcReserveTime});
                throw new NulsException(TxErrorCode.PACKAGE_TIME_OUT);
            }
            TxPackage txPackage = new TxPackage(packableTxs, stateRoot, blockHeight);
            long totalTime = NulsDateUtils.getCurrentTimeMillis() - startTime;
            nulsLogger.info("[Packaging time statistics]  Total execution time:{}, Remaining time:{}, Packaging available time:{}, Obtain transactions(loop)Total waiting time:{}, Obtain transactions(loop)execution time:{}, Obtain transactions(loop)Total time for verifying ledger:{}, Module unified verification execution time:{}, Contract execution time:{},", new Object[]{totalTime, endtimestamp - NulsDateUtils.getCurrentTimeMillis(), packingTime, allSleepTime, whileTime, totalLedgerTime, batchModuleTime, contractTime});
            nulsLogger.info("[Package end] - height:{} - The number of packaged transactions this time:{} - Current queue transactions to be packagedhashnumber:{}, - Actual number of transactions in the queue to be packaged:{}" + TxUtil.nextLine(), new Object[]{blockHeight, packableTxs.size(), this.packablePool.packableHashQueueSize(chain), this.packablePool.packableTxMapSize(chain)});
            TxPackage txPackage3 = txPackage;
            return txPackage3;
        }
        catch (Exception e) {
            nulsLogger.error(e);
            this.putBackPackablePool(chain, packingTxList, orphanTxSet);
            TxPackage txPackage = new TxPackage(new ArrayList<String>(), null, chain.getBestBlockHeight() + 1L);
            return txPackage;
        }
        finally {
            chain.getPackageLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> batchVerifyV8(final Chain chain, List<String> txStrList, BlockHeader blockHeader, String blockHeaderStr, String preStateRoot) throws NulsException {
        final NulsLogger logger = chain.getLogger();
        long s1 = NulsDateUtils.getCurrentTimeMillis();
        long blockHeight = blockHeader.getHeight();
        logger.info("[Verify block transactions] start -----height:{} -----Number of block transactions:{}", new Object[]{blockHeight, txStrList.size()});
        ArrayList<TxVerifyWrapper> txList = new ArrayList<TxVerifyWrapper>();
        HashSet<Integer> onlyOneTxTypes = new HashSet<Integer>();
        boolean contractNotify = false;
        Transaction scReturnGas = null;
        long blockTime = blockHeader.getTime();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        HashMap<String, List<String>> moduleVerifyMap = new HashMap<String, List<String>>(8);
        int chainId = chain.getChainId();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        long f1 = System.currentTimeMillis();
        long totalGasInBlock = 0L;
        ArrayList contractGenerateTxs = new ArrayList();
        for (String txStr : txStrList) {
            Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
            txList.add(new TxVerifyWrapper(tx, txStr));
            int type = tx.getType();
            this.verifySysTxCount(onlyOneTxTypes, type);
            TxRegister txRegister = TxManager.getTxRegister(chain, type);
            if (null == txRegister) {
                throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
            }
            if (type == 19) {
                scReturnGas = tx;
            }
            boolean isSmartContractTx = TxManager.isUnSystemSmartContract(txRegister);
            if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_V250) {
                boolean isCrossTransferTx;
                boolean bl = isCrossTransferTx = 10 == type;
                if (!isSmartContractTx && this.txConfig.isCollectedSmartContractModule()) {
                    isSmartContractTx = isCrossTransferTx;
                }
            }
            if (isSmartContractTx) {
                if (totalGasInBlock >= this.MAX_GAS_COST_IN_BLOCK && TxManager.isGasCostContractTransaction(type)) {
                    Log.error((String)"verify block failed: Excess block gas limit of contract transaction detected.");
                    throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                }
                if (!contractNotify) {
                    String packingAddress = AddressTool.getStringAddressByBytes((byte[])blockHeader.getPackingAddress(chain.getChainId()));
                    ContractCall.contractBatchBegin(chain, blockHeight, blockTime, packingAddress, preStateRoot, 1);
                    contractNotify = true;
                }
                try {
                    Map<String, Object> invokeContractRs = ContractCall.invokeContractV8(chain, RPCUtil.encode((byte[])tx.serialize()), 1, 200000L);
                    long gasUsed = Long.valueOf(invokeContractRs.get("gasUsed").toString());
                    List contractTxList = (List)invokeContractRs.get("txList");
                    totalGasInBlock += gasUsed;
                    if (contractTxList != null && !contractTxList.isEmpty()) {
                        contractGenerateTxs.addAll(contractTxList);
                    }
                }
                catch (IOException e) {
                    throw new NulsException(TxErrorCode.SERIALIZE_ERROR);
                }
            }
            if (chain.getContractGenerateTxTypes().contains(tx.getType())) {
                throw new NulsException(TxErrorCode.SYS_CONTRACT_TX_NON_CIRCULATING);
            }
            keys.add(tx.getHash().getBytes());
            TxUtil.moduleGroups(moduleVerifyMap, txRegister, txStr);
        }
        if (!contractNotify && null != scReturnGas) {
            throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
        }
        long f2 = System.currentTimeMillis();
        long timeF1 = f2 - f1;
        List<byte[]> confirmedList = this.confirmedTxStorageService.getExistTxs(chainId, keys);
        if (!confirmedList.isEmpty()) {
            logger.error("There are confirmed transactions");
            try {
                for (byte[] cfmtx : confirmedList) {
                    logger.error("confirmed hash:{}", new Object[]{TxUtil.getTransaction(cfmtx).getHash().toHex()});
                }
            }
            finally {
                logger.error("Show confirmed transaction deserialize fail");
                throw new NulsException(TxErrorCode.TX_CONFIRMED);
            }
        }
        long f3 = System.currentTimeMillis();
        long timeF2 = f3 - f2;
        List<String> unconfirmedList = this.unconfirmedTxStorageService.getExistKeysStr(chainId, keys);
        long f4 = System.currentTimeMillis();
        long timeF3 = f4 - f3;
        HashSet<String> set = new HashSet<String>();
        set.addAll(unconfirmedList);
        long d = 0L;
        for (TxVerifyWrapper txVerifyWrapper : txList) {
            final Transaction tx = txVerifyWrapper.getTx();
            tx.setBlockHeight(blockHeight);
            if (!set.add(tx.getHash().toHex())) continue;
            long d1 = System.currentTimeMillis();
            Future<Boolean> res = this.verifySignExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
                        if (null == txRegister) {
                            throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
                        }
                        TxServiceImpl.this.baseValidateTx(chain, tx, txRegister);
                    }
                    catch (Exception e) {
                        logger.error("batchVerify failed, single tx verify failed. hash:{}, -type:{}", new Object[]{tx.getHash().toHex(), tx.getType()});
                        logger.error(e);
                        return false;
                    }
                    return true;
                }
            });
            futures.add(res);
            d += System.currentTimeMillis() - d1;
        }
        long timeF4 = System.currentTimeMillis() - f4;
        logger.info("[Verify block transactions] Deserialization,contract,grouping:{} -Have you confirmed:{} -Is it in unconfirmed status:{}, -Single validation:{} -Single internal processing:{} -Total time:{}", new Object[]{timeF1, timeF2, timeF3, d, timeF4, NulsDateUtils.getCurrentTimeMillis() - s1});
        if (contractNotify) {
            ContractCall.contractBatchBeforeEnd(chain, blockHeight, 1);
        }
        long coinDataV = NulsDateUtils.getCurrentTimeMillis();
        if (!LedgerCall.verifyBlockTxsCoinData(chain, txStrList, blockHeight)) {
            if (logger.isDebugEnabled()) {
                logger.debug("batch verifyCoinData failed.");
            }
            throw new NulsException(TxErrorCode.TX_LEDGER_VERIFY_FAIL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] coinData -Time from the start of the method:{},-Verification time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1, NulsDateUtils.getCurrentTimeMillis() - coinDataV});
        }
        long moduleV = NulsDateUtils.getCurrentTimeMillis();
        for (Map.Entry entry : moduleVerifyMap.entrySet()) {
            List<String> txHashList = TransactionCall.txModuleValidator(chain, (String)entry.getKey(), (List)entry.getValue(), blockHeaderStr);
            if (txHashList == null || txHashList.size() <= 0) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("batch module verify fail, module-code:{},  return count:{}", new Object[]{entry.getKey(), txHashList.size()});
            }
            throw new NulsException(TxErrorCode.TX_VERIFY_FAIL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] Module Unified Verification Time:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - moduleV});
            logger.debug("[Verify block transactions] Unified module verification -Time from the start of the method:{}", new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1});
        }
        String scStateRoot = preStateRoot;
        if (contractNotify) {
            int n;
            Map<String, Object> map;
            try {
                map = ContractCall.contractBatchEnd(chain, blockHeight, 200000L);
            }
            catch (NulsException e) {
                logger.error(e);
                throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
            }
            scStateRoot = (String)map.get("stateRoot");
            List returnGasTx = (List)map.get("txList");
            contractGenerateTxs.addAll(returnGasTx);
            ArrayList<String> scNewConsensusList = new ArrayList<String>();
            ArrayList<String> scNewTokenCrossTransferList = new ArrayList<String>();
            for (String scNewTx : contractGenerateTxs) {
                int scNewTxType = TxUtil.extractTxTypeFromTx(scNewTx);
                if (scNewTxType == 20 || scNewTxType == 21 || scNewTxType == 22 || scNewTxType == 23) {
                    scNewConsensusList.add(scNewTx);
                    continue;
                }
                if (scNewTxType != 26) continue;
                scNewTokenCrossTransferList.add(scNewTx);
            }
            if (!scNewConsensusList.isEmpty() || !scNewTokenCrossTransferList.isEmpty()) {
                boolean rsProcess;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> crossTransferList = new ArrayList<String>();
                for (TxVerifyWrapper txVerifyWrapper : txList) {
                    Transaction tx = txVerifyWrapper.getTx();
                    int txType = tx.getType();
                    if (txType == 20 || txType == 21 || txType == 22 || txType == 23) continue;
                    if (ModuleE.CS.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
                        arrayList.add(txVerifyWrapper.getTxStr());
                    }
                    if (!ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) continue;
                    crossTransferList.add(txVerifyWrapper.getTxStr());
                }
                arrayList.addAll(scNewConsensusList);
                crossTransferList.addAll(scNewTokenCrossTransferList);
                if (!arrayList.isEmpty() && (rsProcess = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CS.abbr), arrayList, null, true))) {
                    logger.error("contract tx consensus module verify fail.");
                    throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                }
                if (!crossTransferList.isEmpty() && (rsProcess = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CC.abbr), crossTransferList, null, true))) {
                    logger.error("contract tx cross-chain module verify fail.");
                    throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                }
            }
            if ((n = contractGenerateTxs.size()) > 0) {
                int txSize = txStrList.size();
                String scNewTxHex = null;
                int returnGasIndex = -1;
                for (int i = n - 1; i >= 0; --i) {
                    String hex = (String)contractGenerateTxs.get(i);
                    int txType = TxUtil.extractTxTypeFromTx(hex);
                    if (txType != 19) continue;
                    scNewTxHex = hex;
                    returnGasIndex = i;
                    break;
                }
                if (scNewTxHex != null) {
                    String receivedScNewTxHex = null;
                    boolean rs = false;
                    for (int i = txSize - 1; i >= 0; --i) {
                        String txHex = txStrList.get(i);
                        int txType = TxUtil.extractTxTypeFromTx(txHex);
                        if (txType != 19) continue;
                        receivedScNewTxHex = txHex;
                        if (!txHex.equals(scNewTxHex)) break;
                        rs = true;
                        break;
                    }
                    if (!rs) {
                        logger.error("contract error.Contract generatedgasReturn transaction:{}, - Received contractgasReturn transaction\uff1a{}", new Object[]{scNewTxHex, receivedScNewTxHex});
                        throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
                    }
                    if (returnGasIndex != -1) {
                        contractGenerateTxs.remove(returnGasIndex);
                    }
                } else if (null != scReturnGas) {
                    throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
                }
            } else if (null != scReturnGas) {
                throw new NulsException(TxErrorCode.EXIST_GAS_RETURN_WITHOUT_SC_RETURN);
            }
        }
        String coinBaseTx = null;
        for (TxVerifyWrapper txVerifyWrapper : txList) {
            Transaction tx = txVerifyWrapper.getTx();
            if (tx.getType() != 1) continue;
            coinBaseTx = txVerifyWrapper.getTxStr();
            break;
        }
        String stateRootNew = ConsensusCall.triggerCoinBaseContract(chain, coinBaseTx, blockHeaderStr, scStateRoot);
        String stateRoot = RPCUtil.encode((byte[])blockHeader.getExtendsData().getStateRoot());
        if (!stateRoot.equals(stateRootNew)) {
            logger.warn("contract stateRoot error.");
            throw new NulsException(TxErrorCode.CONTRACT_VERIFY_FAIL);
        }
        try {
            for (Future future : futures) {
                if (((Boolean)future.get()).booleanValue()) continue;
                logger.error("batchVerify failed, single tx verify failed");
                throw new NulsException(TxErrorCode.TX_VERIFY_FAIL);
            }
        }
        catch (InterruptedException e) {
            logger.error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        catch (ExecutionException e) {
            logger.error((Exception)e);
            throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Verify block transactions] Total execution time:{}, - height:{} - Number of block transactions:{}" + TxUtil.nextLine(), new Object[]{NulsDateUtils.getCurrentTimeMillis() - s1, blockHeight, txStrList.size()});
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("value", true);
        resultMap.put("contractList", contractGenerateTxs);
        return resultMap;
    }

    private Map processContractResultV8(Chain chain, List<TxPackageWrapper> packingTxList, Set<TxPackageWrapper> orphanTxSet, List<String> contractGenerateTxs, List<String> originTxList, long blockHeight, boolean contractBefore, String stateRoot) throws IOException {
        boolean hasTxbackPackablePool = false;
        boolean isRollbackPackablePool = false;
        HashSet<String> setLimitedRollbackOriginTx = new HashSet<String>();
        if (!contractBefore) {
            isRollbackPackablePool = true;
        } else {
            try {
                Map<String, Object> map = ContractCall.contractPackageBatchEnd(chain, blockHeight);
                List returnGasTx = (List)map.get("txList");
                contractGenerateTxs.addAll(returnGasTx);
                if (null != contractGenerateTxs) {
                    String sr;
                    ArrayList<String> scNewConsensusList = new ArrayList<String>();
                    ArrayList<String> scNewTokenCrossTransferList = new ArrayList<String>();
                    for (int i = 0; i < contractGenerateTxs.size(); ++i) {
                        String scNewTx = contractGenerateTxs.get(i);
                        int scNewTxType = TxUtil.extractTxTypeFromTx(scNewTx);
                        if (scNewTxType == 20 || scNewTxType == 21 || scNewTxType == 22 || scNewTxType == 23) {
                            scNewConsensusList.add(scNewTx);
                            setLimitedRollbackOriginTx.add(originTxList.get(i));
                            continue;
                        }
                        if (scNewTxType != 26) continue;
                        scNewTokenCrossTransferList.add(scNewTx);
                    }
                    if (!scNewConsensusList.isEmpty() || !scNewTokenCrossTransferList.isEmpty()) {
                        ArrayList<String> consensusList = new ArrayList<String>();
                        ArrayList<String> crossTransferList = new ArrayList<String>();
                        for (TxPackageWrapper txPackageWrapper : packingTxList) {
                            Transaction tx = txPackageWrapper.getTx();
                            if (ModuleE.CS.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) {
                                consensusList.add(RPCUtil.encode((byte[])txPackageWrapper.getTx().serialize()));
                            }
                            if (!ModuleE.CC.abbr.equals(ResponseMessageProcessor.TX_TYPE_MODULE_MAP.get(tx.getType()))) continue;
                            crossTransferList.add(RPCUtil.encode((byte[])txPackageWrapper.getTx().serialize()));
                        }
                        consensusList.addAll(scNewConsensusList);
                        crossTransferList.addAll(scNewTokenCrossTransferList);
                        if (!consensusList.isEmpty()) {
                            isRollbackPackablePool = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CS.abbr), consensusList, packingTxList, false);
                        }
                        if (!isRollbackPackablePool && !crossTransferList.isEmpty()) {
                            isRollbackPackablePool = this.processContractTxs(chain, (String)ResponseMessageProcessor.ROLE_MAPPING.get(ModuleE.CC.abbr), crossTransferList, packingTxList, false);
                        }
                    }
                    if (!isRollbackPackablePool && null != (sr = (String)map.get("stateRoot"))) {
                        stateRoot = sr;
                    }
                }
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                isRollbackPackablePool = true;
            }
        }
        if (isRollbackPackablePool) {
            Iterator<TxPackageWrapper> iterator = packingTxList.iterator();
            while (iterator.hasNext()) {
                TxPackageWrapper txPackageWrapper = iterator.next();
                if (!TxManager.isUnSystemSmartContract(chain, txPackageWrapper.getTx().getType())) continue;
                if (setLimitedRollbackOriginTx.contains(txPackageWrapper.getTx().getHash().toHex())) {
                    this.addOrphanTxSet(chain, orphanTxSet, txPackageWrapper);
                } else {
                    orphanTxSet.add(txPackageWrapper);
                }
                iterator.remove();
                if (hasTxbackPackablePool) continue;
                hasTxbackPackablePool = true;
            }
        }
        HashMap<String, Object> rs = new HashMap<String, Object>();
        rs.put("stateRoot", stateRoot);
        rs.put("hasTxbackPackablePool", hasTxbackPackablePool);
        return rs;
    }
}

