/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.storage.ConfirmedTxStorageService;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class ConfirmedTxStorageServiceImpl
implements ConfirmedTxStorageService {
    @Override
    public boolean saveTx(int chainId, TransactionConfirmedPO tx) {
        if (tx == null) {
            return false;
        }
        byte[] txHashBytes = tx.getTx().getHash().getBytes();
        boolean result = false;
        try {
            result = RocksDBService.put((String)("tx_table_confirmed_" + chainId), (byte[])txHashBytes, (byte[])tx.serialize());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return result;
    }

    @Override
    public boolean saveTxList(int chainId, List<TransactionConfirmedPO> txList) {
        if (null == txList || txList.size() == 0) {
            throw new NulsRuntimeException(TxErrorCode.PARAMETER_ERROR);
        }
        HashMap<byte[], byte[]> txPoMap = new HashMap<byte[], byte[]>();
        try {
            for (TransactionConfirmedPO tx : txList) {
                txPoMap.put(tx.getTx().getHash().getBytes(), tx.serialize());
            }
            return RocksDBService.batchPut((String)("tx_table_confirmed_" + chainId), txPoMap);
        }
        catch (IOException e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(TxErrorCode.DESERIALIZE_TX_ERROR);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(TxErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public TransactionConfirmedPO getTx(int chainId, NulsHash hash) {
        if (hash == null) {
            return null;
        }
        return this.getTx(chainId, hash.getBytes());
    }

    @Override
    public TransactionConfirmedPO getTx(int chainId, String hash) {
        if (StringUtils.isBlank((String)hash)) {
            return null;
        }
        return this.getTx(chainId, HexUtil.decode((String)hash));
    }

    private TransactionConfirmedPO getTx(int chainId, byte[] hashSerialize) {
        byte[] txBytes = RocksDBService.get((String)("tx_table_confirmed_" + chainId), (byte[])hashSerialize);
        TransactionConfirmedPO tx = null;
        if (null != txBytes) {
            try {
                tx = (TransactionConfirmedPO)((Object)TxUtil.getInstance(txBytes, TransactionConfirmedPO.class));
            }
            catch (Exception e) {
                LoggerUtil.LOG.error(e);
                return null;
            }
        }
        return tx;
    }

    @Override
    public boolean removeTx(int chainId, String hash) {
        boolean result = false;
        try {
            result = RocksDBService.delete((String)("tx_table_confirmed_" + chainId), (byte[])HexUtil.decode((String)hash));
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return result;
    }

    @Override
    public boolean removeTx(int chainId, NulsHash hash) {
        boolean result = false;
        try {
            result = RocksDBService.delete((String)("tx_table_confirmed_" + chainId), (byte[])hash.getBytes());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return result;
    }

    @Override
    public boolean removeTxList(int chainId, List<Transaction> txList) {
        ArrayList<byte[]> hashList = new ArrayList<byte[]>();
        for (Transaction tx : txList) {
            hashList.add(tx.getHash().getBytes());
        }
        return this.removeTxListByHashBytes(chainId, hashList);
    }

    @Override
    public boolean removeTxListByHashBytes(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return false;
        }
        try {
            return RocksDBService.deleteKeys((String)("tx_table_confirmed_" + chainId), hashList);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return false;
        }
    }

    @Override
    public boolean isExists(int chainId, NulsHash hash) {
        byte[] txBytes = RocksDBService.get((String)("tx_table_confirmed_" + chainId), (byte[])hash.getBytes());
        return null != txBytes && txBytes.length > 0;
    }

    @Override
    public List<Transaction> getTxList(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return null;
        }
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        List list = RocksDBService.multiGetAsList((String)("tx_table_confirmed_" + chainId), hashList);
        if (list != null) {
            for (byte[] txBytes : list) {
                try {
                    TransactionConfirmedPO tx = (TransactionConfirmedPO)((Object)TxUtil.getInstance(txBytes, TransactionConfirmedPO.class));
                    txList.add(tx.getTx());
                }
                catch (NulsException e) {
                    LoggerUtil.LOG.error(e);
                }
            }
        }
        return txList;
    }

    @Override
    public List<byte[]> getExistTxs(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return null;
        }
        return RocksDBService.multiGetAsList((String)("tx_table_confirmed_" + chainId), hashList);
    }

    private class CrossTxEffectList
    extends BaseNulsData {
        List<NulsHash> hashList;

        private CrossTxEffectList() {
        }

        protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
            int fromCount = this.hashList == null ? 0 : this.hashList.size();
            stream.writeVarInt(fromCount);
            if (null != this.hashList) {
                for (NulsHash hash : this.hashList) {
                    stream.write(hash.getBytes());
                }
            }
        }

        public void parse(NulsByteBuffer byteBuffer) throws NulsException {
            int fromCount = (int)byteBuffer.readVarInt();
            if (0 < fromCount) {
                ArrayList<NulsHash> hashs = new ArrayList<NulsHash>();
                for (int i = 0; i < fromCount; ++i) {
                    hashs.add(byteBuffer.readHash());
                }
                this.hashList = hashs;
            }
        }

        public int size() {
            int size = SerializeUtils.sizeOfVarInt((Integer)(this.hashList == null ? 0 : this.hashList.size()));
            if (null != this.hashList) {
                size += this.hashList.size() * 32;
            }
            return size;
        }
    }
}

