/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.task;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.Orphans;
import io.nuls.transaction.model.bo.VerifyLedgerResult;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.OrphanSort;
import io.nuls.transaction.utils.TxDuplicateRemoval;
import io.nuls.transaction.utils.TxUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrphanTxProcessTask
implements Runnable {
    private Chain chain;
    private PackablePool packablePool = (PackablePool)SpringLiteContext.getBean(PackablePool.class);
    private TxService txService = (TxService)SpringLiteContext.getBean(TxService.class);
    private UnconfirmedTxStorageService unconfirmedTxStorageService = (UnconfirmedTxStorageService)SpringLiteContext.getBean(UnconfirmedTxStorageService.class);
    private OrphanSort orphanSort = (OrphanSort)SpringLiteContext.getBean(OrphanSort.class);

    public OrphanTxProcessTask(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        try {
            this.doOrphanTxTask(this.chain);
        }
        catch (Exception e) {
            this.chain.getLogger().error("OrphanTxProcessTask Exception");
            this.chain.getLogger().error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOrphanTxTask(Chain chain) throws NulsException {
        if (chain.getProtocolUpgrade().get()) {
            chain.getLogger().info("Protocol upgrade pause process orphan tx..");
            return;
        }
        LinkedList<TransactionNetPO> chainOrphan = chain.getOrphanList();
        if (chainOrphan.size() == 0) {
            return;
        }
        LinkedList<TransactionNetPO> orphanTxList = new LinkedList<TransactionNetPO>();
        LinkedList<TransactionNetPO> linkedList = chainOrphan;
        synchronized (linkedList) {
            orphanTxList.addAll(chainOrphan);
            chainOrphan.clear();
        }
        try {
            this.orphanSort.rank(orphanTxList);
            boolean flag = true;
            while (flag) {
                flag = this.process(orphanTxList);
            }
        }
        catch (RuntimeException e) {
            try {
                chain.getLogger().error("[OrphanTxProcessTask] RuntimeException:{}", new Object[]{e.getMessage()});
                throw new NulsException(TxErrorCode.SYS_UNKOWN_EXCEPTION);
            }
            catch (Throwable throwable) {
                if (orphanTxList.size() > 0) {
                    LinkedList<TransactionNetPO> linkedList2 = chainOrphan;
                    synchronized (linkedList2) {
                        chainOrphan.addAll(orphanTxList);
                        int size = chainOrphan.size();
                        chain.getLogger().debug("[OrphanTxProcessTask] OrphanTxList size:{}", new Object[]{size});
                    }
                }
                chain.getLogger().debug("Processing completed, current total number of orphan transactionschainOrphan:{}", new Object[]{chainOrphan.size()});
                throw throwable;
            }
        }
        if (orphanTxList.size() > 0) {
            LinkedList<TransactionNetPO> flag = chainOrphan;
            synchronized (flag) {
                chainOrphan.addAll(orphanTxList);
                int size = chainOrphan.size();
                chain.getLogger().debug("[OrphanTxProcessTask] OrphanTxList size:{}", new Object[]{size});
            }
        }
        chain.getLogger().debug("Processing completed, current total number of orphan transactionschainOrphan:{}", new Object[]{chainOrphan.size()});
    }

    private boolean process(List<TransactionNetPO> orphanTxList) {
        boolean flag = false;
        Iterator<TransactionNetPO> it = orphanTxList.iterator();
        while (it.hasNext()) {
            if (this.chain.getProtocolUpgrade().get()) {
                return false;
            }
            TransactionNetPO txNet = it.next();
            boolean rs = this.processOrphanTx(this.chain, txNet);
            if (!rs) continue;
            this.chain.getOrphanListDataSize().addAndGet(Math.negateExact(txNet.getTx().size()));
            it.remove();
            flag = true;
        }
        return flag;
    }

    private boolean processOrphanTx(Chain chain, TransactionNetPO txNet) {
        try {
            Transaction tx = txNet.getTx();
            int chainId = chain.getChainId();
            if (this.txService.isTxExists(chain, tx.getHash())) {
                return true;
            }
            int packableTxMapDataSize = 0;
            for (Transaction transaction : chain.getPackableTxMap().values()) {
                packableTxMapDataSize += transaction.size();
            }
            if (TxUtil.discardTx(chain, packableTxMapDataSize, tx)) {
                String hash = tx.getHash().toHex();
                NetworkCall.broadcastTx(chain, tx, TxDuplicateRemoval.getExcludeNode(hash));
                return true;
            }
            VerifyLedgerResult verifyLedgerResult = LedgerCall.commitUnconfirmedTx(chain, RPCUtil.encode((byte[])tx.serialize()));
            if (verifyLedgerResult.businessSuccess()) {
                if (chain.getPackaging().get()) {
                    this.packablePool.add(chain, tx);
                }
                this.unconfirmedTxStorageService.putTx(chainId, tx);
                String hash = tx.getHash().toHex();
                NetworkCall.forwardTxHash(chain, tx.getHash(), TxDuplicateRemoval.getExcludeNode(hash));
                return true;
            }
            if (!verifyLedgerResult.getSuccess()) {
                chain.getLogger().error("[OrphanTxProcessTask] tx coinData verify fail - code:{}, type:{}, - txhash:{}", new Object[]{verifyLedgerResult.getErrorCode() == null ? "" : verifyLedgerResult.getErrorCode().getCode(), tx.getType(), tx.getHash().toHex()});
                return true;
            }
            long currentTimeSeconds = NulsDateUtils.getCurrentTimeSeconds();
            boolean rs = tx.getTime() < currentTimeSeconds - (long)chain.getConfig().getOrphanTtl();
            return rs;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    private boolean orphanTxTask(Chain chain) throws NulsException {
        Map<String, Orphans> map = chain.getOrphanMap();
        Iterator<Map.Entry<String, Orphans>> it = map.entrySet().iterator();
        boolean rs = false;
        while (it.hasNext()) {
            Map.Entry<String, Orphans> entry = it.next();
            Orphans orphans = entry.getValue();
            boolean isRemove = false;
            Orphans currentOrphan = orphans;
            while (null != currentOrphan) {
                if (this.processOrphanTx(chain, currentOrphan.getTx())) {
                    if (!isRemove) {
                        isRemove = true;
                    }
                    if (null != currentOrphan.getNext()) {
                        currentOrphan = currentOrphan.getNext();
                        continue;
                    }
                }
                currentOrphan = null;
            }
            if (!isRemove) continue;
            it.remove();
            rs = true;
        }
        int size = map.size();
        if (size > 0) {
            chain.getLogger().debug("** Number of orphan transaction strings\uff1a{} ", new Object[]{map.size()});
        }
        return rs;
    }
}

