/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.utils;

import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.transaction.model.bo.OrphanSortItem;
import io.nuls.transaction.model.bo.OrphanSortResult;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Component
public class OrphanSort {
    public void rank(List<TransactionNetPO> txList) {
        HashMap groupMap = new HashMap();
        for (TransactionNetPO tx : txList) {
            long second = tx.getTx().getTime();
            ArrayList<TransactionNetPO> subList = (ArrayList<TransactionNetPO>)groupMap.get(second);
            if (null == subList) {
                subList = new ArrayList<TransactionNetPO>();
                groupMap.put(second, subList);
            }
            tx.setOrphanSortSerial(second * 10000L);
            subList.add(tx);
        }
        for (List list : groupMap.values()) {
            this.sameTimeRank(list);
        }
        Collections.sort(txList, new Comparator<TransactionNetPO>(){

            @Override
            public int compare(TransactionNetPO o1, TransactionNetPO o2) {
                if (o1.getOrphanSortSerial() > o2.getOrphanSortSerial()) {
                    return 1;
                }
                if (o1.getOrphanSortSerial() < o2.getOrphanSortSerial()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private void sameTimeRank(List<TransactionNetPO> txList) {
        if (txList.size() <= 1) {
            return;
        }
        OrphanSortResult result = new OrphanSortResult(txList.size());
        txList.forEach(po -> this.doRank(result, new OrphanSortItem<TransactionNetPO>((TransactionNetPO)((Object)po))));
        int index = 0;
        for (TransactionNetPO po2 : result.getList()) {
            po2.setOrphanSortSerial(po2.getOrphanSortSerial() + (long)index++);
        }
    }

    private void doRank(OrphanSortResult<TransactionNetPO> result, OrphanSortItem<TransactionNetPO> thisItem) {
        if (result.getIndex() == -1) {
            result.getArray()[0] = thisItem;
            result.setIndex(0);
            return;
        }
        OrphanSortItem[] array = result.getArray();
        boolean gotFront = false;
        boolean gotNext = false;
        int gotIndex = -1;
        boolean added = false;
        for (int i = result.getIndex(); i >= 0; --i) {
            int x;
            OrphanSortItem item = array[i];
            int val = this.compareTo(thisItem.getObj(), (TransactionNetPO)((Object)item.getObj()));
            if (val == 1 && !gotNext) {
                item.setFlower(new OrphanSortItem[]{thisItem});
                item.setHasFlower(true);
                this.insertArray(i + 1, result, result.getIndex() + 1, thisItem, false);
                gotFront = true;
                gotIndex = i + 1;
                added = true;
                continue;
            }
            if (val == 1 && gotNext) {
                int x2;
                thisItem = result.getArray()[gotIndex];
                if (i == gotIndex - 1) {
                    item.setHasFlower(true);
                    return;
                }
                boolean hasFlower = thisItem.isHasFlower();
                OrphanSortItem[] flower = new OrphanSortItem[1];
                int count = 0;
                if (hasFlower) {
                    count = 1;
                }
                int realCount = 1;
                for (x2 = 1; x2 <= count; ++x2) {
                    OrphanSortItem flr;
                    flower[x2 - 1] = flr = array[x2 + gotIndex];
                    ++realCount;
                    if (x2 != count || !flr.isHasFlower()) continue;
                    ++count;
                    OrphanSortItem[] flower2 = new OrphanSortItem[flower.length + 1];
                    System.arraycopy(flower, 0, flower2, 0, flower.length);
                    flower = flower2;
                }
                thisItem.setFlower(flower);
                if (flower.length > 0) {
                    thisItem.setHasFlower(true);
                }
                item.setHasFlower(true);
                for (x2 = 0; x2 < result.getIndex() - gotIndex + 1; ++x2) {
                    int oldIndex = gotIndex + x2 + realCount;
                    if (oldIndex <= result.getIndex()) {
                        array[gotIndex + x2] = array[oldIndex];
                        array[oldIndex] = null;
                        continue;
                    }
                    array[gotIndex + x2] = null;
                }
                result.setIndex(result.getIndex() - realCount);
                this.insertArray(i + 1, result, result.getIndex() + 1, thisItem, true);
                return;
            }
            if (val == -1 && !gotFront) {
                thisItem.setHasFlower(true);
                this.insertArray(i, result, result.getIndex() + 1, thisItem, false);
                gotNext = true;
                gotIndex = i;
                added = true;
                continue;
            }
            if (val != -1 || !gotFront) continue;
            if (gotIndex == i - 1) {
                return;
            }
            thisItem.setHasFlower(true);
            thisItem = result.getArray()[i];
            boolean hasFlower = thisItem.isHasFlower();
            int count = hasFlower ? 1 : 0;
            int realCount = 1;
            OrphanSortItem[] flower = new OrphanSortItem[count];
            for (x = 1; x <= count; ++x) {
                OrphanSortItem flr;
                flower[x - 1] = flr = array[x + i];
                ++realCount;
                if (x != count || !flr.isHasFlower()) continue;
                ++count;
                OrphanSortItem[] flower2 = new OrphanSortItem[flower.length + 1];
                System.arraycopy(flower, 0, flower2, 0, flower.length);
                flower = flower2;
            }
            thisItem.setFlower(flower);
            for (x = 0; x < result.getIndex() - i + 1; ++x) {
                int oldIndex = i + x + realCount;
                if (oldIndex <= result.getIndex()) {
                    array[i + x] = array[oldIndex];
                    array[oldIndex] = null;
                    continue;
                }
                array[i + x] = null;
            }
            result.setIndex(result.getIndex() - realCount);
            this.insertArray(gotIndex + 1 - realCount, result, result.getIndex() + 1, thisItem, true);
            return;
        }
        if (!added) {
            this.insertArray(result.getIndex() + 1, result, result.getIndex() + 1, thisItem, false);
        }
    }

    private void insertArray(int index, OrphanSortResult result, int length, OrphanSortItem item, boolean insertFlowers) {
        OrphanSortItem[] array = result.getArray();
        int count = 1 + item.getFlower().length;
        result.setIndex(result.getIndex() + count);
        if (length >= index) {
            try {
                for (int i = length - 1; i >= index; --i) {
                    array[i + count] = array[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
        }
        array[index] = item;
        if (null == item.getFlower() || !insertFlowers) {
            return;
        }
        int add = 1;
        OrphanSortItem[] orphanSortItemArray = item.getFlower();
        int n = orphanSortItemArray.length;
        for (int i = 0; i < n; ++i) {
            OrphanSortItem f;
            array[index + add] = f = orphanSortItemArray[i];
            ++add;
        }
    }

    private int compareTo(TransactionNetPO txNeto1, TransactionNetPO txNeto2) {
        Transaction o1 = txNeto1.getTx();
        Transaction o2 = txNeto2.getTx();
        if (null == o1 && null == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        if (o1.equals((Object)o2)) {
            return 0;
        }
        try {
            if (null == o1.getCoinData() && null == o2.getCoinData()) {
                return 0;
            }
            if (null == o1.getCoinData()) {
                return 1;
            }
            if (null == o2.getCoinData()) {
                return -1;
            }
            CoinData o1CoinData = o1.getCoinDataInstance();
            CoinData o2CoinData = o2.getCoinDataInstance();
            if (null == o1CoinData && null == o2CoinData) {
                return 0;
            }
            if (null == o1CoinData) {
                return 1;
            }
            if (null == o2CoinData) {
                return -1;
            }
            if (null == o1CoinData.getFrom() && null == o2CoinData.getFrom()) {
                return 0;
            }
            if (null == o1CoinData.getFrom()) {
                return 1;
            }
            if (null == o2CoinData.getFrom()) {
                return -1;
            }
            byte[] o2HashPrefix = TxUtil.getNonce(o2.getHash().getBytes());
            for (CoinFrom o1CoinFrom : o1CoinData.getFrom()) {
                if (!Arrays.equals(o2HashPrefix, o1CoinFrom.getNonce())) continue;
                return 1;
            }
            byte[] o1HashPrefix = TxUtil.getNonce(o1.getHash().getBytes());
            for (CoinFrom o2CoinFrom : o2CoinData.getFrom()) {
                if (!Arrays.equals(o1HashPrefix, o2CoinFrom.getNonce())) continue;
                return -1;
            }
            return 0;
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            return 0;
        }
    }
}

