/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.utils;

import io.nuls.core.crypto.HexUtil;
import io.nuls.transaction.utils.HashSetDuplicateProcessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TxDuplicateRemoval {
    private static HashSetDuplicateProcessor processorOfTx = new HashSetDuplicateProcessor(1000000);
    private static Map<String, StringBuffer> forwardHashExcludeNodesMap = new ConcurrentHashMap<String, StringBuffer>();
    private static int maxSize = 20000;

    public static boolean exist(String hash) {
        return processorOfTx.contains(hash);
    }

    public static boolean insertAndCheck(String hash) {
        return processorOfTx.insertAndCheck(hash);
    }

    public static void putExcludeNode(String hash, String newExcludeNode) {
        StringBuffer excludeNodes;
        if (forwardHashExcludeNodesMap.size() >= maxSize) {
            forwardHashExcludeNodesMap.clear();
        }
        if (null != (excludeNodes = forwardHashExcludeNodesMap.putIfAbsent(hash, new StringBuffer(newExcludeNode)))) {
            excludeNodes.append(",").append(newExcludeNode);
            forwardHashExcludeNodesMap.put(hash, excludeNodes);
        }
    }

    public static String getExcludeNode(String hash) {
        StringBuffer excludeNodes = forwardHashExcludeNodesMap.get(hash);
        if (null != excludeNodes) {
            return excludeNodes.toString();
        }
        return null;
    }

    public static void removeExcludeNode(String hash) {
        forwardHashExcludeNodesMap.remove(hash);
    }

    public static void removeExcludeNode(List<byte[]> hashs) {
        for (byte[] hash : hashs) {
            forwardHashExcludeNodesMap.remove(HexUtil.encode((byte[])hash));
        }
    }

    public static int sizeExcludeNode() {
        return forwardHashExcludeNodesMap.size();
    }
}

