/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.utils;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.constant.TxContext;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxRegister;
import io.nuls.transaction.rpc.call.AccountCall;
import io.nuls.transaction.utils.LoggerUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TxUtil {
    public static byte[] blackHolePublicKey = null;

    public static CoinData getCoinData(Transaction tx) throws NulsException {
        if (null == tx) {
            throw new NulsException(TxErrorCode.TX_NOT_EXIST);
        }
        try {
            return tx.getCoinDataInstance();
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(TxErrorCode.DESERIALIZE_COINDATA_ERROR);
        }
    }

    public static Transaction getTransaction(byte[] txBytes) throws NulsException {
        if (null == txBytes || txBytes.length == 0) {
            throw new NulsException(TxErrorCode.DATA_NOT_FOUND);
        }
        try {
            return Transaction.getInstance((byte[])txBytes);
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(TxErrorCode.DESERIALIZE_TX_ERROR);
        }
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (null == bytes || bytes.length == 0) {
            throw new NulsException(TxErrorCode.DATA_NOT_FOUND);
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(TxErrorCode.DESERIALIZE_ERROR);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(TxErrorCode.DESERIALIZE_ERROR);
        }
    }

    public static <T> T getInstanceRpcStr(String data, Class<? extends BaseNulsData> clazz) throws NulsException {
        return TxUtil.getInstance(RPCUtil.decode((String)data), clazz);
    }

    public static <T> T getInstance(String hex, Class<? extends BaseNulsData> clazz) throws NulsException {
        return TxUtil.getInstance(HexUtil.decode((String)hex), clazz);
    }

    public static boolean isNulsAsset(Coin coin) {
        return TxUtil.isNulsAsset(coin.getAssetsChainId(), coin.getAssetsId());
    }

    public static boolean isNulsAsset(int chainId, int assetId) {
        NulsCoresConfig txConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        return chainId == txConfig.getMainChainId() && assetId == txConfig.getMainAssetId();
    }

    public static boolean isChainAssetExist(Chain chain, Coin coin) {
        return chain.getConfig().getChainId() == coin.getAssetsChainId() && chain.getConfig().getAssetId() == coin.getAssetsId();
    }

    public static String extractContractAddress(byte[] txData) {
        if (txData == null) {
            return null;
        }
        int length = txData.length;
        if (length < 46) {
            return null;
        }
        byte[] contractAddress = new byte[23];
        System.arraycopy(txData, 23, contractAddress, 0, 23);
        return AddressTool.getStringAddressByBytes((byte[])contractAddress);
    }

    public static int getCrossTxFromsOriginChainId(Transaction tx) throws NulsException {
        CoinData coinData = TxUtil.getCoinData(tx);
        if (null == coinData.getFrom() || coinData.getFrom().size() == 0) {
            throw new NulsException(TxErrorCode.COINFROM_NOT_FOUND);
        }
        return AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress());
    }

    public static int getCrossTxTosOriginChainId(Transaction tx) throws NulsException {
        CoinData coinData = TxUtil.getCoinData(tx);
        if (null == coinData.getTo() || coinData.getTo().size() == 0) {
            throw new NulsException(TxErrorCode.COINFROM_NOT_FOUND);
        }
        return AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
    }

    public static boolean isLegalContractAddress(byte[] addressBytes, Chain chain) {
        if (addressBytes == null) {
            return false;
        }
        return AddressTool.validContractAddress((byte[])addressBytes, (int)chain.getChainId());
    }

    public static void txInformationDebugPrint(Transaction tx) {
        if (tx.getType() == 1) {
            return;
        }
        LoggerUtil.LOG.debug("");
        LoggerUtil.LOG.debug("**************************************************");
        LoggerUtil.LOG.debug("Transaction information");
        LoggerUtil.LOG.debug("type: {}", new Object[]{tx.getType()});
        LoggerUtil.LOG.debug("txHash: {}", new Object[]{tx.getHash().toHex()});
        LoggerUtil.LOG.debug("time: {}", new Object[]{NulsDateUtils.timeStamp2DateStr((long)tx.getTime())});
        LoggerUtil.LOG.debug("size: {}B,  -{}KB, -{}MB", new Object[]{String.valueOf(tx.getSize()), String.valueOf(tx.getSize() / 1024), String.valueOf(tx.getSize() / 1024 / 1024)});
        byte[] remark = tx.getRemark();
        try {
            String remarkStr = remark == null ? "" : new String(tx.getRemark(), "UTF-8");
            LoggerUtil.LOG.debug("remark: {}", new Object[]{remarkStr});
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtil.LOG.error((Exception)e);
        }
        CoinData coinData = null;
        try {
            if (tx.getCoinData() != null) {
                coinData = tx.getCoinDataInstance();
            }
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
        }
        if (coinData != null) {
            LoggerUtil.LOG.debug("coinData:");
            List coinFromList = coinData.getFrom();
            if (coinFromList == null) {
                LoggerUtil.LOG.debug("\tcoinFrom: null");
            } else if (coinFromList.size() == 0) {
                LoggerUtil.LOG.debug("\tcoinFrom: size 0");
            } else {
                LoggerUtil.LOG.debug("\tcoinFrom: ");
                for (int i = 0; i < coinFromList.size(); ++i) {
                    CoinFrom coinFrom = (CoinFrom)coinFromList.get(i);
                    LoggerUtil.LOG.debug("\tFROM_{}:", new Object[]{i});
                    LoggerUtil.LOG.debug("\taddress: {}", new Object[]{AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress())});
                    LoggerUtil.LOG.debug("\tamount: {}", new Object[]{coinFrom.getAmount()});
                    LoggerUtil.LOG.debug("\tassetChainId: [{}]", new Object[]{coinFrom.getAssetsChainId()});
                    LoggerUtil.LOG.debug("\tassetId: [{}]", new Object[]{coinFrom.getAssetsId()});
                    LoggerUtil.LOG.debug("\tnonce: {}", new Object[]{HexUtil.encode((byte[])coinFrom.getNonce())});
                    LoggerUtil.LOG.debug("\tlocked(0Ordinary transactions,-1Unlock amount transaction\uff08Exit consensus, exit delegation)): [{}]", new Object[]{coinFrom.getLocked()});
                    LoggerUtil.LOG.debug("");
                }
            }
            List coinToList = coinData.getTo();
            if (coinToList == null) {
                LoggerUtil.LOG.debug("\tcoinTo: null");
            } else if (coinToList.size() == 0) {
                LoggerUtil.LOG.debug("\tcoinTo: size 0");
            } else {
                LoggerUtil.LOG.debug("\tcoinTo: ");
                for (int i = 0; i < coinToList.size(); ++i) {
                    CoinTo coinTo = (CoinTo)coinToList.get(i);
                    LoggerUtil.LOG.debug("\tTO_{}:", new Object[]{i});
                    LoggerUtil.LOG.debug("\taddress: {}", new Object[]{AddressTool.getStringAddressByBytes((byte[])coinTo.getAddress())});
                    LoggerUtil.LOG.debug("\tamount: {}", new Object[]{coinTo.getAmount()});
                    LoggerUtil.LOG.debug("\tassetChainId: [{}]", new Object[]{coinTo.getAssetsChainId()});
                    LoggerUtil.LOG.debug("\tassetId: [{}]", new Object[]{coinTo.getAssetsId()});
                    LoggerUtil.LOG.debug("\tlocked(Unlocking height or unlocking time,-1To permanently lock): [{}]", new Object[]{coinTo.getLockTime()});
                    LoggerUtil.LOG.debug("");
                }
            }
        } else {
            LoggerUtil.LOG.debug("coinData: null");
        }
        LoggerUtil.LOG.debug("**************************************************");
        LoggerUtil.LOG.debug("");
    }

    public static void moduleGroups(Chain chain, Map<String, List<String>> moduleVerifyMap, Transaction tx) throws NulsException {
        String txStr;
        try {
            txStr = RPCUtil.encode((byte[])tx.serialize());
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
        TxUtil.moduleGroups(chain, moduleVerifyMap, tx.getType(), txStr);
    }

    public static void moduleGroups(Chain chain, Map<String, List<String>> moduleVerifyMap, int txType, String txStr) {
        TxRegister txRegister = TxManager.getTxRegister(chain, txType);
        TxUtil.moduleGroups(moduleVerifyMap, txRegister, txStr);
    }

    public static void moduleGroups(Map<String, List<String>> moduleVerifyMap, TxRegister txRegister, String txStr) {
        String moduleCode = txRegister.getModuleCode();
        if (moduleVerifyMap.containsKey(moduleCode)) {
            moduleVerifyMap.get(moduleCode).add(txStr);
        } else {
            ArrayList<String> txStrList = new ArrayList<String>();
            txStrList.add(txStr);
            moduleVerifyMap.put(moduleCode, txStrList);
        }
    }

    public static byte[] getNonce(byte[] preHash) {
        byte[] nonce = new byte[8];
        int copyEnd = preHash.length;
        System.arraycopy(preHash, copyEnd - 8, nonce, 0, 8);
        return nonce;
    }

    public static int extractTxTypeFromTx(String txString) throws NulsException {
        String txTypeHexString = txString.substring(0, 4);
        NulsByteBuffer byteBuffer = new NulsByteBuffer(RPCUtil.decode((String)txTypeHexString));
        return byteBuffer.readUint16();
    }

    public static boolean discardTx(Chain chain, int packableTxMapDataSize, Transaction tx) {
        Random random = new Random();
        int number = random.nextInt(10);
        if (packableTxMapDataSize >= 75000000) {
            chain.getLogger().debug("Packable pool tx data size reach the 100% discard transaction threshold, hash:{}", new Object[]{tx.getHash().toHex()});
            return true;
        }
        if (packableTxMapDataSize >= 60000000) {
            if (number < 8) {
                chain.getLogger().debug("Packable pool tx data size reach the 80% discard transaction threshold, hash:{}", new Object[]{tx.getHash().toHex()});
                return true;
            }
        } else if (packableTxMapDataSize >= 45000000 && number < 5) {
            chain.getLogger().debug("Packable pool tx data size reach the 50% discard transaction threshold, hash:{}", new Object[]{tx.getHash().toHex()});
            return true;
        }
        return false;
    }

    public static Collection getDiffent(Collection collectionMax, Collection collectionMin) {
        LinkedList<Object> collection = new LinkedList<Object>();
        Collection max = collectionMax;
        Collection min = collectionMin;
        if (collectionMax.size() < collectionMin.size()) {
            max = collectionMin;
            min = collectionMax;
        }
        HashMap map = new HashMap(max.size() * 2);
        for (Object e : max) {
            map.put(e, 1);
        }
        for (Object e : min) {
            if (map.get(e) == null) {
                collection.add(e);
                continue;
            }
            map.put(e, 2);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            collection.add(entry.getKey());
        }
        return collection;
    }

    public static Collection getDiffentNoDuplicate(Collection collmax, Collection collmin) {
        return new HashSet(TxUtil.getDiffent(collmax, collmin));
    }

    public static String nextLine() {
        String lineSeparator = System.getProperty("line.separator");
        return lineSeparator + lineSeparator;
    }

    public static boolean isBlackHoleAddress(int chainId, byte[] address) {
        if (address == null) {
            return false;
        }
        int chainIdByAddress = AddressTool.getChainIdByAddress((byte[])address);
        if (chainIdByAddress != 1) {
            return false;
        }
        String contractAddress = AddressTool.getStringAddressByBytes((byte[])address);
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= TxContext.UPDATE_VERSION_V250) {
            return AddressTool.BLOCK_HOLE_ADDRESS_SET.contains(contractAddress) || AddressTool.BLOCK_HOLE_ADDRESS_SET_5.contains(contractAddress);
        }
        return AddressTool.BLOCK_HOLE_ADDRESS_SET.contains(contractAddress);
    }

    public static boolean isBlockAddress(int chainId, byte[] address) {
        if (address == null) {
            return false;
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) < TxContext.UPDATE_VERSION_ACCOUNT_BLOCK) {
            return false;
        }
        String addressStr = AddressTool.getStringAddressByBytes((byte[])address);
        return AccountCall.isBlockAccount(chainId, addressStr);
    }
}

