/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import io.nuls.core.crypto.HexUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ethereum.config.BlockchainNetConfig;
import org.ethereum.config.Constants;
import org.ethereum.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperties {
    private static Logger logger = LoggerFactory.getLogger((String)"general");
    public static final String PROPERTY_DB_DIR = "database.dir";
    public static final String PROPERTY_LISTEN_PORT = "peer.listen.port";
    public static final String PROPERTY_PEER_ACTIVE = "peer.active";
    public static final String PROPERTY_DB_RESET = "database.reset";
    public static final String PROPERTY_PEER_DISCOVERY_ENABLED = "peer.discovery.enabled";
    private static final Boolean DEFAULT_VMTEST_LOAD_LOCAL = false;
    private static final String DEFAULT_BLOCKS_LOADER = "";
    private static SystemProperties CONFIG;
    private static boolean useOnlySpringConfig;
    private String generatedNodePrivateKey;
    private Config config;
    private String databaseDir = null;
    private Boolean databaseReset = null;
    private String projectVersion = null;
    private String projectVersionModifier = null;
    protected Integer databaseVersion = null;
    private String genesisInfo = null;
    private String bindIp = null;
    private String externalIp = null;
    private Boolean syncEnabled = null;
    private Boolean discoveryEnabled = null;
    private BlockchainNetConfig blockchainConfig;
    private Boolean vmTrace;
    private Boolean recordInternalTransactionsData;

    public static SystemProperties getDefault() {
        return useOnlySpringConfig ? null : SystemProperties.getSpringDefault();
    }

    static SystemProperties getSpringDefault() {
        if (CONFIG == null) {
            CONFIG = new SystemProperties();
        }
        return CONFIG;
    }

    public static void resetToDefault() {
        CONFIG = null;
    }

    public static void setUseOnlySpringConfig(boolean useOnlySpringConfig) {
        SystemProperties.useOnlySpringConfig = useOnlySpringConfig;
    }

    static boolean isUseOnlySpringConfig() {
        return useOnlySpringConfig;
    }

    public SystemProperties() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("cache.flush.writeCacheSize", 64);
        values.put("cache.flush.blocks", 0);
        values.put("cache.flush.shortSyncFlush", true);
        values.put("cache.stateCacheSize", 384);
        values.put("crypto.providerName", "BC");
        values.put("crypto.hash.alg256", "ETH-KECCAK-256");
        values.put("crypto.hash.alg512", "ETH-KECCAK-512");
        values.put("database.maxOpenFiles", 2048);
        values.put("database.prune.enabled", false);
        values.put("database.prune.maxDepth", 192);
        values.put("keyvalue.datasource", DEFAULT_BLOCKS_LOADER);
        this.config = ConfigFactory.parseMap(values);
    }

    public static List<InputStream> loadResources(String name, ClassLoader classLoader) throws IOException {
        ArrayList<InputStream> list = new ArrayList<InputStream>();
        Enumeration<URL> systemResources = (classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader).getResources(name);
        while (systemResources.hasMoreElements()) {
            list.add(systemResources.nextElement().openStream());
        }
        return list;
    }

    public Config getConfig() {
        return this.config;
    }

    public void overrideParams(Config overrideOptions) {
        this.config = overrideOptions.withFallback((ConfigMergeable)this.config);
        this.validateConfig();
    }

    public void overrideParams(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new RuntimeException("Odd argument number");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        this.overrideParams(map);
    }

    public void overrideParams(Map<String, ?> cliOptions) {
        Config cliConf = ConfigFactory.parseMap(cliOptions);
        this.overrideParams(cliConf);
    }

    private void validateConfig() {
        for (Method method : this.getClass().getMethods()) {
            try {
                if (!method.isAnnotationPresent(ValidateMe.class)) continue;
                method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error validating config method: " + method, e);
            }
        }
    }

    protected Config mergeConfigs(String input, Function<String, Config> parserFunc) {
        Config config = ConfigFactory.empty();
        if (input != null && !input.isEmpty()) {
            String[] list = input.split(",");
            for (int i = list.length - 1; i >= 0; --i) {
                config = config.withFallback((ConfigMergeable)parserFunc.apply(list[i]));
            }
        }
        return config;
    }

    public <T> T getProperty(String propName, T defaultValue) {
        if (!this.config.hasPath(propName)) {
            return defaultValue;
        }
        String string = this.config.getString(propName);
        if (string.trim().isEmpty()) {
            return defaultValue;
        }
        return (T)this.config.getAnyRef(propName);
    }

    public BlockchainNetConfig getBlockchainConfig() {
        if (this.blockchainConfig == null) {
            this.blockchainConfig = new BlockchainNetConfig(){

                @Override
                public Constants getCommonConstants() {
                    return new Constants();
                }
            };
        }
        return this.blockchainConfig;
    }

    public void setBlockchainConfig(BlockchainNetConfig config) {
        this.blockchainConfig = config;
    }

    @ValidateMe
    public boolean peerDiscovery() {
        return this.discoveryEnabled == null ? this.config.getBoolean(PROPERTY_PEER_DISCOVERY_ENABLED) : this.discoveryEnabled.booleanValue();
    }

    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    @ValidateMe
    public boolean peerDiscoveryPersist() {
        return this.config.getBoolean("peer.discovery.persist");
    }

    @ValidateMe
    public int peerDiscoveryWorkers() {
        return this.config.getInt("peer.discovery.workers");
    }

    @ValidateMe
    public int peerDiscoveryTouchPeriod() {
        return this.config.getInt("peer.discovery.touchPeriod");
    }

    @ValidateMe
    public int peerDiscoveryTouchMaxNodes() {
        return this.config.getInt("peer.discovery.touchMaxNodes");
    }

    @ValidateMe
    public int peerConnectionTimeout() {
        return this.config.getInt("peer.connection.timeout") * 1000;
    }

    @ValidateMe
    public int transactionApproveTimeout() {
        return this.config.getInt("transaction.approve.timeout") * 1000;
    }

    @ValidateMe
    public List<String> peerDiscoveryIPList() {
        return this.config.getStringList("peer.discovery.ip.list");
    }

    @ValidateMe
    public boolean databaseReset() {
        return this.databaseReset == null ? this.config.getBoolean(PROPERTY_DB_RESET) : this.databaseReset.booleanValue();
    }

    public void setDatabaseReset(Boolean reset) {
        this.databaseReset = reset;
    }

    @ValidateMe
    public long databaseResetBlock() {
        return this.config.getLong("database.resetBlock");
    }

    @ValidateMe
    public boolean databaseFromBackup() {
        return this.config.getBoolean("database.fromBackup");
    }

    @ValidateMe
    public int databasePruneDepth() {
        return this.config.getBoolean("database.prune.enabled") ? this.config.getInt("database.prune.maxDepth") : -1;
    }

    @ValidateMe
    public Integer blockQueueSize() {
        return this.config.getInt("cache.blockQueueSize") * 1024 * 1024;
    }

    @ValidateMe
    public Integer headerQueueSize() {
        return this.config.getInt("cache.headerQueueSize") * 1024 * 1024;
    }

    @ValidateMe
    public Integer peerChannelReadTimeout() {
        return this.config.getInt("peer.channel.read.timeout");
    }

    @ValidateMe
    public Integer traceStartBlock() {
        return this.config.getInt("trace.startblock");
    }

    @ValidateMe
    public boolean recordBlocks() {
        return this.config.getBoolean("record.blocks");
    }

    @ValidateMe
    public boolean dumpFull() {
        return this.config.getBoolean("dump.full");
    }

    @ValidateMe
    public String dumpDir() {
        return this.config.getString("dump.dir");
    }

    @ValidateMe
    public String dumpStyle() {
        return this.config.getString("dump.style");
    }

    @ValidateMe
    public int dumpBlock() {
        return this.config.getInt("dump.block");
    }

    @ValidateMe
    public String databaseDir() {
        return this.databaseDir == null ? this.config.getString(PROPERTY_DB_DIR) : this.databaseDir;
    }

    public String ethashDir() {
        return this.config.hasPath("ethash.dir") ? this.config.getString("ethash.dir") : this.databaseDir();
    }

    public void setDataBaseDir(String dataBaseDir) {
        this.databaseDir = dataBaseDir;
    }

    @ValidateMe
    public boolean dumpCleanOnRestart() {
        return this.config.getBoolean("dump.clean.on.restart");
    }

    @ValidateMe
    public boolean playVM() {
        return this.config.getBoolean("play.vm");
    }

    @ValidateMe
    public boolean blockChainOnly() {
        return this.config.getBoolean("blockchain.only");
    }

    @ValidateMe
    public int syncPeerCount() {
        return this.config.getInt("sync.peer.count");
    }

    public Integer syncVersion() {
        if (!this.config.hasPath("sync.version")) {
            return null;
        }
        return this.config.getInt("sync.version");
    }

    @ValidateMe
    public boolean exitOnBlockConflict() {
        return this.config.getBoolean("sync.exitOnBlockConflict");
    }

    @ValidateMe
    public String projectVersion() {
        return this.projectVersion;
    }

    @ValidateMe
    public Integer databaseVersion() {
        return this.databaseVersion;
    }

    @ValidateMe
    public String projectVersionModifier() {
        return this.projectVersionModifier;
    }

    @ValidateMe
    public String helloPhrase() {
        return this.config.getString("hello.phrase");
    }

    @ValidateMe
    public String rootHashStart() {
        return this.config.hasPath("root.hash.start") ? this.config.getString("root.hash.start") : null;
    }

    @ValidateMe
    public List<String> peerCapabilities() {
        return this.config.getStringList("peer.capabilities");
    }

    @ValidateMe
    public boolean vmTrace() {
        return this.vmTrace == null ? (this.vmTrace = Boolean.valueOf(this.config.getBoolean("vm.structured.trace"))) : this.vmTrace;
    }

    @ValidateMe
    public boolean vmTraceCompressed() {
        return this.config.getBoolean("vm.structured.compressed");
    }

    @ValidateMe
    public int vmTraceInitStorageLimit() {
        return this.config.getInt("vm.structured.initStorageLimit");
    }

    @ValidateMe
    public int cacheFlushBlocks() {
        return this.config.getInt("cache.flush.blocks");
    }

    @ValidateMe
    public String vmTraceDir() {
        return this.config.getString("vm.structured.dir");
    }

    public String customSolcPath() {
        return this.config.hasPath("solc.path") ? this.config.getString("solc.path") : null;
    }

    @ValidateMe
    public int networkId() {
        return this.config.getInt("peer.networkId");
    }

    @ValidateMe
    public int maxActivePeers() {
        return this.config.getInt("peer.maxActivePeers");
    }

    @ValidateMe
    public boolean eip8() {
        return this.config.getBoolean("peer.p2p.eip8");
    }

    @ValidateMe
    public int listenPort() {
        return this.config.getInt(PROPERTY_LISTEN_PORT);
    }

    public String bindIp() {
        if (!this.config.hasPath("peer.discovery.bind.ip") || this.config.getString("peer.discovery.bind.ip").trim().isEmpty()) {
            if (this.bindIp == null) {
                logger.debug("Bind address wasn't set, Punching to identify it...");
                try (Socket s = new Socket("www.google.com", 80);){
                    this.bindIp = s.getLocalAddress().getHostAddress();
                    logger.debug("UDP local bound to: {}", (Object)this.bindIp);
                }
                catch (IOException e) {
                    logger.warn("Can't get bind IP. Fall back to 0.0.0.0: " + e);
                    this.bindIp = "0.0.0.0";
                }
            }
            return this.bindIp;
        }
        return this.config.getString("peer.discovery.bind.ip").trim();
    }

    public String externalIp() {
        if (!this.config.hasPath("peer.discovery.external.ip") || this.config.getString("peer.discovery.external.ip").trim().isEmpty()) {
            if (this.externalIp == null) {
                logger.debug("External IP wasn't set, using checkip.amazonaws.com to identify it...");
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream()));
                    this.externalIp = in.readLine();
                    if (this.externalIp == null || this.externalIp.trim().isEmpty()) {
                        throw new IOException("Invalid address: '" + this.externalIp + "'");
                    }
                    try {
                        InetAddress.getByName(this.externalIp);
                    }
                    catch (Exception e) {
                        throw new IOException("Invalid address: '" + this.externalIp + "'");
                    }
                    logger.debug("External address identified: {}", (Object)this.externalIp);
                }
                catch (IOException e) {
                    this.externalIp = this.bindIp();
                    logger.warn("Can't get external IP. Fall back to peer.bind.ip: " + this.externalIp + " :" + e);
                }
            }
            return this.externalIp;
        }
        return this.config.getString("peer.discovery.external.ip").trim();
    }

    @ValidateMe
    public String getKeyValueDataSource() {
        return this.config.getString("keyvalue.datasource");
    }

    @ValidateMe
    public boolean isSyncEnabled() {
        return this.syncEnabled == null ? this.config.getBoolean("sync.enabled") : this.syncEnabled.booleanValue();
    }

    public void setSyncEnabled(Boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    @ValidateMe
    public boolean isFastSyncEnabled() {
        return this.isSyncEnabled() && this.config.getBoolean("sync.fast.enabled");
    }

    @ValidateMe
    public byte[] getFastSyncPivotBlockHash() {
        if (!this.config.hasPath("sync.fast.pivotBlockHash")) {
            return null;
        }
        byte[] ret = HexUtil.decode((String)this.config.getString("sync.fast.pivotBlockHash"));
        if (ret.length != 32) {
            throw new RuntimeException("Invalid block hash length: " + ByteUtil.toHexString(ret));
        }
        return ret;
    }

    @ValidateMe
    public boolean fastSyncBackupState() {
        return this.config.getBoolean("sync.fast.backupState");
    }

    @ValidateMe
    public boolean fastSyncSkipHistory() {
        return this.config.getBoolean("sync.fast.skipHistory");
    }

    @ValidateMe
    public int makeDoneByTimeout() {
        return this.config.getInt("sync.makeDoneByTimeout");
    }

    @ValidateMe
    public boolean isPublicHomeNode() {
        return this.config.getBoolean("peer.discovery.public.home.node");
    }

    @ValidateMe
    public String genesisInfo() {
        return this.genesisInfo == null ? this.config.getString("genesis") : this.genesisInfo;
    }

    @ValidateMe
    public int txOutdatedThreshold() {
        return this.config.getInt("transaction.outdated.threshold");
    }

    public void setGenesisInfo(String genesisInfo) {
        this.genesisInfo = genesisInfo;
    }

    @ValidateMe
    public boolean minerStart() {
        return this.config.getBoolean("mine.start");
    }

    @ValidateMe
    public byte[] getMinerCoinbase() {
        String sc = this.config.getString("mine.coinbase");
        byte[] c = ByteUtil.hexStringToBytes(sc);
        if (c.length != 20) {
            throw new RuntimeException("mine.coinbase has invalid value: '" + sc + "'");
        }
        return c;
    }

    @ValidateMe
    public byte[] getMineExtraData() {
        byte[] bytes = this.config.hasPath("mine.extraDataHex") ? HexUtil.decode((String)this.config.getString("mine.extraDataHex")) : this.config.getString("mine.extraData").getBytes();
        if (bytes.length > 32) {
            throw new RuntimeException("mine.extraData exceed 32 bytes length: " + bytes.length);
        }
        return bytes;
    }

    @ValidateMe
    public BigInteger getMineMinGasPrice() {
        return new BigInteger(this.config.getString("mine.minGasPrice"));
    }

    @ValidateMe
    public long getMineMinBlockTimeoutMsec() {
        return this.config.getLong("mine.minBlockTimeoutMsec");
    }

    @ValidateMe
    public int getMineCpuThreads() {
        return this.config.getInt("mine.cpuMineThreads");
    }

    @ValidateMe
    public boolean isMineFullDataset() {
        return this.config.getBoolean("mine.fullDataSet");
    }

    @ValidateMe
    public String getCryptoProviderName() {
        return this.config.getString("crypto.providerName");
    }

    @ValidateMe
    public boolean recordInternalTransactionsData() {
        if (this.recordInternalTransactionsData == null) {
            this.recordInternalTransactionsData = this.config.getBoolean("record.internal.transactions.entity");
        }
        return this.recordInternalTransactionsData;
    }

    public void setRecordInternalTransactionsData(Boolean recordInternalTransactionsData) {
        this.recordInternalTransactionsData = recordInternalTransactionsData;
    }

    @ValidateMe
    public String getHash256AlgName() {
        return this.config.getString("crypto.hash.alg256");
    }

    @ValidateMe
    public String getHash512AlgName() {
        return this.config.getString("crypto.hash.alg512");
    }

    @ValidateMe
    public String getEthashMode() {
        return this.config.getString("sync.ethash");
    }

    public String dump() {
        return this.config.root().render(ConfigRenderOptions.defaults().setComments(false));
    }

    public boolean vmTestLoadLocal() {
        return this.config.hasPath("GitHubTests.VMTest.loadLocal") ? this.config.getBoolean("GitHubTests.VMTest.loadLocal") : DEFAULT_VMTEST_LOAD_LOCAL.booleanValue();
    }

    public String blocksLoader() {
        return this.config.hasPath("blocks.loader") ? this.config.getString("blocks.loader") : DEFAULT_BLOCKS_LOADER;
    }

    public String githubTestsPath() {
        return this.config.hasPath("GitHubTests.testPath") ? this.config.getString("GitHubTests.testPath") : DEFAULT_BLOCKS_LOADER;
    }

    public boolean githubTestsLoadLocal() {
        return this.config.hasPath("GitHubTests.testPath") && !this.config.getString("GitHubTests.testPath").isEmpty();
    }

    static {
        useOnlySpringConfig = false;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ValidateMe {
    }
}

