/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.core;

import java.math.BigInteger;
import org.bouncycastle.util.Arrays;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.FastByteComparisons;
import org.ethereum.util.RLP;
import org.ethereum.util.RLPElement;
import org.ethereum.util.RLPList;

public class BlockHeader {
    private byte[] parentHash;
    private byte[] hash;
    private long number;

    public BlockHeader(byte[] encoded) {
        this((RLPList)RLP.decode2(encoded).get(0));
    }

    public BlockHeader(RLPList rlpHeader) {
        this.parentHash = ((RLPElement)rlpHeader.get(0)).getRLPData();
        this.hash = ((RLPElement)rlpHeader.get(1)).getRLPData();
        byte[] nrBytes = ((RLPElement)rlpHeader.get(2)).getRLPData();
        this.number = ByteUtil.byteArrayToLong(nrBytes);
    }

    public BlockHeader(byte[] parentHash, byte[] hash, long number) {
        this.parentHash = parentHash;
        this.hash = hash;
        this.number = number;
    }

    public byte[] getParentHash() {
        return this.parentHash;
    }

    public long getNumber() {
        return this.number;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getEncoded() {
        return this.getEncoded(true);
    }

    public byte[] getEncoded(boolean withNonce) {
        byte[] parentHash = RLP.encodeElement(this.parentHash);
        byte[] hash = RLP.encodeElement(this.hash);
        byte[] number = RLP.encodeBigInteger(BigInteger.valueOf(this.number));
        return RLP.encodeList(parentHash, hash, number);
    }

    public String toString() {
        return this.toStringWithSuffix("\n");
    }

    private String toStringWithSuffix(String suffix) {
        StringBuilder toStringBuff = new StringBuilder();
        toStringBuff.append("  hash=").append(ByteUtil.toHexString(this.hash)).append(suffix);
        toStringBuff.append("  parentHash=").append(ByteUtil.toHexString(this.parentHash)).append(suffix);
        toStringBuff.append("  number=").append(this.number).append(suffix);
        return toStringBuff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHeader that = (BlockHeader)o;
        return FastByteComparisons.equal(this.getHash(), that.getHash());
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getHash());
    }
}

