/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.core;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Set;
import org.ethereum.core.AccountState;
import org.ethereum.core.Block;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.db.ContractDetails;
import org.ethereum.vm.DataWord;

public interface Repository
extends org.ethereum.facade.Repository {
    public AccountState createAccount(byte[] var1, byte[] var2);

    @Override
    public boolean isExist(byte[] var1);

    public AccountState getAccountState(byte[] var1);

    public void delete(byte[] var1);

    public BigInteger increaseNonce(byte[] var1);

    public BigInteger setNonce(byte[] var1, BigInteger var2);

    @Override
    public BigInteger getNonce(byte[] var1);

    public ContractDetails getContractDetails(byte[] var1);

    public boolean hasContractDetails(byte[] var1);

    public void saveCode(byte[] var1, byte[] var2);

    @Override
    public byte[] getCode(byte[] var1);

    public byte[] getCodeHash(byte[] var1);

    public void addStorageRow(byte[] var1, DataWord var2, DataWord var3);

    @Override
    public DataWord getStorageValue(byte[] var1, DataWord var2);

    @Override
    public BigInteger getBalance(byte[] var1);

    public BigInteger addBalance(byte[] var1, BigInteger var2);

    public Set<byte[]> getAccountsKeys();

    public void dumpState(Block var1, long var2, int var4, byte[] var5);

    public Repository startTracking();

    public void flush();

    public void flushNoReconnect();

    public void commit();

    public void rollback();

    public void syncToRoot(byte[] var1);

    public boolean isClosed();

    public void close();

    public void reset();

    public void updateBatch(HashMap<ByteArrayWrapper, AccountState> var1, HashMap<ByteArrayWrapper, ContractDetails> var2);

    public byte[] getRoot();

    public void loadAccount(byte[] var1, HashMap<ByteArrayWrapper, AccountState> var2, HashMap<ByteArrayWrapper, ContractDetails> var3);

    public Repository getSnapshotTo(byte[] var1);

    public Repository clone();
}

