/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.crypto;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Random;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.util.encoders.Hex;
import org.ethereum.config.SystemProperties;
import org.ethereum.crypto.jce.SpongyCastleProvider;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.RLP;
import org.ethereum.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HashUtil.class);
    public static final byte[] EMPTY_DATA_HASH;
    public static final byte[] EMPTY_LIST_HASH;
    public static final byte[] EMPTY_TRIE_HASH;
    private static final Provider CRYPTO_PROVIDER;
    private static final String HASH_256_ALGORITHM_NAME;
    private static final String HASH_512_ALGORITHM_NAME;

    public static byte[] sha256(byte[] input) {
        try {
            MessageDigest sha256digest = MessageDigest.getInstance("SHA-256");
            return sha256digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input1, byte[] input2) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input1, 0, input1.length);
            digest.update(input2, 0, input2.length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input, int start, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input, start, length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha512(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_512_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] ripemd160(byte[] data) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        if (data != null) {
            byte[] resBuf = new byte[digest.getDigestSize()];
            digest.update(data, 0, data.length);
            digest.doFinal(resBuf, 0);
            return resBuf;
        }
        throw new NullPointerException("Can't hash a NULL value");
    }

    public static byte[] sha3omit12(byte[] input) {
        byte[] hash = HashUtil.sha3(input);
        return Arrays.copyOfRange(hash, 12, hash.length);
    }

    public static byte[] calcNewAddr(byte[] addr, byte[] nonce) {
        byte[] encSender = RLP.encodeElement(addr);
        byte[] encNonce = RLP.encodeBigInteger(new BigInteger(1, nonce));
        return HashUtil.sha3omit12(RLP.encodeList(encSender, encNonce));
    }

    public static byte[] calcSaltAddr(byte[] senderAddr, byte[] initCode, byte[] salt) {
        byte[] data = new byte[1 + senderAddr.length + salt.length + 32];
        data[0] = -1;
        int currentOffset = 1;
        System.arraycopy(senderAddr, 0, data, currentOffset, senderAddr.length);
        System.arraycopy(salt, 0, data, currentOffset += senderAddr.length, salt.length);
        byte[] sha3InitCode = HashUtil.sha3(initCode);
        System.arraycopy(sha3InitCode, 0, data, currentOffset += salt.length, sha3InitCode.length);
        return HashUtil.sha3omit12(data);
    }

    public static byte[] doubleDigest(byte[] input) {
        return HashUtil.doubleDigest(input, 0, input.length);
    }

    public static byte[] doubleDigest(byte[] input, int offset, int length) {
        try {
            MessageDigest sha256digest = MessageDigest.getInstance("SHA-256");
            sha256digest.reset();
            sha256digest.update(input, offset, length);
            byte[] first = sha256digest.digest();
            return sha256digest.digest(first);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't find such algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] randomPeerId() {
        byte[] peerIdBytes = new BigInteger(512, Utils.getRandom()).toByteArray();
        String peerId = peerIdBytes.length > 64 ? Hex.toHexString((byte[])peerIdBytes, (int)1, (int)64) : Hex.toHexString((byte[])peerIdBytes);
        return Hex.decode((String)peerId);
    }

    public static byte[] randomHash() {
        byte[] randomHash = new byte[32];
        Random random = new Random();
        random.nextBytes(randomHash);
        return randomHash;
    }

    public static String shortHash(byte[] hash) {
        return Hex.toHexString((byte[])hash).substring(0, 6);
    }

    static {
        SystemProperties props = SystemProperties.getDefault();
        Security.addProvider(SpongyCastleProvider.getInstance());
        String cryptoProviderName = props.getCryptoProviderName();
        CRYPTO_PROVIDER = Security.getProvider(cryptoProviderName);
        HASH_256_ALGORITHM_NAME = props.getHash256AlgName();
        HASH_512_ALGORITHM_NAME = props.getHash512AlgName();
        EMPTY_DATA_HASH = HashUtil.sha3(ByteUtil.EMPTY_BYTE_ARRAY);
        EMPTY_LIST_HASH = HashUtil.sha3(RLP.encodeList(new byte[0][]));
        EMPTY_TRIE_HASH = HashUtil.sha3(RLP.encodeElement(ByteUtil.EMPTY_BYTE_ARRAY));
    }
}

