/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.MemSizeEstimator;
import org.ethereum.datasource.Source;

public abstract class AbstractCachedSource<Key, Value>
extends AbstractChainedSource<Key, Value, Key, Value>
implements CachedSource<Key, Value> {
    private final Object lock = new Object();
    protected MemSizeEstimator<Key> keySizeEstimator;
    protected MemSizeEstimator<Value> valueSizeEstimator;
    private int size = 0;

    public AbstractCachedSource(Source<Key, Value> source) {
        super(source);
    }

    abstract Entry<Value> getCached(Key var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheAdded(Key key, Value value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.keySizeEstimator != null) {
                this.size = (int)((long)this.size + this.keySizeEstimator.estimateSize(key));
            }
            if (this.valueSizeEstimator != null) {
                this.size = (int)((long)this.size + this.valueSizeEstimator.estimateSize(value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheRemoved(Key key, Value value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.keySizeEstimator != null) {
                this.size = (int)((long)this.size - this.keySizeEstimator.estimateSize(key));
            }
            if (this.valueSizeEstimator != null) {
                this.size = (int)((long)this.size - this.valueSizeEstimator.estimateSize(value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCleared() {
        Object object = this.lock;
        synchronized (object) {
            this.size = 0;
        }
    }

    public AbstractCachedSource<Key, Value> withSizeEstimators(MemSizeEstimator<Key> keySizeEstimator, MemSizeEstimator<Value> valueSizeEstimator) {
        this.keySizeEstimator = keySizeEstimator;
        this.valueSizeEstimator = valueSizeEstimator;
        return this;
    }

    @Override
    public long estimateCacheSize() {
        return this.size;
    }

    static final class SimpleEntry<V>
    implements Entry<V> {
        private V val;

        public SimpleEntry(V val) {
            this.val = val;
        }

        @Override
        public V value() {
            return this.val;
        }
    }

    public static interface Entry<V> {
        public V value();
    }
}

