/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.AsyncFlushable;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.WriteCache;
import org.ethereum.util.ALock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncWriteCache<Key, Value>
extends AbstractCachedSource<Key, Value>
implements AsyncFlushable {
    private static final Logger logger = LoggerFactory.getLogger((String)"db");
    private static ListeningExecutorService flushExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("AsyncWriteCacheThread-%d").build()));
    protected volatile WriteCache<Key, Value> curCache;
    protected WriteCache<Key, Value> flushingCache;
    private ListenableFuture<Boolean> lastFlush = Futures.immediateFuture((Object)false);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ALock rLock = new ALock(this.rwLock.readLock());
    private final ALock wLock = new ALock(this.rwLock.writeLock());
    private String name = "<null>";

    public AsyncWriteCache(Source<Key, Value> source) {
        super(source);
        this.flushingCache = this.createCache(source);
        this.flushingCache.setFlushSource(true);
        this.curCache = this.createCache(this.flushingCache);
    }

    protected abstract WriteCache<Key, Value> createCache(Source<Key, Value> var1);

    @Override
    public Collection<Key> getModified() {
        try (ALock l = this.rLock.lock();){
            Collection<Key> collection = this.curCache.getModified();
            return collection;
        }
    }

    @Override
    public boolean hasModified() {
        try (ALock l = this.rLock.lock();){
            boolean bl = this.curCache.hasModified();
            return bl;
        }
    }

    @Override
    public void put(Key key, Value val) {
        try (ALock l = this.rLock.lock();){
            this.curCache.put(key, val);
        }
    }

    @Override
    public void delete(Key key) {
        try (ALock l = this.rLock.lock();){
            this.curCache.delete(key);
        }
    }

    @Override
    public Value get(Key key) {
        try (ALock l = this.rLock.lock();){
            Value Value2 = this.curCache.get(key);
            return Value2;
        }
    }

    @Override
    public synchronized boolean flush() {
        try {
            this.flipStorage();
            this.flushAsync();
            return this.flushingCache.hasModified();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    AbstractCachedSource.Entry<Value> getCached(Key key) {
        return this.curCache.getCached(key);
    }

    @Override
    public synchronized void flipStorage() throws InterruptedException {
        try {
            if (!this.lastFlush.isDone()) {
                logger.debug("AsyncWriteCache (" + this.name + "): waiting for previous flush to complete");
            }
            this.lastFlush.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        try (ALock l = this.wLock.lock();){
            this.flushingCache.cache = this.curCache.cache;
            this.curCache = this.createCache(this.flushingCache);
        }
    }

    @Override
    public synchronized ListenableFuture<Boolean> flushAsync() throws InterruptedException {
        logger.debug("AsyncWriteCache (" + this.name + "): flush submitted");
        this.lastFlush = flushExecutor.submit(() -> {
            logger.debug("AsyncWriteCache (" + this.name + "): flush started");
            long s = System.currentTimeMillis();
            boolean ret = this.flushingCache.flush();
            logger.debug("AsyncWriteCache (" + this.name + "): flush completed in " + (System.currentTimeMillis() - s) + " ms");
            return ret;
        });
        return this.lastFlush;
    }

    @Override
    public long estimateCacheSize() {
        return (long)((double)this.curCache.estimateCacheSize() * 2.0);
    }

    @Override
    protected synchronized boolean flushImpl() {
        return false;
    }

    public AsyncWriteCache<Key, Value> withName(String name) {
        this.name = name;
        return this;
    }
}

