/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.io.Serializable;
import java.util.BitSet;
import org.ethereum.util.ByteUtil;

public class BloomFilter
implements Serializable {
    private BitSet bitset;
    private int bitSetSize;
    private double bitsPerElement;
    private int expectedNumberOfFilterElements;
    private int numberOfAddedElements;
    private int k;

    public BloomFilter(double c, int n, int k) {
        this.expectedNumberOfFilterElements = n;
        this.k = k;
        this.bitsPerElement = c;
        this.bitSetSize = (int)Math.ceil(c * (double)n);
        this.numberOfAddedElements = 0;
        this.bitset = new BitSet(this.bitSetSize);
    }

    public BloomFilter(int bitSetSize, int expectedNumberOElements) {
        this((double)bitSetSize / (double)expectedNumberOElements, expectedNumberOElements, (int)Math.round((double)bitSetSize / (double)expectedNumberOElements * Math.log(2.0)));
    }

    public BloomFilter(double falsePositiveProbability, int expectedNumberOfElements) {
        this(Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))) / Math.log(2.0), expectedNumberOfElements, (int)Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))));
    }

    public BloomFilter(int bitSetSize, int expectedNumberOfFilterElements, int actualNumberOfFilterElements, BitSet filterData) {
        this(bitSetSize, expectedNumberOfFilterElements);
        this.bitset = filterData;
        this.numberOfAddedElements = actualNumberOfFilterElements;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BloomFilter other = (BloomFilter)obj;
        if (this.expectedNumberOfFilterElements != other.expectedNumberOfFilterElements) {
            return false;
        }
        if (this.k != other.k) {
            return false;
        }
        if (this.bitSetSize != other.bitSetSize) {
            return false;
        }
        return this.bitset == other.bitset || this.bitset != null && this.bitset.equals(other.bitset);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.bitset != null ? this.bitset.hashCode() : 0);
        hash = 61 * hash + this.expectedNumberOfFilterElements;
        hash = 61 * hash + this.bitSetSize;
        hash = 61 * hash + this.k;
        return hash;
    }

    public double expectedFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.expectedNumberOfFilterElements);
    }

    public double getFalsePositiveProbability(double numberOfElements) {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * numberOfElements / (double)this.bitSetSize), this.k);
    }

    public double getFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.numberOfAddedElements);
    }

    public int getK() {
        return this.k;
    }

    public synchronized void clear() {
        this.bitset.clear();
        this.numberOfAddedElements = 0;
    }

    public synchronized void add(byte[] bytes) {
        int[] hashes;
        for (int hash : hashes = this.createHashes(bytes, this.k)) {
            this.bitset.set(Math.abs(hash % this.bitSetSize), true);
        }
        ++this.numberOfAddedElements;
    }

    private int[] createHashes(byte[] bytes, int k) {
        int[] ret = new int[k];
        if (bytes.length / 4 < k) {
            int[] maxHashes = new int[bytes.length / 4];
            ByteUtil.bytesToInts(bytes, maxHashes, false);
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = maxHashes[i % maxHashes.length];
            }
        } else {
            ByteUtil.bytesToInts(bytes, ret, false);
        }
        return ret;
    }

    public synchronized boolean contains(byte[] bytes) {
        int[] hashes;
        for (int hash : hashes = this.createHashes(bytes, this.k)) {
            if (this.bitset.get(Math.abs(hash % this.bitSetSize))) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean getBit(int bit) {
        return this.bitset.get(bit);
    }

    public synchronized void setBit(int bit, boolean value) {
        this.bitset.set(bit, value);
    }

    public synchronized BitSet getBitSet() {
        return this.bitset;
    }

    public synchronized int size() {
        return this.bitSetSize;
    }

    public synchronized int count() {
        return this.numberOfAddedElements;
    }

    public int getExpectedNumberOfElements() {
        return this.expectedNumberOfFilterElements;
    }

    public double getExpectedBitsPerElement() {
        return this.bitsPerElement;
    }

    public double getBitsPerElement() {
        return (double)this.bitSetSize / (double)this.numberOfAddedElements;
    }
}

