/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.HashMap;
import java.util.Map;
import org.ethereum.datasource.QuotientFilter;

public class CountingQuotientFilter
extends QuotientFilter {
    long FINGERPRINT_MASK;
    private Map<Long, Counter> counters = new HashMap<Long, Counter>();

    private CountingQuotientFilter(int quotientBits, int remainderBits) {
        super(quotientBits, remainderBits);
        this.FINGERPRINT_MASK = CountingQuotientFilter.LOW_MASK(this.QUOTIENT_BITS + this.REMAINDER_BITS);
    }

    public static CountingQuotientFilter create(long largestNumberOfElements, long startingElements) {
        QuotientFilter filter = QuotientFilter.create(largestNumberOfElements, startingElements);
        return new CountingQuotientFilter(filter.QUOTIENT_BITS, filter.REMAINDER_BITS);
    }

    @Override
    public synchronized void insert(long hash) {
        if (super.maybeContains(hash)) {
            this.addRef(hash);
        } else {
            super.insert(hash);
        }
    }

    @Override
    public synchronized void remove(long hash) {
        if (super.maybeContains(hash) && this.delRef(hash) < 0) {
            super.remove(hash);
        }
    }

    @Override
    protected long hash(byte[] bytes) {
        long hash = 1L;
        for (byte b : bytes) {
            hash = 31L * hash + (long)b;
        }
        return hash;
    }

    public synchronized int getCollisionNumber() {
        return this.counters.size();
    }

    public long getEntryNumber() {
        return this.entries;
    }

    public long getMaxInsertions() {
        return this.MAX_INSERTIONS;
    }

    private void addRef(long hash) {
        long fp = this.fingerprint(hash);
        Counter cnt = this.counters.get(fp);
        if (cnt == null) {
            this.counters.put(fp, new Counter());
        } else {
            ++cnt.refs;
        }
    }

    private int delRef(long hash) {
        long fp = this.fingerprint(hash);
        Counter cnt = this.counters.get(fp);
        if (cnt == null) {
            return -1;
        }
        if (--cnt.refs < 1) {
            this.counters.remove(fp);
        }
        return cnt.refs;
    }

    private long fingerprint(long hash) {
        return hash & this.FINGERPRINT_MASK;
    }

    private static class Counter {
        int refs = 1;

        private Counter() {
        }
    }
}

