/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

public class DbSettings {
    public static final DbSettings DEFAULT = new DbSettings().withMaxThreads(1).withMaxOpenFiles(32);
    int maxOpenFiles;
    int maxThreads;

    private DbSettings() {
    }

    public static DbSettings newInstance() {
        DbSettings settings = new DbSettings();
        settings.maxOpenFiles = DbSettings.DEFAULT.maxOpenFiles;
        settings.maxThreads = DbSettings.DEFAULT.maxThreads;
        return settings;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public DbSettings withMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public DbSettings withMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }
}

