/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.Collection;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.ReadCache;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.SourceChainBox;
import org.ethereum.datasource.WriteCache;

public class ReadWriteCache<Key, Value>
extends SourceChainBox<Key, Value, Key, Value>
implements CachedSource<Key, Value> {
    protected ReadCache<Key, Value> readCache;
    protected WriteCache<Key, Value> writeCache;

    protected ReadWriteCache(Source<Key, Value> source) {
        super(source);
    }

    public ReadWriteCache(Source<Key, Value> src, WriteCache.CacheType cacheType) {
        super(src);
        this.writeCache = new WriteCache<Key, Value>(src, cacheType);
        this.add(this.writeCache);
        this.readCache = new ReadCache<Key, Value>(this.writeCache);
        this.add(this.readCache);
        this.readCache.setFlushSource(true);
    }

    @Override
    public synchronized Collection<Key> getModified() {
        return this.writeCache.getModified();
    }

    @Override
    public boolean hasModified() {
        return this.writeCache.hasModified();
    }

    protected synchronized AbstractCachedSource.Entry<Value> getCached(Key key) {
        AbstractCachedSource.Entry<Value> v = this.readCache.getCached(key);
        if (v == null) {
            v = this.writeCache.getCached(key);
        }
        return v;
    }

    @Override
    public synchronized long estimateCacheSize() {
        return this.readCache.estimateCacheSize() + this.writeCache.estimateCacheSize();
    }

    public static class BytesKey<V>
    extends ReadWriteCache<byte[], V> {
        public BytesKey(Source<byte[], V> src, WriteCache.CacheType cacheType) {
            super(src);
            this.writeCache = new WriteCache.BytesKey<V>(src, cacheType);
            this.add(this.writeCache);
            this.readCache = new ReadCache.BytesKey(this.writeCache);
            this.add(this.readCache);
            this.readCache.setFlushSource(true);
        }
    }
}

